/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.tray.component;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.OperationLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.common.resources.utils.LiteCommonUtils;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import com.huawei.support.icslite.tray.component.TrayPanelEnum;
import com.huawei.support.icslite.tray.utils.TrayUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsLiteTray
extends TrayIcon {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(IcsLiteTray.class);
    private static final int ICSLITE_TRAY_MENU_COUNT = 10;
    private final JDialog dialog = new JDialog();

    public IcsLiteTray(Image image, String ps) {
        super(image, ps);
        this.dialog.setUndecorated(true);
        this.dialog.setAlwaysOnTop(true);
        this.dialog.setSize(190, 450);
        this.menuLayout();
        this.setImageAutoSize(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent event) {
                BigDecimal dialogWidth;
                Dimension screenSize;
                double screenWidth;
                BigDecimal width;
                double remainWidth;
                if (event.getButton() == 1) {
                    IcsLiteTray.this.dialog.setVisible(false);
                }
                if (event.getButton() != 3) {
                    return;
                }
                int dialogHorizontal = event.getX();
                int dialogVertical = event.getY();
                if (dialogVertical > IcsLiteTray.this.dialog.getHeight()) {
                    dialogVertical = dialogVertical - IcsLiteTray.this.dialog.getHeight() - 1;
                }
                if (dialogHorizontal > IcsLiteTray.this.dialog.getWidth() && (remainWidth = (width = BigDecimal.valueOf(screenWidth = (screenSize = Toolkit.getDefaultToolkit().getScreenSize()).getWidth())).subtract(dialogWidth = new BigDecimal(dialogHorizontal)).doubleValue()) < (double)IcsLiteTray.this.dialog.getWidth()) {
                    dialogHorizontal = dialogHorizontal - IcsLiteTray.this.dialog.getWidth() - 1;
                }
                IcsLiteTray.this.dialog.setLocation(dialogHorizontal, dialogVertical);
                IcsLiteTray.this.dialog.setVisible(true);
            }
        });
        this.dialog.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                IcsLiteTray.this.dialog.setVisible(false);
            }
        });
    }

    private void menuLayout() {
        JPanel innerPanel = this.getTrayPanel();
        this.dialog.add(innerPanel);
    }

    private JPanel getTrayPanel() {
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new GridLayout(10, 1));
        innerPanel.setBorder(new MatteBorder(0, 1, 0, 1, new Color(204, 204, 204)));
        for (TrayPanelEnum trayPanelParams : TrayPanelEnum.values()) {
            JPanel pagePanel = this.getButtonPanel(trayPanelParams.getText(), trayPanelParams.getDefaultIcon(), trayPanelParams.getHoverIcon(), trayPanelParams.isLast());
            innerPanel.add((Component)pagePanel, "Center");
            if (StringUtils.equals(trayPanelParams.getText(), I18nResources.INSTANCE.getValueByKey("tray.menu.feedback"))) {
                new OpenFeedBack().openFeedBack(pagePanel);
                continue;
            }
            if (StringUtils.equals(trayPanelParams.getText(), I18nResources.INSTANCE.getValueByKey("tray.menu.exit"))) {
                this.exitEvent(pagePanel);
                continue;
            }
            this.openPages(pagePanel, trayPanelParams.getOpenUrl());
        }
        return innerPanel;
    }

    private void openPages(JPanel mainPagePanel, String openUrl) {
        mainPagePanel.addMouseListener(new OpenMouseAdapter(openUrl));
    }

    private void exitEvent(JPanel exitPanel) {
        exitPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                boolean isExit = IcsLiteTray.this.exitApp();
                SystemTray systemTray = SystemTray.getSystemTray();
                TrayIcon[] trayIcons = systemTray.getTrayIcons();
                if (!isExit) {
                    return;
                }
                if (trayIcons != null) {
                    systemTray.remove(trayIcons[0]);
                }
                OperationLogUtils.INSTANCE.successOperationLog("icsliteTray", "EXIT", "The icslite tray exiting soon .");
                String appPath = System.getProperty("java.io.tmpdir") + "icslite.lock";
                File flagFile = FileUtils.getFile(appPath);
                if (flagFile.exists()) {
                    boolean isDel = flagFile.delete();
                    CodeCCUtils.INSTANCE.debugLog(LOG, String.format(Locale.ENGLISH, "The lite app lock delete status:%b", isDel));
                }
                IcsCommonServiceHandler.getInstance().exitApp();
                System.exit(0);
            }
        });
    }

    private JPanel getButtonPanel(String text, String defaultIcon, String hoverIcon, boolean isLast) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel(text, TrayUtils.createImageIcon(defaultIcon), 0);
        label.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        label.setBorder(new EmptyBorder(12, 10, 0, 0));
        panel.add((Component)label, "Center");
        panel.setBackground(new Color(255, 255, 255));
        if (isLast) {
            panel.setBorder(new MatteBorder(1, 0, 1, 0, new Color(204, 204, 204)));
        } else {
            panel.setBorder(new MatteBorder(1, 0, 0, 0, new Color(204, 204, 204)));
        }
        panel.addMouseListener(new PanelMouseAdapter(panel, label, defaultIcon, hoverIcon));
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        flowLayout.setHgap(0);
        panel.setLayout(flowLayout);
        panel.setCursor(Cursor.getPredefinedCursor(12));
        return panel;
    }

    private boolean exitApp() {
        boolean isExit = false;
        int option = 0;
        String title = I18nResources.INSTANCE.getValueByKey("tray.prompt.exit.title");
        String content = I18nResources.INSTANCE.getValueByKey("tray.prompt.exit.content");
        int operateButton = JOptionPane.showConfirmDialog(null, content, title, option);
        if (operateButton == 0) {
            isExit = true;
        }
        return isExit;
    }

    static class OpenMouseAdapter
    extends MouseAdapter {
        String openUrl;

        OpenMouseAdapter(String openUrl) {
            this.openUrl = openUrl;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            LiteCommonUtils.openHtml(this.openUrl);
        }
    }

    static class PanelMouseAdapter
    extends MouseAdapter {
        JPanel panel;
        JLabel label;
        String defaultIcon;
        String hoverIcon;

        PanelMouseAdapter(JPanel panel, JLabel label, String defaultIcon, String hoverIcon) {
            this.panel = panel;
            this.label = label;
            this.defaultIcon = defaultIcon;
            this.hoverIcon = hoverIcon;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.panel.setBackground(new Color(243, 249, 255));
            this.label.setIcon(TrayUtils.createImageIcon(this.hoverIcon));
            this.label.setForeground(new Color(0, 153, 204));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.panel.setBackground(new Color(255, 255, 255));
            this.label.setIcon(TrayUtils.createImageIcon(this.defaultIcon));
            this.label.setForeground(new Color(0, 0, 0));
        }
    }

    static class FeedBackAdapter
    extends MouseAdapter {
        FeedBackAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                Desktop.getDesktop().mail(new URI(TrayUtils.getFeedbackPage()));
            }
            catch (IOException exception) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "feedback page open failed.");
            }
            catch (URISyntaxException exception) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "feedback page open URISyntaxException.", (Throwable)exception);
            }
        }
    }

    static class OpenFeedBack {
        OpenFeedBack() {
        }

        public void openFeedBack(JPanel feedBackPanel) {
            feedBackPanel.addMouseListener(new FeedBackAdapter());
        }
    }
}

