/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.tray.messages;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.common.resources.messages.MessageWithLink;
import com.huawei.support.icslite.i18n.init.I18nResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.lang3.StringUtils;

public class TrayBubbleTips {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(TrayBubbleTips.class);
    private static JButton button;
    private static JFrame frame;

    public static boolean isJumpWindowsEvent(String content, String jumpUrl, String jumpType, String linkContent) {
        int operateButton;
        TrayBubbleTips.initFrame();
        button = new JButton(I18nResources.INSTANCE.getValueByKey("tray.gui.confirm.button"));
        Object[] buttons = new JButton[]{button};
        TrayBubbleTips.windowsClosedEvent();
        JPanel labelPanel = TrayBubbleTips.initPanel(content);
        if (StringUtils.isNotBlank(linkContent)) {
            JLabel jumpLabel = new JLabel(linkContent);
            jumpLabel.setCursor(new Cursor(12));
            TrayBubbleTips.jumpByType(jumpLabel, jumpUrl, jumpType);
            labelPanel.add((Component)jumpLabel, "Center");
        }
        return (operateButton = JOptionPane.showOptionDialog(frame, labelPanel, I18nResources.INSTANCE.getValueByKey("tray.gui.title"), 0, 0, null, buttons, buttons[0])) == -1;
    }

    public static boolean systemWindowsEvent(String content) {
        TrayBubbleTips.initFrame();
        String title = I18nResources.INSTANCE.getValueByKey("tray.prompt.exit.title");
        int operateButton = JOptionPane.showConfirmDialog(frame, content, title, 0);
        return operateButton == 1 || operateButton == -1;
    }

    public static void systemWindowsMessageTip(String content) {
        TrayBubbleTips.initFrame();
        String title = I18nResources.INSTANCE.getValueByKey("tray.prompt.exit.title");
        JOptionPane.showMessageDialog(frame, new MessageWithLink(content), title, 2);
    }

    private static JPanel initPanel(String content) {
        JLabel feedbackLabelContent = new JLabel(content);
        JLabel feedbackLabelEnd = new JLabel(I18nResources.INSTANCE.getValueByKey("tray.gui.end"));
        JPanel feedbackLabelPanel = new JPanel();
        feedbackLabelPanel.setLayout(new BorderLayout());
        feedbackLabelPanel.add((Component)feedbackLabelContent, "West");
        feedbackLabelPanel.add((Component)feedbackLabelEnd, "East");
        return feedbackLabelPanel;
    }

    private static void initFrame() {
        TrayBubbleTips.setWindowsUiStyle();
        frame = new JFrame();
        frame.setAlwaysOnTop(true);
        frame.setVisible(false);
    }

    public static void windowsClosedEvent() {
        button.addActionListener(event -> TrayBubbleTips.disposeWindow());
    }

    private static void jumpByType(JLabel jLabel, final String jumpUrl, final String jumpType) {
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    if (StringUtils.equals(jumpType, "feedback")) {
                        Desktop.getDesktop().mail(new URI(jumpUrl));
                    } else if (StringUtils.equals(jumpType, "browse")) {
                        Desktop.getDesktop().browse(new URI(jumpUrl));
                    } else {
                        CodeCCUtils.INSTANCE.errorLog(LOGGER, "Error jump type in tray!");
                    }
                    TrayBubbleTips.disposeWindow();
                }
                catch (IOException | URISyntaxException exception) {
                    CodeCCUtils.INSTANCE.errorLog(LOGGER, "JumpByType has exception", (Throwable)exception);
                }
            }
        });
    }

    public static void setWindowsUiStyle() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "set UI style error.", (Throwable)e);
        }
    }

    public static void disposeWindow() {
        Window win = SwingUtilities.getWindowAncestor(button);
        if (win != null) {
            win.dispose();
        }
        if (frame != null) {
            frame.dispose();
        }
    }
}

