/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.tray.predetection;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.tray.predetection.DetectionChain;
import com.huawei.support.icslite.tray.predetection.impl.FileCompleteDetection;
import com.huawei.support.icslite.tray.predetection.impl.SystemEnvDetection;
import com.huawei.support.icslite.tray.predetection.impl.TomcatPortDetection;
import com.huawei.support.icslite.tray.predetection.impl.ValidPathDetection;
import java.util.ArrayList;
import java.util.List;

public class DetectionHandler {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(DetectionHandler.class);
    private static final List<DetectionChain> DETECTION_CHAIN_LIST = new ArrayList<DetectionChain>();

    public DetectionHandler() {
        DETECTION_CHAIN_LIST.add(new SystemEnvDetection());
        DETECTION_CHAIN_LIST.add(new TomcatPortDetection());
        DETECTION_CHAIN_LIST.add(new FileCompleteDetection());
        DETECTION_CHAIN_LIST.add(new ValidPathDetection());
    }

    public void detectionEnv(String type) {
        CodeCCUtils.INSTANCE.infoLog(LOG, "{0} start check is start!", type);
        DETECTION_CHAIN_LIST.forEach(detection -> {
            if (detection.applyCheck(type)) {
                detection.executeDetection();
            }
        });
    }
}

