/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.tray.predetection.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.huawei.support.icslite.common.service.impl.IcsCommonServiceHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import com.huawei.support.icslite.tray.constant.IcsLiteFrameConstants;
import com.huawei.support.icslite.tray.messages.TrayBubbleTips;
import com.huawei.support.icslite.tray.predetection.DetectionChain;
import com.huawei.support.icslite.tray.utils.TrayUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class FileCompleteDetection
implements DetectionChain {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(FileCompleteDetection.class);
    private static final TypeReference<HashMap<String, String>> MAP_TYPE_REFERENCE = new TypeReference<HashMap<String, String>>(){};

    @Override
    public boolean applyCheck(String flag) {
        return "afterStartup".equals(flag);
    }

    @Override
    public void executeDetection() {
        if (this.completeCheck()) {
            return;
        }
        String link = I18nResources.INSTANCE.getValueByKey("tray.gui.link");
        TrayUtils.buildFeedBack();
        TrayBubbleTips.isJumpWindowsEvent(I18nResources.INSTANCE.getValueByKey("file.check.gui.content"), TrayUtils.getFeedbackPage(), "feedback", link);
    }

    private boolean completeCheck() {
        String fileCheckPath = IcsCommonServiceHandler.getInstance().getAppRootDir() + File.separator + IcsLiteFrameConstants.FILECHECKSUM_PATH;
        String content = IcsFileUtils.readFileContent(fileCheckPath, "");
        JSONObject contentFormat = JSONObject.parseObject(content);
        HashMap<String, String> fileMap = JSONObject.parseObject(contentFormat.toJSONString(), MAP_TYPE_REFERENCE, new Feature[0]);
        fileMap.remove("ExcludePath");
        fileMap.remove("DigestAlgorithms");
        fileMap.remove("Time");
        fileMap.remove("Create By");
        return this.verifyProcess(fileMap);
    }

    private boolean verifyProcess(HashMap<String, String> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            CodeCCUtils.INSTANCE.infoLog(LOG, "file verify failed, maps is empty.");
            return false;
        }
        for (Map.Entry<String, String> fileEntry : fileMap.entrySet()) {
            String relativePath = fileEntry.getKey();
            String filePath = IcsCommonServiceHandler.getInstance().getAppRootDir() + relativePath;
            File file = FileUtils.getFile(filePath);
            if (!file.exists()) {
                CodeCCUtils.INSTANCE.errorLog(LOG, "file is not exists,the relative path:{0}", relativePath);
                return false;
            }
            String fileSha = this.getHash(file, "SHA-256");
            if (StringUtils.equals(fileSha, fileEntry.getValue())) continue;
            CodeCCUtils.INSTANCE.infoLog(LOG, "file sha code value is different,the relative path:{0}", relativePath);
        }
        return true;
    }

    private String getHash(File file, String hashType) {
        String result = null;
        try (BufferedInputStream fis = new BufferedInputStream(FileUtils.openInputStream(file));){
            byte[] buffer = new byte[1024];
            MessageDigest md = MessageDigest.getInstance(hashType);
            int numRead = fis.read(buffer);
            while (numRead > 0) {
                md.update(buffer, 0, numRead);
                numRead = fis.read(buffer);
            }
            result = new HexBinaryAdapter().marshal(md.digest());
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Get {0} IO error.", hashType);
        }
        catch (NoSuchAlgorithmException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Get {0} NoSuchAlgorithmException.", (Throwable)e, hashType);
        }
        if (StringUtils.isBlank(result)) {
            return "";
        }
        return result.toUpperCase(Locale.ENGLISH);
    }
}

