/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.tray.predetection.impl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.i18n.init.I18nResources;
import com.huawei.support.icslite.tray.ExitHandler;
import com.huawei.support.icslite.tray.messages.TrayBubbleTips;
import com.huawei.support.icslite.tray.predetection.DetectionChain;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class SystemEnvDetection
implements DetectionChain {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(SystemEnvDetection.class);

    @Override
    public boolean applyCheck(String flag) {
        return "beforeStartup".equals(flag);
    }

    @Override
    public void executeDetection() {
        if (ExitHandler.isExit() || this.isWindowsOs()) {
            return;
        }
        boolean isCancel = TrayBubbleTips.systemWindowsEvent(I18nResources.INSTANCE.getValueByKey("system.gui.content"));
        if (isCancel) {
            ExitHandler.setExit(true);
            ExitHandler.exitApp();
        }
    }

    private boolean isWindowsOs() {
        String systemType = System.getProperty("os.name");
        String supportSystemTypeStr = ConfigServiceHandler.getInstance().get("startup.support.system.type");
        Object[] supportSystemArrays = StringUtils.split(supportSystemTypeStr, ",");
        if (ArrayUtils.isEmpty(supportSystemArrays)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "support system config is blank");
            return false;
        }
        boolean isSupportSystem = Arrays.asList(supportSystemArrays).stream().anyMatch(windowsName -> StringUtils.containsIgnoreCase(systemType, windowsName));
        if (!isSupportSystem) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "ics lite start doesn't support this system type : {0} ", systemType);
        }
        return isSupportSystem;
    }
}

