/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.tray.predetection.impl;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.config.service.impl.ConfigServiceHandler;
import com.huawei.support.icslite.tray.TomcatXmlParser;
import com.huawei.support.icslite.tray.predetection.DetectionChain;
import com.huawei.support.icslite.tray.utils.NetUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TomcatPortDetection
implements DetectionChain {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(TomcatPortDetection.class);
    private static final List<Integer> PORTS = Collections.unmodifiableList(Arrays.asList(51999, 51901, 51801, 51701, 51601, 51501, 51401, 51319, 51317, 51315, 51313, 51311, 51309, 51307, 51305, 51303, 51301, 51299, 52999, 52888, 53999, 53888, 54999, 54888, 55999, 55888));

    @Override
    public boolean applyCheck(String flag) {
        return "beforeStartup".equals(flag);
    }

    @Override
    public void executeDetection() {
        if (!this.checkAvailablePort()) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "ICS Lite All tomcat port numbers have been used.");
        }
    }

    private boolean checkAvailablePort() {
        int httpPort = this.checkCurrentPort();
        if (httpPort != -1) {
            return true;
        }
        int portOfCanUse = this.findPortOfCanUse(httpPort);
        if (portOfCanUse == -1) {
            return false;
        }
        ConfigServiceHandler.getInstance().set("system.http.port", String.valueOf(portOfCanUse));
        TomcatXmlParser.updateLitePort(portOfCanUse);
        return true;
    }

    private int checkCurrentPort() {
        int httpPort = TomcatXmlParser.getHttpPort();
        if (NetUtils.isLocalPortUsing(httpPort)) {
            return -1;
        }
        ConfigServiceHandler.getInstance().set("system.http.port", String.valueOf(httpPort));
        CodeCCUtils.INSTANCE.infoLog(LOG, "NetUtils The Port {0} is not using", httpPort);
        return httpPort;
    }

    private int findPortOfCanUse(int httpPort) {
        for (Integer port : PORTS) {
            if (port == httpPort) continue;
            if (!NetUtils.isLocalPortUsing(port)) {
                CodeCCUtils.INSTANCE.infoLog(LOG, "NetUtils The Port {0} is not using", port);
                return port;
            }
            CodeCCUtils.INSTANCE.errorLog(LOG, "NetUtils The Port {0} is using", port);
        }
        return -1;
    }
}

