/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.tray.server;

import com.alibaba.fastjson.JSONObject;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.response.ResultCode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public class TomcatUtils {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(TomcatUtils.class);
    private static final int TIME_OUT = 3000;

    private TomcatUtils() {
    }

    public static boolean connectionCheckUrl(String checkUrl) {
        if (StringUtils.isBlank(checkUrl)) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Param checkUrl is empty.");
            return false;
        }
        URLConnection urlConnection = null;
        try {
            URL url = new URL(checkUrl);
            urlConnection = url.openConnection();
            urlConnection.setConnectTimeout(3000);
            urlConnection.setReadTimeout(3000);
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Open url reading, openConnection error.", (Throwable)e);
        }
        if (urlConnection == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "OpenConnection error.");
            return false;
        }
        boolean isConnected = false;
        try (InputStream inputStream = urlConnection.getInputStream();
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(inputStreamReader);){
            String temp;
            StringBuilder result = new StringBuilder();
            while ((temp = br.readLine()) != null) {
                result.append(temp);
            }
            JSONObject jsonObject = JSONObject.parseObject(result.toString());
            int code = jsonObject.getIntValue("code");
            CodeCCUtils.INSTANCE.infoLog(LOG, "OpenConnection checkUrl:{0} return response code:{1}", checkUrl, code);
            if (code == ResultCode.SUCCESS.getReusltCode()) {
                isConnected = true;
            }
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Open url reading, but connection refused.", (Throwable)e);
        }
        return isConnected;
    }
}

