/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.tray.utils;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icslite.i18n.init.I18nResources;
import com.huawei.wsf.core.HWEncoder;
import java.net.URL;
import javax.swing.ImageIcon;
import org.owasp.esapi.errors.EncodingException;

public class TrayUtils {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(TrayUtils.class);
    private static String feedbackPage;

    private TrayUtils() {
    }

    public static ImageIcon createImageIcon(String path) {
        ClassLoader classLoader = TrayUtils.class.getClassLoader();
        URL url = classLoader.getResource(path);
        ImageIcon result = null;
        if (url == null) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Failed to obtain the image icon.");
            return result;
        }
        return new ImageIcon(url);
    }

    public static void buildFeedBack() {
        String subject = I18nResources.INSTANCE.getValueByKey("common.mailto.subject");
        String body = I18nResources.INSTANCE.getValueByKey("common.mailto.body");
        try {
            feedbackPage = "mailto:document@huawei.com?subject=" + HWEncoder.encodeForURL(subject) + "&body=" + HWEncoder.encodeForURL(body);
            feedbackPage = feedbackPage.replace("+", "%20");
        }
        catch (EncodingException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "feedback encoding failed.", (Throwable)e);
        }
    }

    public static String getFeedbackPage() {
        return feedbackPage;
    }

    static {
        TrayUtils.buildFeedBack();
    }
}

