/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.core;

import com.huawei.wsf.util.EmptyUtils;
import java.util.ArrayList;
import java.util.Optional;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.reference.DefaultEncoder;

public final class HWCanonicalize {
    private static final Encoder CSSENCODER;
    private static final Encoder JAVASCRIPTENCODER;
    private static final Encoder HTMLENCODER;

    private HWCanonicalize() {
    }

    public static String cssCanonicalize(String input) {
        return HWCanonicalize.gotoCanonicalize(input, CSSENCODER).orElse(null);
    }

    public static String javaScriptCanonicalize(String input) {
        return HWCanonicalize.gotoCanonicalize(input, JAVASCRIPTENCODER).orElse(null);
    }

    public static String htmlCanonicalize(String input) {
        return HWCanonicalize.gotoCanonicalize(input, HTMLENCODER).orElse(null);
    }

    private static Optional<String> gotoCanonicalize(String input, Encoder encoder) {
        if (EmptyUtils.isEmpty(input)) {
            return Optional.empty();
        }
        return Optional.ofNullable(encoder.canonicalize(input, false));
    }

    static {
        ArrayList<String> cssCode = new ArrayList<String>(1);
        cssCode.add("CSSCodec");
        CSSENCODER = new DefaultEncoder(cssCode);
        ArrayList<String> javaScriptCode = new ArrayList<String>(1);
        javaScriptCode.add("JavaScriptCodec");
        JAVASCRIPTENCODER = new DefaultEncoder(javaScriptCode);
        ArrayList<String> htmlCode = new ArrayList<String>(1);
        htmlCode.add("HTMLEntityCodec");
        htmlCode.add("PercentCodec");
        HTMLENCODER = new DefaultEncoder(htmlCode);
    }
}

