/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.core;

import com.huawei.wsf.util.EmptyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.errors.EncodingException;

public final class HWEncoder {
    private static final Pattern QUOTATION_MARKS_PATTERN = Pattern.compile("\"");
    private static List<String> csvList = new ArrayList<String>(4);

    private HWEncoder() {
    }

    public static String encodeForHTML(String input) {
        return ESAPI.encoder().encodeForHTML(input);
    }

    public static String encodeForHTMLAttribute(String input) {
        return ESAPI.encoder().encodeForHTMLAttribute(input);
    }

    public static String encodeForCSS(String input) {
        return ESAPI.encoder().encodeForCSS(input);
    }

    public static String encodeForJavaScript(String input) {
        return ESAPI.encoder().encodeForJavaScript(input);
    }

    public static String encodeForVBScript(String input) {
        return ESAPI.encoder().encodeForVBScript(input);
    }

    public static String encodeForSQL(Codec codec, String input) {
        return ESAPI.encoder().encodeForSQL(codec, input);
    }

    public static String encodeForOS(Codec codec, String input) {
        return ESAPI.encoder().encodeForOS(codec, input);
    }

    public static String encodeForLDAP(String input) {
        return ESAPI.encoder().encodeForLDAP(input);
    }

    public static String encodeForLDAP(String input, boolean encodeWildcards) {
        return ESAPI.encoder().encodeForLDAP(input, encodeWildcards);
    }

    public static String encodeForDN(String input) {
        return ESAPI.encoder().encodeForDN(input);
    }

    public static String encodeForXPath(String input) {
        return ESAPI.encoder().encodeForXPath(input);
    }

    public static String encodeForXML(String input) {
        return ESAPI.encoder().encodeForXML(input);
    }

    public static String encodeForXMLAttribute(String input) {
        return ESAPI.encoder().encodeForXMLAttribute(input);
    }

    public static String encodeForURL(String input) throws EncodingException {
        return ESAPI.encoder().encodeForURL(input);
    }

    public static String encodeForURL(String input, String encoder) throws EncodingException {
        return ESAPI.encoder().encodeForURL(input, encoder);
    }

    public static String encodeForBase64(byte[] input, boolean wrap) {
        return ESAPI.encoder().encodeForBase64(input, wrap);
    }

    public static String encodeForCSVCell(String value) {
        if (EmptyUtils.isEmpty(value)) {
            return value;
        }
        String valueTemp = value;
        if (HWEncoder.isSpecialChar(valueTemp.substring(0, 1))) {
            valueTemp = "\t" + valueTemp;
        }
        StringBuffer encodedValue = new StringBuffer();
        encodedValue.append('\"');
        Matcher matcher = QUOTATION_MARKS_PATTERN.matcher(valueTemp);
        while (matcher.find()) {
            matcher.appendReplacement(encodedValue, "\"\"");
        }
        matcher.appendTail(encodedValue);
        encodedValue.append('\"');
        return encodedValue.toString();
    }

    private static boolean isSpecialChar(String value) {
        return csvList.contains(value);
    }

    static {
        csvList.add("=");
        csvList.add("+");
        csvList.add("-");
        csvList.add("@");
    }
}

