/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.core;

import com.huawei.wsf.core.HWDecoder;
import com.huawei.wsf.core.HWEncoder;
import com.huawei.wsf.core.HWRandomizer;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.crypto.CipherText;
import org.owasp.esapi.crypto.CipherTextSerializer;
import org.owasp.esapi.crypto.HashSpec;
import org.owasp.esapi.crypto.PlainText;
import org.owasp.esapi.crypto.SealSpec;
import org.owasp.esapi.crypto.VerifySignatureSpec;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.errors.IntegrityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HWEncryptor {
    private static final Logger LOG = LoggerFactory.getLogger(HWEncryptor.class);

    private HWEncryptor() {
    }

    public static String hash(String plaintext, String salt) throws EncryptionException {
        return ESAPI.encryptor().hash(plaintext, salt);
    }

    public static String hash(String plaintext, String salt, int iterations) throws EncryptionException {
        return ESAPI.encryptor().hash(plaintext, salt, iterations);
    }

    public static String hash(String plaintext, String salt, String algorithm, int iterations) throws EncryptionException {
        return ESAPI.encryptor().hash(plaintext, salt, algorithm, iterations);
    }

    public static byte[] hash(HashSpec hashPojo) throws EncryptionException {
        return ESAPI.encryptor().hash(hashPojo);
    }

    public static String getHashedPassword(String password, byte[] salt) {
        return HWEncryptor.getOptionalHashedPassword(password, salt, 10000).orElse(null);
    }

    public static String getHashedPassword(String password, byte[] salt, int iterCount) {
        return HWEncryptor.getOptionalHashedPassword(password, salt, iterCount).orElse(null);
    }

    public static byte[] getHashedPassword(char[] password, byte[] salt, int iterCount) {
        return HWEncryptor.getOptionalHashedPassword(password, salt, iterCount).orElse(null);
    }

    private static Optional<byte[]> getOptionalHashedPassword(char[] password, byte[] salt, int iterCount) {
        try {
            PBEKeySpec spec = new PBEKeySpec(password, salt, iterCount, 256);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            byte[] hashed = skf.generateSecret(spec).getEncoded();
            if (hashed == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(Base64.getEncoder().encode(hashed));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            return Optional.empty();
        }
    }

    private static Optional<String> getOptionalHashedPassword(String password, byte[] salt, int iterCount) {
        try {
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, iterCount, 256);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            byte[] hashed = skf.generateSecret(spec).getEncoded();
            if (hashed == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(Base64.getMimeEncoder().encodeToString(hashed));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            return Optional.empty();
        }
    }

    public static byte[] getSalt() throws NoSuchAlgorithmException {
        return HWEncryptor.getSalt(8);
    }

    public static byte[] getSalt(int size) throws NoSuchAlgorithmException {
        if (size < 16) {
            LOG.info("[WSF_Api] The value is used to generate the salt value of the derived key algorithm.");
            LOG.warn("[WSF_Api] The value should be greater than or equal to 16.");
        }
        return HWRandomizer.getRandomBytes(size);
    }

    public static CipherText getCipherTextfromSerializedString(String serialized) throws EncryptionException, IOException {
        byte[] data = HWDecoder.decodeFromBase64(serialized);
        if (data == null) {
            return null;
        }
        CipherTextSerializer cs = new CipherTextSerializer(data);
        return cs.asCipherText();
    }

    public static String getSerializedCipherTextString(CipherText cipherText) {
        CipherTextSerializer cs = new CipherTextSerializer(cipherText);
        byte[] data = cs.asSerializedByteArray();
        return HWEncoder.encodeForBase64(data, false);
    }

    public static CipherText encrypt(SecretKey key, PlainText plain) throws EncryptionException {
        return ESAPI.encryptor().encrypt(key, plain);
    }

    public static CipherText encrypt(SecretKey key, PlainText plain, String xform) throws EncryptionException {
        return ESAPI.encryptor().encrypt(key, plain, xform);
    }

    public static PlainText decrypt(SecretKey key, CipherText ciphertext) throws EncryptionException, IllegalArgumentException {
        if (ciphertext == null) {
            return new PlainText("");
        }
        return ESAPI.encryptor().decrypt(key, ciphertext);
    }

    public static String sign(String data, PrivateKey prvKey) throws EncryptionException {
        return ESAPI.encryptor().sign(data, prvKey);
    }

    public static byte[] sign(byte[] data, PrivateKey prvKey) throws EncryptionException {
        return ESAPI.encryptor().sign(data, prvKey);
    }

    public static String sign(String data, PrivateKey prvKey, String signAlgorithm) throws EncryptionException {
        return ESAPI.encryptor().sign(data, prvKey, signAlgorithm);
    }

    public static byte[] sign(byte[] data, PrivateKey prvKey, String signAlgorithm) throws EncryptionException {
        return ESAPI.encryptor().sign(data, prvKey, signAlgorithm);
    }

    public static boolean verifySignature(String signature, String data, PublicKey pubKey) {
        return ESAPI.encryptor().verifySignature(signature, data, pubKey);
    }

    public static boolean verifySignature(String signature, String data, PublicKey pubKey, String signAlgorithm) {
        return ESAPI.encryptor().verifySignature(signature, data, pubKey, signAlgorithm);
    }

    public static boolean verifySignature(VerifySignatureSpec verifySignaturePojo) {
        return ESAPI.encryptor().verifySignature(verifySignaturePojo);
    }

    public static String seal(String data, long expiration, PrivateKey signPrvKey, SecretKey key) throws IntegrityException {
        return ESAPI.encryptor().seal(data, expiration, signPrvKey, key);
    }

    public static byte[] seal(SealSpec sealPojo) throws IntegrityException {
        return ESAPI.encryptor().seal(sealPojo);
    }

    public static String unseal(String seal, PublicKey signPubKey, SecretKey key) throws EncryptionException {
        return ESAPI.encryptor().unseal(seal, signPubKey, key);
    }

    public static byte[] unseal(byte[] seal, PublicKey signPubKey, SecretKey key) throws EncryptionException {
        return ESAPI.encryptor().unseal(seal, signPubKey, key);
    }

    public static boolean verifySeal(String seal, PublicKey signPubKey, SecretKey key) {
        return ESAPI.encryptor().verifySeal(seal, signPubKey, key);
    }

    public static boolean verifySeal(byte[] seal, PublicKey signPubKey, SecretKey key) {
        return ESAPI.encryptor().verifySeal(seal, signPubKey, key);
    }
}

