/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.processor;

import com.huawei.wsf.redos.base.RegexModel;
import com.huawei.wsf.redos.processor.RegexConvert;
import com.huawei.wsf.redos.regexp.RegexCharClass;
import com.huawei.wsf.redos.regexp.RegexCharSet;

public abstract class Processor {
    public abstract void handle(RegexConvert var1, RegexModel var2, StringBuilder var3, Character var4, int var5);

    protected static char deleteChar(RegexModel regexModel) {
        char deletedChar = regexModel.getProcessStr().charAt(0);
        String processedStr = regexModel.getProcessStr().substring(1);
        regexModel.setProcessStr(processedStr);
        return deletedChar;
    }

    private static String deleteUntil(RegexModel regexModel, int beginIndex) {
        String temp = regexModel.getProcessStr().substring(0, beginIndex);
        regexModel.setProcessStr(regexModel.getProcessStr().substring(beginIndex));
        regexModel.setCursor(regexModel.getCursor() + beginIndex);
        return temp;
    }

    protected static void deleteToken(RegexModel regexModel, String token) {
        if (!regexModel.getProcessStr().startsWith(token)) {
            throw new IllegalStateException("not started by " + token);
        }
        Processor.deleteUntil(regexModel, token.length());
    }

    protected static String deleteAll(RegexModel regexModel) {
        String rest = regexModel.getProcessStr();
        regexModel.setCursor(regexModel.getCursor() + regexModel.getProcessStr().length());
        regexModel.setProcessStr("");
        return rest;
    }

    protected static char unescapeCurrent(RegexModel regex) {
        Processor.deleteChar(regex);
        if (regex.isEmpty()) {
            regex.error("Premature end of expression after \\");
        }
        try {
            char ch = Processor.deleteChar(regex);
            if (ch == 'x') {
                return Processor.decodeANSI(regex);
            }
            if (Processor.isSeparator(ch)) {
                return Processor.getSeparator(ch);
            }
            if (Character.isLetter(ch)) {
                regex.error("Unsupported escape sequence \\" + ch);
                return ch;
            }
            return ch;
        }
        catch (NumberFormatException e) {
            regex.error("Malformed ANSI code: " + e.getMessage(), e);
            return '\u0000';
        }
    }

    private static char decodeANSI(RegexModel regex) {
        if (regex.getProcessStr().length() >= 2) {
            String code = Processor.deleteUntil(regex, 2);
            return (char)Integer.parseInt(code, 16);
        }
        throw new NumberFormatException("Malformed ANSI code: " + Processor.deleteAll(regex));
    }

    private static boolean isSeparator(char ch) {
        return "nrtaefv".indexOf(ch) != -1;
    }

    private static char getSeparator(char ch) {
        int index = "nrtaefv".indexOf(ch);
        return "\n\r\t\u0007\u001b\f\u000b".charAt(index);
    }

    protected static RegexCharClass predefinedCharClass(RegexModel regex) {
        Processor.deleteToken(regex, "\\");
        char ch = Processor.deleteChar(regex);
        switch (ch) {
            case 'd': {
                return new RegexCharClass(RegexCharSet.digitSet(), true);
            }
            case 'D': {
                return new RegexCharClass(RegexCharSet.digitSet(), false);
            }
            case 'w': {
                return new RegexCharClass(RegexCharSet.wordSet(), true);
            }
            case 'W': {
                return new RegexCharClass(RegexCharSet.wordSet(), false);
            }
            case 's': {
                return new RegexCharClass(RegexCharSet.whiteSpaceSet(), true);
            }
            case 'S': {
                return new RegexCharClass(RegexCharSet.whiteSpaceSet(), false);
            }
        }
        throw new IllegalStateException("Unknown predefined character class \\" + ch);
    }

    protected static RegexCharClass convert(RegexModel regexModel) {
        RegexCharSet charSet = new RegexCharSet(regexModel.getProcessStr().length());
        boolean including = Processor.parseIncluding(regexModel);
        while (!regexModel.getProcessStr().startsWith("]")) {
            if (regexModel.isEmpty()) {
                regexModel.error("Missing ']' at the end of character class.");
            }
            if (regexModel.getProcessStr().charAt(0) == '\\') {
                if (Processor.isCharacter(regexModel)) {
                    RegexCharSet subset = Processor.predefinedCharClass(regexModel).toSet();
                    charSet.addAll(including ? subset : subset.reversed());
                    continue;
                }
                charSet.add(Character.valueOf(Processor.unescapeCurrent(regexModel)));
                continue;
            }
            if (Processor.isRange(regexModel)) {
                charSet.addAll(Processor.parseRange(regexModel));
                continue;
            }
            charSet.add(Character.valueOf(Processor.deleteChar(regexModel)));
        }
        Processor.deleteToken(regexModel, "]");
        return new RegexCharClass(charSet, including);
    }

    private static boolean isCharacter(RegexModel regex) {
        return regex.getProcessStr().length() > 1 && "dwsDWS".indexOf(regex.getProcessStr().charAt(1)) != -1;
    }

    private static boolean isRange(RegexModel regex) {
        return regex.getProcessStr().length() >= 3 && (Character.isDigit(regex.getProcessStr().charAt(0)) || Character.isLetter(regex.getProcessStr().charAt(0))) && regex.getProcessStr().charAt(1) == '-';
    }

    private static boolean parseIncluding(RegexModel regexModel) {
        boolean including = true;
        if (regexModel.getProcessStr().startsWith("[^")) {
            including = false;
            Processor.deleteToken(regexModel, "[^");
        } else if (regexModel.getProcessStr().startsWith("[:")) {
            regexModel.error("Posix character classes are not implemented yet. [:digit:] etc.");
        } else if (regexModel.getProcessStr().startsWith("[")) {
            Processor.deleteToken(regexModel, "[");
        } else {
            regexModel.error("Missing [ at the beginning of a character class");
        }
        return including;
    }

    private static RegexCharSet parseRange(RegexModel regex) {
        char from = Processor.deleteChar(regex);
        Processor.deleteToken(regex, "-");
        char to = Processor.deleteChar(regex);
        if (from >= to) {
            regex.error("Invalid character range " + from + "-" + to);
        }
        return RegexCharSet.clone(from, to);
    }
}

