/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.regexp;

import com.huawei.wsf.redos.derives.Derive;
import com.huawei.wsf.redos.regexp.RegExp;
import com.huawei.wsf.redos.strategy.Strategy;
import java.util.Collections;
import java.util.Set;

public class RegexElement
implements RegExp {
    public static final RegexElement EMPTY = new RegexElement();
    private final String element;

    public RegexElement(String element) {
        this.element = element;
    }

    public RegexElement() {
        this.element = "";
    }

    public static RegexElement clone(String pattern) {
        return new RegexElement(pattern);
    }

    @Override
    public boolean isEmpty() {
        return this.element.isEmpty();
    }

    @Override
    public RegExp cross(RegExp another) {
        for (int i = 0; i < this.element.length(); ++i) {
            String tail = this.element.substring(i);
            if (!this.startsWith(another, tail)) continue;
            return RegexElement.clone(tail);
        }
        return EMPTY;
    }

    private boolean startsWith(RegExp source, String prefix) {
        if (prefix.length() > Collections.max(source.counts())) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (source.matchAt(i, prefix.charAt(i)).equals((Object)RegExp.Match.MATCH)) continue;
            return false;
        }
        return true;
    }

    @Override
    public RegExp.Match matchAt(int index, char ch) {
        if (index < Collections.max(this.counts())) {
            return this.element.charAt(index) == ch ? RegExp.Match.MATCH : RegExp.Match.NO_MATCH;
        }
        return RegExp.Match.OUT_OF_RANGE;
    }

    public String toString() {
        return this.element;
    }

    @Override
    public Set<Integer> counts() {
        return Collections.singleton(this.element.length());
    }

    @Override
    public RegExp toNormalize() {
        return this;
    }

    @Override
    public Derive derive(Strategy strategy) {
        return strategy.element(this.element);
    }

    public boolean equals(Object another) {
        Object obj = another;
        if (obj instanceof RegExp) {
            obj = ((RegExp)obj).toNormalize();
        }
        if (obj instanceof RegexElement) {
            RegexElement ele = (RegexElement)obj;
            return this.element.equals(ele.element);
        }
        return false;
    }

    public int hashCode() {
        return this.element.hashCode();
    }
}

