/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.regexp;

import com.huawei.wsf.redos.derives.Derive;
import com.huawei.wsf.redos.regexp.RegExp;
import com.huawei.wsf.redos.regexp.RegexElement;
import com.huawei.wsf.redos.strategy.Strategy;
import java.util.HashSet;
import java.util.Set;

public class RegexSeq
implements RegExp {
    private final RegExp front;
    private final RegExp back;

    public RegexSeq(RegExp expA, RegExp expB) {
        this.front = expA.toNormalize();
        this.back = expB.toNormalize();
    }

    public static RegexSeq clone(RegExp expA, RegExp expB) {
        return new RegexSeq(expA, expB);
    }

    @Override
    public boolean isEmpty() {
        return this.front.isEmpty() && this.back.isEmpty();
    }

    @Override
    public RegExp cross(RegExp another) {
        return this.back.cross(another);
    }

    @Override
    public RegExp.Match matchAt(int index, char ch) {
        RegExp.Match matchA = this.front.matchAt(index, ch);
        if (!RegExp.Match.OUT_OF_RANGE.equals((Object)matchA)) {
            return matchA;
        }
        RegExp.Match bestMatch = RegExp.Match.OUT_OF_RANGE;
        for (int length : this.front.counts()) {
            RegExp.Match match = this.back.matchAt(Math.subtractExact(index, length), ch);
            if (RegExp.Match.MATCH.equals((Object)match)) {
                return RegExp.Match.MATCH;
            }
            if (!RegExp.Match.NO_MATCH.equals((Object)match)) continue;
            bestMatch = RegExp.Match.NO_MATCH;
        }
        return bestMatch;
    }

    @Override
    public Set<Integer> counts() {
        HashSet<Integer> lengths = new HashSet<Integer>();
        for (int lengthA : this.front.counts()) {
            for (int lengthB : this.back.counts()) {
                lengths.add(Math.addExact(lengthA, lengthB));
            }
        }
        return lengths;
    }

    public String toString() {
        return this.front.toString() + this.back.toString();
    }

    @Override
    public RegExp toNormalize() {
        if (this.front.isEmpty()) {
            return this.back;
        }
        if (this.back.isEmpty()) {
            return this.front;
        }
        if (this.front instanceof RegexElement && this.back instanceof RegexElement) {
            return RegexElement.clone(this.front.toString() + this.back.toString());
        }
        return this;
    }

    @Override
    public Derive derive(Strategy strategy) {
        return strategy.seq(this.front.derive(strategy), this.back.derive(strategy));
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof RegExp) {
            object = ((RegExp)object).toNormalize();
        }
        if (object instanceof RegexSeq) {
            RegexSeq regexSeq = (RegexSeq)object;
            return this.front.equals(regexSeq.front) && this.back.equals(regexSeq.back);
        }
        RegExp exp = this.toNormalize();
        if (exp instanceof RegexSeq) {
            return false;
        }
        return exp.equals(object);
    }

    public int hashCode() {
        RegExp exp = this.toNormalize();
        if (exp instanceof RegexSeq) {
            int prime = 31;
            int hashCode = 1;
            hashCode = 31 * hashCode + this.front.hashCode();
            hashCode = 31 * hashCode + this.back.hashCode();
            return hashCode;
        }
        return exp.hashCode();
    }
}

