/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wsf.redos.strategy;

import com.huawei.wsf.redos.derives.CharDerive;
import com.huawei.wsf.redos.derives.Derive;
import com.huawei.wsf.redos.derives.DeriveHashSet;
import com.huawei.wsf.redos.derives.DeriveSet;
import com.huawei.wsf.redos.derives.ElementDerive;
import com.huawei.wsf.redos.regexp.RegexCharSet;
import com.huawei.wsf.redos.strategy.Strategy;

public class RepeatStrategy
implements Strategy {
    private final int maxDeriveLength;
    private final int maxNumberOfDerives;

    public RepeatStrategy(int maxDeriveLength, int maxNumberOfDerives) {
        this.maxDeriveLength = maxDeriveLength;
        this.maxNumberOfDerives = maxNumberOfDerives;
    }

    @Override
    public Derive element(String ele) {
        return new ElementDerive(ele);
    }

    @Override
    public Derive charClass(RegexCharSet regexCharSet, boolean including) {
        return new CharDerive(regexCharSet, including);
    }

    @Override
    public Derive optional(Derive derive) {
        DeriveSet deriveSet = DeriveHashSet.clone(this.maxNumberOfDerives, derive);
        deriveSet.add("");
        return deriveSet;
    }

    @Override
    public Derive or(Derive regExpA, Derive regExpB) {
        return new DeriveHashSet(this.maxNumberOfDerives, regExpA, regExpB);
    }

    @Override
    public Derive repeat(Derive elementDerive, Derive substituteDerive, int begin, int end) {
        return substituteDerive;
    }

    @Override
    public Derive seq(Derive front, Derive back) {
        DeriveHashSet deriveSet = new DeriveHashSet(front.size() * back.size(), this.maxNumberOfDerives);
        block0: for (String frontStr : front) {
            for (String backStr : back) {
                if (deriveSet.isFull() || frontStr.length() + backStr.length() > this.maxDeriveLength) continue block0;
                deriveSet.add(frontStr + backStr);
            }
        }
        return deriveSet;
    }
}

