/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.AccessController;
import org.owasp.esapi.Authenticator;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.Encryptor;
import org.owasp.esapi.Executor;
import org.owasp.esapi.HTTPUtilities;
import org.owasp.esapi.LogFactory;
import org.owasp.esapi.Logger;
import org.owasp.esapi.Randomizer;
import org.owasp.esapi.SecurityConfiguration;
import org.owasp.esapi.Validator;
import org.owasp.esapi.errors.ConfigurationException;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.reference.BcStrongRandomizer;
import org.owasp.esapi.reference.DefaultEncoder;
import org.owasp.esapi.reference.DefaultHTTPUtilities;
import org.owasp.esapi.reference.DefaultRandomizer;
import org.owasp.esapi.reference.DefaultSecurityConfiguration;
import org.owasp.esapi.reference.DefaultValidator;
import org.owasp.esapi.reference.StrongRandomizer;
import org.owasp.esapi.reference.crypto.JavaEncryptor;
import org.owasp.esapi.util.ObjFactory;

public final class ESAPI {
    private static final ConcurrentMap<String, Object> ESAPI_MAP = new ConcurrentHashMap<String, Object>();
    private static final String LOG_FACTORY = "LogFactory";
    private static boolean isLoadConfig = false;
    private static String securityConfigurationImplName = System.getProperty("org.owasp.esapi.SecurityConfiguration", "org.owasp.esapi.reference.DefaultSecurityConfiguration");
    private static volatile SecurityConfiguration overrideConfig = null;

    private ESAPI() {
    }

    public static Encoder encoder() {
        return DefaultEncoder.getInstance();
    }

    public static Encryptor encryptor() {
        ESAPI.securityConfiguration();
        try {
            return JavaEncryptor.getInstance();
        }
        catch (EncryptionException ex) {
            throw new ConfigurationException("Failed to instance JavaEncryptor. ", ex);
        }
    }

    public static Executor executor() {
        return null;
    }

    public static HTTPUtilities httpUtilities() {
        ESAPI.securityConfiguration();
        return DefaultHTTPUtilities.getInstance();
    }

    private static LogFactory logFactory() {
        return (LogFactory)ObjFactory.make(ESAPI.securityConfiguration().getLogImplementation(), LOG_FACTORY);
    }

    public static Logger getLogger(Class clazz) {
        return ESAPI.logFactory().getLogger(clazz);
    }

    public static Logger getLogger(String moduleName) {
        return ESAPI.logFactory().getLogger(moduleName);
    }

    public static Logger log() {
        return ESAPI.logFactory().getLogger("DefaultLogger");
    }

    public static Randomizer randomizer() {
        SecurityConfiguration securityConfiguration = ESAPI.securityConfiguration();
        String randomGenerator = securityConfiguration.getRandomGenerator();
        if ("Randomizer".equals(randomGenerator)) {
            return DefaultRandomizer.getInstance();
        }
        if ("BcStrongRandomizer".equals(randomGenerator)) {
            return BcStrongRandomizer.getInstance();
        }
        return StrongRandomizer.getInstance();
    }

    public static SecurityConfiguration securityConfiguration() {
        SecurityConfiguration override = overrideConfig;
        if (override != null) {
            isLoadConfig = true;
            return override;
        }
        override = DefaultSecurityConfiguration.getInstance();
        isLoadConfig = true;
        return override;
    }

    public static Validator validator() {
        ESAPI.securityConfiguration();
        return DefaultValidator.getInstance();
    }

    public static String initialize(String impl) {
        String oldImpl = securityConfigurationImplName;
        securityConfigurationImplName = impl;
        return oldImpl;
    }

    public static void override(SecurityConfiguration config) {
        overrideConfig = config;
    }

    public static Authenticator authenticator() {
        return (Authenticator)ObjFactory.make(ESAPI.securityConfiguration().getAuthenticationImplementation(), "Authenticator");
    }

    public static HttpServletRequest currentRequest() {
        return ESAPI.httpUtilities().getCurrentRequest();
    }

    public static HttpServletResponse currentResponse() {
        return ESAPI.httpUtilities().getCurrentResponse();
    }

    public static void clearCurrent() {
        ESAPI.authenticator().clearCurrent();
        ESAPI.httpUtilities().clearCurrent();
    }

    public static AccessController accessController() {
        return (AccessController)ObjFactory.make(ESAPI.securityConfiguration().getAccessControlImplementation(), "AccessController");
    }
}

