/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.logging.log4j;

import java.util.ArrayList;
import java.util.HashMap;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.LogFactory;
import org.owasp.esapi.Logger;
import org.owasp.esapi.codecs.HTMLEntityCodec;
import org.owasp.esapi.logging.appender.LogAppender;
import org.owasp.esapi.logging.appender.LogPrefixAppender;
import org.owasp.esapi.logging.cleaning.CodecLogScrubber;
import org.owasp.esapi.logging.cleaning.CompositeLogScrubber;
import org.owasp.esapi.logging.cleaning.LogScrubber;
import org.owasp.esapi.logging.cleaning.NewlineLogScrubber;
import org.owasp.esapi.logging.log4j.Log4JLogBridge;
import org.owasp.esapi.logging.log4j.Log4JLogBridgeImpl;
import org.owasp.esapi.logging.log4j.Log4JLogLevelHandler;
import org.owasp.esapi.logging.log4j.Log4JLogLevelHandlers;
import org.owasp.esapi.logging.log4j.Log4JLogger;

@Deprecated
public class Log4JLogFactory
implements LogFactory {
    private static final char[] IMMUNE_LOG4J_HTML = new char[]{',', '.', '-', '_', ' '};
    private static final HTMLEntityCodec HTML_CODEC = new HTMLEntityCodec();
    private static LogAppender Log4J_LOG_APPENDER;
    private static LogScrubber Log4J_LOG_SCRUBBER;
    private static Log4JLogBridge LOG_BRIDGE;

    static LogScrubber createLogScrubber(boolean requiresEncoding) {
        ArrayList<LogScrubber> messageScrubber = new ArrayList<LogScrubber>();
        messageScrubber.add(new NewlineLogScrubber());
        if (requiresEncoding) {
            messageScrubber.add(new CodecLogScrubber(HTML_CODEC, IMMUNE_LOG4J_HTML));
        }
        return new CompositeLogScrubber(messageScrubber);
    }

    static LogAppender createLogAppender(boolean logUserInfo, boolean logClientInfo, boolean logServerIp, boolean logApplicationName, String appName) {
        return new LogPrefixAppender(logUserInfo, logClientInfo, logServerIp, logApplicationName, appName);
    }

    @Override
    public Logger getLogger(String moduleName) {
        org.apache.log4j.Logger log4JLogger = org.apache.log4j.Logger.getLogger(moduleName);
        return new Log4JLogger(log4JLogger, LOG_BRIDGE, Integer.MIN_VALUE);
    }

    @Override
    public Logger getLogger(Class clazz) {
        org.apache.log4j.Logger log4JLogger = org.apache.log4j.Logger.getLogger(clazz);
        return new Log4JLogger(log4JLogger, LOG_BRIDGE, Integer.MIN_VALUE);
    }

    static {
        boolean encodeLog = ESAPI.securityConfiguration().getBooleanProp("Logger.LogEncodingRequired");
        Log4J_LOG_SCRUBBER = Log4JLogFactory.createLogScrubber(encodeLog);
        boolean logUserInfo = ESAPI.securityConfiguration().getBooleanProp("Logger.UserInfo");
        boolean logClientInfo = ESAPI.securityConfiguration().getBooleanProp("Logger.ClientInfo");
        boolean logApplicationName = ESAPI.securityConfiguration().getBooleanProp("Logger.LogApplicationName");
        String appName = ESAPI.securityConfiguration().getStringProp("Logger.ApplicationName");
        boolean logServerIp = ESAPI.securityConfiguration().getBooleanProp("Logger.LogServerIP");
        Log4J_LOG_APPENDER = Log4JLogFactory.createLogAppender(logUserInfo, logClientInfo, logServerIp, logApplicationName, appName);
        HashMap<Integer, Log4JLogLevelHandler> levelLookup = new HashMap<Integer, Log4JLogLevelHandler>();
        levelLookup.put(Integer.MIN_VALUE, Log4JLogLevelHandlers.TRACE);
        levelLookup.put(100, Log4JLogLevelHandlers.TRACE);
        levelLookup.put(200, Log4JLogLevelHandlers.DEBUG);
        levelLookup.put(400, Log4JLogLevelHandlers.INFO);
        levelLookup.put(800, Log4JLogLevelHandlers.ERROR);
        levelLookup.put(600, Log4JLogLevelHandlers.WARN);
        levelLookup.put(1000, Log4JLogLevelHandlers.FATAL);
        LOG_BRIDGE = new Log4JLogBridgeImpl(Log4J_LOG_APPENDER, Log4J_LOG_SCRUBBER, levelLookup);
    }
}

