/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.UUID;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.EncoderConstants;
import org.owasp.esapi.Logger;
import org.owasp.esapi.Randomizer;
import org.owasp.esapi.errors.EncryptionException;
import org.owasp.esapi.reference.DefaultRandomizer;

public class StrongRandomizer
implements Randomizer {
    private static final Logger logger = ESAPI.getLogger("Randomizer");
    private static volatile Randomizer singletonInstance;
    private SecureRandom strongSecureRandom;

    private StrongRandomizer() {
        try {
            this.strongSecureRandom = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            new EncryptionException("Error creating randomizer", "Can't find random algorithm.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Randomizer getInstance() {
        if (singletonInstance != null) return singletonInstance;
        Class<DefaultRandomizer> clazz = DefaultRandomizer.class;
        synchronized (DefaultRandomizer.class) {
            if (singletonInstance != null) return singletonInstance;
            singletonInstance = new StrongRandomizer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonInstance;
        }
    }

    @Override
    public String getRandomString(int length, char[] characterSet) {
        StringBuilder sb = new StringBuilder();
        for (int loop = 0; loop < length; ++loop) {
            int index = this.strongSecureRandom.nextInt(characterSet.length);
            sb.append(characterSet[index]);
        }
        return sb.toString();
    }

    @Override
    public boolean getRandomBoolean() {
        return this.strongSecureRandom.nextBoolean();
    }

    @Override
    public int getRandomInteger(int min, int max) {
        return this.strongSecureRandom.nextInt(max - min) + min;
    }

    @Override
    public long getRandomLong() {
        return this.strongSecureRandom.nextLong();
    }

    @Override
    public float getRandomReal(float min, float max) {
        float factor = max - min;
        return this.strongSecureRandom.nextFloat() * factor + min;
    }

    @Override
    public String getRandomFilename(String extension) {
        String fn = this.getRandomString(12, EncoderConstants.getCharAlphanumerics()) + "." + extension;
        logger.debug(Logger.SECURITY_SUCCESS, "Generated new random filename: " + fn);
        return fn;
    }

    @Override
    public String getRandomGUID() {
        return UUID.randomUUID().toString();
    }

    @Override
    public byte[] getRandomBytes(int num) {
        byte[] result = new byte[num];
        this.strongSecureRandom.nextBytes(result);
        return result;
    }
}

