/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.validation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.Logger;
import org.owasp.esapi.SecurityConfiguration;
import org.owasp.esapi.StringUtilities;
import org.owasp.esapi.errors.ConfigurationException;
import org.owasp.esapi.errors.ValidationException;
import org.owasp.esapi.reference.DefaultSecurityConfiguration;
import org.owasp.esapi.reference.validation.StringValidationRule;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;

public class HTMLValidationRule
extends StringValidationRule {
    private static Policy antiSamyPolicy = null;
    private static final Logger LOGGER = ESAPI.getLogger("HTMLValidationRule");
    private static final String ANTISAMYPOLICY_FILENAME = "antisamy-esapi.xml";

    static InputStream getResourceStreamFromClassLoader(String contextDescription, ClassLoader classLoader, String fileName, List<String> searchPaths) {
        InputStream result = null;
        for (String searchPath : searchPaths) {
            result = classLoader.getResourceAsStream(searchPath + fileName);
            if (result == null) continue;
            LOGGER.info(Logger.EVENT_SUCCESS, "SUCCESSFULLY LOADED " + fileName + " via the CLASSPATH from '" + searchPath + "' using " + contextDescription + "!");
            break;
        }
        return result;
    }

    static InputStream getResourceStreamFromClasspath(String fileName) {
        LOGGER.info(Logger.EVENT_FAILURE, "Loading " + fileName + " from classpaths");
        InputStream resourceStream = null;
        List<String> orderedSearchPaths = Arrays.asList(DefaultSecurityConfiguration.DefaultSearchPath.ROOT.value(), DefaultSecurityConfiguration.DefaultSearchPath.RESOURCE_DIRECTORY.value(), DefaultSecurityConfiguration.DefaultSearchPath.DOT_ESAPI.value(), DefaultSecurityConfiguration.DefaultSearchPath.ESAPI.value(), DefaultSecurityConfiguration.DefaultSearchPath.RESOURCES.value(), DefaultSecurityConfiguration.DefaultSearchPath.SRC_MAIN_RESOURCES.value());
        resourceStream = HTMLValidationRule.getResourceStreamFromClassLoader("current thread context class loader", Thread.currentThread().getContextClassLoader(), fileName, orderedSearchPaths);
        resourceStream = resourceStream != null ? resourceStream : HTMLValidationRule.getResourceStreamFromClassLoader("system class loader", ClassLoader.getSystemClassLoader(), fileName, orderedSearchPaths);
        resourceStream = resourceStream != null ? resourceStream : HTMLValidationRule.getResourceStreamFromClassLoader("class loader for DefaultSecurityConfiguration class", ESAPI.securityConfiguration().getClass().getClassLoader(), fileName, orderedSearchPaths);
        return resourceStream;
    }

    static Policy loadAntisamyPolicy(String antisamyPolicyFilename) throws IOException, PolicyException {
        InputStream resourceStream = null;
        SecurityConfiguration secCfg = ESAPI.securityConfiguration();
        File file = secCfg.getResourceFile(antisamyPolicyFilename);
        resourceStream = file == null ? HTMLValidationRule.getResourceStreamFromClasspath(antisamyPolicyFilename) : secCfg.getResourceStream(antisamyPolicyFilename);
        return resourceStream == null ? null : Policy.getInstance(resourceStream);
    }

    static String resolveAntisamyFilename() {
        String antisamyPolicyFilename = ANTISAMYPOLICY_FILENAME;
        try {
            antisamyPolicyFilename = ESAPI.securityConfiguration().getStringProp("Validator.HtmlValidationConfigurationFile");
        }
        catch (ConfigurationException cex) {
            LOGGER.info(Logger.EVENT_FAILURE, "ESAPI property Validator.HtmlValidationConfigurationFile not set, using default value: antisamy-esapi.xml");
        }
        return antisamyPolicyFilename;
    }

    static void configureInstance() {
        String antisamyPolicyFilename = HTMLValidationRule.resolveAntisamyFilename();
        try {
            antiSamyPolicy = HTMLValidationRule.loadAntisamyPolicy(antisamyPolicyFilename);
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Failed to load file from SecurityConfiguration context: " + antisamyPolicyFilename, ioe);
        }
        catch (PolicyException e) {
            throw new ConfigurationException("Couldn't parse " + antisamyPolicyFilename, e);
        }
        if (antiSamyPolicy == null) {
            throw new ConfigurationException("Couldn't find " + antisamyPolicyFilename);
        }
    }

    public HTMLValidationRule(String typeName) {
        super(typeName);
    }

    public HTMLValidationRule(String typeName, Encoder encoder) {
        super(typeName, encoder);
    }

    public HTMLValidationRule(String typeName, Encoder encoder, String whitelistPattern) {
        super(typeName, encoder, whitelistPattern);
    }

    @Override
    public String getValid(String context, String input) throws ValidationException {
        return this.invokeAntiSamy(context, input);
    }

    @Override
    public String sanitize(String context, String input) {
        String safe = "";
        try {
            safe = this.invokeAntiSamy(context, input);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return safe;
    }

    private boolean legacyHtmlValidation() {
        boolean legacy = true;
        String propValue = "clean";
        try {
            propValue = ESAPI.securityConfiguration().getStringProp("Validator.HtmlValidationAction");
            switch (propValue.toLowerCase()) {
                case "throw": {
                    legacy = false;
                    break;
                }
                case "clean": {
                    legacy = true;
                    break;
                }
                default: {
                    LOGGER.warning(Logger.EVENT_FAILURE, "ESAPI property Validator.HtmlValidationAction was set to \"" + propValue + "\".  Must be set to either \"clean\" (the default for legacy support) or \"throw\"; assuming \"clean\" for legacy behavior.");
                    legacy = true;
                    break;
                }
            }
        }
        catch (ConfigurationException cex) {
            LOGGER.warning(Logger.EVENT_FAILURE, "ESAPI property Validator.HtmlValidationAction must be set to either \"clean\" (the default for legacy support) or \"throw\"; assuming \"clean\"", cex);
        }
        return legacy;
    }

    private String invokeAntiSamy(String context, String input) throws ValidationException {
        if (StringUtilities.isEmpty(input)) {
            if (this.allowNull) {
                return null;
            }
            throw new ValidationException(context + " is required", "AntiSamy validation error: context=" + context, context);
        }
        String canonical = super.getValid(context, input);
        try {
            AntiSamy as = new AntiSamy();
            CleanResults test = as.scan(canonical, antiSamyPolicy);
            List<String> errors = test.getErrorMessages();
            if (!errors.isEmpty()) {
                if (this.legacyHtmlValidation()) {
                    LOGGER.info(Logger.SECURITY_FAILURE, "Cleaned up invalid HTML input: " + errors);
                } else {
                    throw new ValidationException(context + ": Invalid HTML input", "Invalid HTML input does not follow rules in antisamy-esapi.xml: context=" + context + " errors=" + errors.toString());
                }
            }
            return test.getCleanHTML().trim();
        }
        catch (ScanException e) {
            throw new ValidationException(context + ": Invalid HTML input", "Invalid HTML input: context=" + context + " error=" + e.getMessage(), e, context);
        }
        catch (PolicyException e) {
            throw new ValidationException(context + ": Invalid HTML input", "Invalid HTML input does not follow rules in antisamy-esapi.xml: context=" + context + " error=" + e.getMessage(), e, context);
        }
    }

    static {
        HTMLValidationRule.configureInstance();
    }
}

