/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html.scan;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import net.sourceforge.htmlunit.cyberneko.parsers.SAXParser;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xml.serialize.HTMLSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.ScanException;
import org.owasp.validator.html.scan.AbstractAntiSamyScanner;
import org.owasp.validator.html.scan.MagicSAXFilter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class AntiSamySAXScanner
extends AbstractAntiSamyScanner {
    private static final Queue<CachedItem> cachedItems = new ConcurrentLinkedQueue<CachedItem>();
    private static final TransformerFactory sTransformerFactory;

    public AntiSamySAXScanner(Policy policy) {
        super(policy);
    }

    @Override
    public CleanResults getResults() {
        return null;
    }

    @Override
    public CleanResults scan(String html) throws ScanException {
        return this.scan(html, this.policy);
    }

    public CleanResults scan(String html, Policy policy) throws ScanException {
        if (html == null) {
            throw new ScanException(new NullPointerException("Null html input"));
        }
        int maxInputSize = this.policy.getMaxInputSize();
        if (html.length() > maxInputSize) {
            this.addError("error.size.toolarge", new Object[]{html.length(), maxInputSize});
            throw new ScanException((String)this.errorMessages.get(0));
        }
        final StringWriter out = new StringWriter();
        StringReader reader = new StringReader(html);
        CleanResults results = this.scan(reader, out);
        final String tainted = html;
        Callable<String> cleanCallable = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return AntiSamySAXScanner.this.trim(tainted, out.toString());
            }
        };
        return new CleanResults(results.getStartOfScan(), cleanCallable, null, results.getErrorMessages());
    }

    public CleanResults scan(Reader reader, Writer writer) throws ScanException {
        try {
            CachedItem candidateCachedItem = cachedItems.poll();
            if (candidateCachedItem == null) {
                candidateCachedItem = new CachedItem(AntiSamySAXScanner.getNewTransformer(), AntiSamySAXScanner.getParser(), new MagicSAXFilter(messages));
            }
            CachedItem cachedItem = candidateCachedItem;
            SAXParser parser = cachedItem.saxParser;
            cachedItem.magicSAXFilter.reset(this.policy);
            long startOfScan = System.currentTimeMillis();
            SAXSource source = new SAXSource(parser, new InputSource(reader));
            Transformer transformer = cachedItem.transformer;
            boolean formatOutput = this.policy.isFormatOutput();
            boolean omitXml = this.policy.isOmitXmlDeclaration();
            transformer.setOutputProperty("indent", formatOutput ? "yes" : "no");
            transformer.setOutputProperty("omit-xml-declaration", omitXml ? "yes" : "no");
            transformer.setOutputProperty("method", "html");
            OutputFormat format = this.getOutputFormat();
            HTMLSerializer serializer = this.getHTMLSerializer(writer, format);
            transformer.transform(source, new SAXResult(serializer));
            this.errorMessages.clear();
            this.errorMessages.addAll(cachedItem.magicSAXFilter.getErrorMessages());
            cachedItems.add(cachedItem);
            return new CleanResults(startOfScan, (String)null, null, (List<String>)this.errorMessages);
        }
        catch (Exception e) {
            throw new ScanException(e);
        }
    }

    private static synchronized Transformer getNewTransformer() {
        try {
            return sTransformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static SAXParser getParser() {
        try {
            SAXParser parser = new SAXParser();
            parser.setFeature("http://xml.org/sax/features/namespaces", false);
            parser.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
            parser.setFeature("http://cyberneko.org/html/features/scanner/cdata-sections", true);
            parser.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            parser.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
            parser.setProperty("http://cyberneko.org/html/properties/names/elems", "lower");
            return parser;
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        String TRANSFORMER_FACTORY_IMPL = System.getProperty("antisamy.transformerfactory.impl", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        sTransformerFactory = TransformerFactory.newInstance(TRANSFORMER_FACTORY_IMPL, null);
        sTransformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        sTransformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
    }

    static class CachedItem {
        private final Transformer transformer;
        private final SAXParser saxParser;
        private final MagicSAXFilter magicSAXFilter;

        CachedItem(Transformer transformer, SAXParser saxParser, MagicSAXFilter magicSAXFilter) {
            this.transformer = transformer;
            this.saxParser = saxParser;
            this.magicSAXFilter = magicSAXFilter;
            XMLDocumentFilter[] filters = new XMLDocumentFilter[]{magicSAXFilter};
            try {
                saxParser.setProperty("http://cyberneko.org/html/properties/filters", filters);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

