/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.expression;

import java.util.function.Supplier;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.access.expression.AbstractSecurityExpressionHandler;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.access.expression.SecurityExpressionOperations;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.expression.WebSecurityExpressionRoot;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.util.Assert;

public class DefaultHttpSecurityExpressionHandler
extends AbstractSecurityExpressionHandler<RequestAuthorizationContext>
implements SecurityExpressionHandler<RequestAuthorizationContext> {
    private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();
    private String defaultRolePrefix = "ROLE_";

    public EvaluationContext createEvaluationContext(Supplier<Authentication> authentication, RequestAuthorizationContext context) {
        WebSecurityExpressionRoot root = this.createSecurityExpressionRoot(authentication, context);
        StandardEvaluationContext ctx = new StandardEvaluationContext((Object)root);
        ctx.setBeanResolver(this.getBeanResolver());
        context.getVariables().forEach((arg_0, arg_1) -> ((StandardEvaluationContext)ctx).setVariable(arg_0, arg_1));
        return ctx;
    }

    protected SecurityExpressionOperations createSecurityExpressionRoot(Authentication authentication, RequestAuthorizationContext context) {
        return this.createSecurityExpressionRoot(() -> authentication, context);
    }

    private WebSecurityExpressionRoot createSecurityExpressionRoot(Supplier<Authentication> authentication, RequestAuthorizationContext context) {
        WebSecurityExpressionRoot root = new WebSecurityExpressionRoot(authentication, context.getRequest());
        root.setRoleHierarchy(this.getRoleHierarchy());
        root.setPermissionEvaluator(this.getPermissionEvaluator());
        root.setTrustResolver(this.trustResolver);
        root.setDefaultRolePrefix(this.defaultRolePrefix);
        return root;
    }

    public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        Assert.notNull((Object)trustResolver, "trustResolver cannot be null");
        this.trustResolver = trustResolver;
    }

    public void setDefaultRolePrefix(String defaultRolePrefix) {
        Assert.notNull((Object)defaultRolePrefix, "defaultRolePrefix cannot be null");
        this.defaultRolePrefix = defaultRolePrefix;
    }
}

