/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.csrf;

import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRequestResolver;
import org.springframework.util.Assert;

@FunctionalInterface
public interface CsrfTokenRequestHandler
extends CsrfTokenRequestResolver {
    public void handle(HttpServletRequest var1, HttpServletResponse var2, Supplier<CsrfToken> var3);

    @Override
    default public String resolveCsrfTokenValue(HttpServletRequest request, CsrfToken csrfToken) {
        Assert.notNull((Object)request, "request cannot be null");
        Assert.notNull((Object)csrfToken, "csrfToken cannot be null");
        String actualToken = request.getHeader(csrfToken.getHeaderName());
        if (actualToken == null) {
            actualToken = request.getParameter(csrfToken.getParameterName());
        }
        return actualToken;
    }
}

