/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ServerAuthenticationEntryPointFailureHandler
implements ServerAuthenticationFailureHandler {
    private final ServerAuthenticationEntryPoint authenticationEntryPoint;
    private boolean rethrowAuthenticationServiceException = false;

    public ServerAuthenticationEntryPointFailureHandler(ServerAuthenticationEntryPoint authenticationEntryPoint) {
        Assert.notNull((Object)authenticationEntryPoint, "authenticationEntryPoint cannot be null");
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    @Override
    public Mono<Void> onAuthenticationFailure(WebFilterExchange webFilterExchange, AuthenticationException exception) {
        if (!this.rethrowAuthenticationServiceException) {
            return this.authenticationEntryPoint.commence(webFilterExchange.getExchange(), exception);
        }
        if (!AuthenticationServiceException.class.isAssignableFrom(((Object)((Object)exception)).getClass())) {
            return this.authenticationEntryPoint.commence(webFilterExchange.getExchange(), exception);
        }
        return Mono.error((Throwable)exception);
    }

    public void setRethrowAuthenticationServiceException(boolean rethrowAuthenticationServiceException) {
        this.rethrowAuthenticationServiceException = rethrowAuthenticationServiceException;
    }
}

