/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.csrf;

import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRequestResolver;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface ServerCsrfTokenRequestHandler
extends ServerCsrfTokenRequestResolver {
    public void handle(ServerWebExchange var1, Mono<CsrfToken> var2);

    @Override
    default public Mono<String> resolveCsrfTokenValue(ServerWebExchange exchange2, CsrfToken csrfToken) {
        Assert.notNull((Object)exchange2, "exchange cannot be null");
        Assert.notNull((Object)csrfToken, "csrfToken cannot be null");
        return exchange2.getFormData().flatMap(data -> Mono.justOrEmpty(data.getFirst(csrfToken.getParameterName()))).switchIfEmpty(Mono.justOrEmpty((Object)exchange2.getRequest().getHeaders().getFirst(csrfToken.getHeaderName())));
    }
}

