/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icslite.i18n.init;

import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;

public enum I18nResources {
    INSTANCE;

    private static final CommonLogger LOG;
    private static final String RES_PATH_ROOT = "messages/res";
    private ResourceBundle resourceBundle;

    public void initResourceBundle(String lang) {
        String tempLang = lang;
        if (StringUtils.isBlank((CharSequence)tempLang)) {
            tempLang = "en";
        }
        Locale locale = new Locale("zh", "CN");
        if ("en".equals(tempLang)) {
            locale = new Locale("en", "US");
        }
        try {
            this.resourceBundle = ResourceBundle.getBundle(RES_PATH_ROOT, locale);
        }
        catch (MissingResourceException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Exception---when getting resourcebundle");
        }
    }

    public String getValueByKey(String resKey) {
        String value = "";
        if (StringUtils.isBlank((CharSequence)resKey)) {
            return value;
        }
        try {
            value = this.resourceBundle.getString(resKey);
        }
        catch (MissingResourceException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Exception---when getValue By Key{0}.", new Object[]{resKey});
        }
        return value;
    }

    static {
        LOG = CommonLoggerFactory.getLogger(I18nResources.class);
    }
}

