/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzZwy;
import com.aspose.words.zzT9;
import com.aspose.words.zzVS2;
import com.aspose.words.zzWJe;
import com.aspose.words.zzWmx;
import com.aspose.words.zzXSU;
import com.aspose.words.zzYfd;
import com.aspose.words.zzYn6;
import com.aspose.words.zzii;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzWJe,
Iterable<T> {
    private Node zzXed;
    private Node zzyH;
    private Node zzWoF;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.getParentNode().zzYMQ((Node)this, true);
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzXr1() {
        return this.zzYzN() != null;
    }

    final boolean zzMa() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzWd9() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzXSU) {
                return true;
            }
            CompositeNode compositeNode = zzZwy.zzXDP((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzWd9()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzXed;
    }

    public Node getLastChild() {
        return this.zzyH;
    }

    final Node zzYzN() {
        return zzWmx.zzXxe(this.getFirstChild(), false);
    }

    final Node zzXz0() {
        return zzWmx.zzZZc(this.getLastChild(), false);
    }

    final CompositeNode zzXHR() {
        return (CompositeNode)zzWmx.zzXxe(this.getFirstChild(), true);
    }

    final CompositeNode zzZNV() {
        return (CompositeNode)zzWmx.zzZZc(this.getLastChild(), true);
    }

    final Node zzWhO() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzWmx.zzY1u((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zz8v() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzWmx.zzY1u((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzXDP(boolean bl, zzVS2 zzVS22) {
        CompositeNode compositeNode = (CompositeNode)super.zzXDP(bl, zzVS22);
        ((CompositeNode)super.zzXDP(bl, zzVS22)).zzyH = null;
        compositeNode.zzXed = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzWSD(node.zzXDP(true, zzVS22));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzYgb(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzYgb(StringBuilder stringBuilder) {
        this.zz42(stringBuilder);
        zzZwy.zzYMQ(stringBuilder, this.zzWy7());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzYMQ(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzWmx.zzYuS(nodeType);
            Node node2 = node = bl ? this.zzYzN() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzYZK() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzii.zzYeh(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzii.zzWOR(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzT9(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzXDP(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzXDP(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        return this.zzYMQ(oldChild, false);
    }

    private Node zzYMQ(Node node, boolean bl) {
        if (node == null) {
            throw new NullPointerException("oldChild");
        }
        if (node.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzXDP(node, (Node)this, null, 1);
        if (documentBase.zzXFq() && zzWmx.zzW3U(node)) {
            return node;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzXDP(nodeChangingArgs);
        }
        if (!bl && zzWmx.zzXDB(node)) {
            zzWmx.zzZTs(node, false);
        }
        Node node2 = this.zzYH(node);
        if (nodeChangingArgs != null) {
            documentBase.zzYMQ(nodeChangingArgs);
        }
        return node2;
    }

    public void removeAllChildren() {
        zzYfd.zzWIb(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzWSD(Node node) {
        node.getParentNode();
        if (this.zzyH == null) {
            node.zza6(null);
            node.zzXoH(null);
            this.zzXed = node;
        } else {
            node.zza6(this.zzyH);
            node.zzXoH(null);
            this.zzyH.zzXoH(node);
        }
        this.zzyH = node;
        node.zzWOw(this);
        return node;
    }

    final void zzXDP(Node node, Node node2, Node node3) {
        this.zzXDP(node, node2, node3, false);
    }

    final void zzXDP(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzX8e(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzYMQ(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzYeh(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzWmx.zzY1u(node3.getNodeType())) continue;
            if (zzWmx.zzXl0(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzWy7().length();
    }

    String zzWy7() {
        return "";
    }

    final String zzBW() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zz42(stringBuilder);
        return stringBuilder.toString();
    }

    private void zz42(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzYgb(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzXDP(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzYMQ(visitor));
    }

    abstract int zzXDP(DocumentVisitor var1) throws Exception;

    abstract int zzYMQ(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzX8e(Node var1);

    final Node zzXDP(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzWdL(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzX8e(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzYn6(documentBase);
            try {
                compositeNode.zzYMQ(node, true);
            }
            finally {
                ((zzYn6)object).dispose();
            }
        }
        if ((object = documentBase.zzXDP(node, null, (Node)this, 0)) != null) {
            documentBase.zzXDP((NodeChangingArgs)object);
        }
        if (this.zzyH == null) {
            node.zza6(null);
            node.zzXoH(null);
            this.zzXed = node;
            this.zzyH = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzYMQ(node, node2);
            } else {
                this.zzYeh(node, this.zzXed);
            }
        } else if (node2 != null) {
            this.zzYeh(node, node2);
        } else {
            this.zzYMQ(node, this.zzyH);
        }
        node.zzWOw(this);
        if (object != null) {
            documentBase.zzYMQ((NodeChangingArgs)object);
        }
        if (documentBase.zzXFq()) {
            zzWmx.zzXDP(node, compositeNode, node3);
        }
        return node;
    }

    private void zzYMQ(Node node, Node node2) {
        Node node3 = node2.zzYR9();
        node.zza6(node2);
        node.zzXoH(node3);
        node2.zzXoH(node);
        if (node3 == null) {
            this.zzyH = node;
            return;
        }
        node3.zza6(node);
    }

    private void zzYeh(Node node, Node node2) {
        Node node3 = node2.zzZPQ();
        node.zza6(node3);
        node.zzXoH(node2);
        node2.zza6(node);
        if (node3 == null) {
            this.zzXed = node;
            return;
        }
        node3.zzXoH(node);
    }

    private Node zzYH(Node node) {
        if (node == this.zzXed) {
            if (this.zzXed == this.zzyH) {
                this.zzXed = null;
                this.zzyH = null;
            } else {
                this.zzXed = node.zzYR9();
                this.zzXed.zza6(null);
            }
        } else {
            Node node2 = node.zzZPQ();
            Node node3 = node.zzYR9();
            node2.zzXoH(node3);
            if (node3 == null) {
                this.zzyH = node2;
            } else {
                node3.zza6(node2);
            }
        }
        node.zzXoH(null);
        node.zza6(null);
        node.zzWOw(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzWoF = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzWoF;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

