/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zz0t;
import com.aspose.words.internal.zzP2;
import com.aspose.words.internal.zzRm;
import com.aspose.words.internal.zzW0r;
import com.aspose.words.internal.zzW5f;
import com.aspose.words.internal.zzXez;
import com.aspose.words.internal.zzXgH;
import com.aspose.words.internal.zzY6r;
import com.aspose.words.internal.zzYLi;
import com.aspose.words.internal.zzYlQ;
import com.aspose.words.internal.zzZ97;
import com.aspose.words.internal.zzZQv;
import com.aspose.words.internal.zzZep;
import com.aspose.words.internal.zzZpx;
import com.aspose.words.internal.zzZqd;
import com.aspose.words.internal.zzZwy;
import com.aspose.words.internal.zzii;
import com.aspose.words.internal.zzuk;
import com.aspose.words.zz7Q;
import com.aspose.words.zzW07;
import com.aspose.words.zzW4S;
import com.aspose.words.zzW6M;
import com.aspose.words.zzW6s;
import com.aspose.words.zzW76;
import com.aspose.words.zzWDy;
import com.aspose.words.zzWGX;
import com.aspose.words.zzWaX;
import com.aspose.words.zzWmx;
import com.aspose.words.zzWq;
import com.aspose.words.zzWwM;
import com.aspose.words.zzWwo;
import com.aspose.words.zzWxP;
import com.aspose.words.zzX2l;
import com.aspose.words.zzX45;
import com.aspose.words.zzX8A;
import com.aspose.words.zzXM0;
import com.aspose.words.zzXO0;
import com.aspose.words.zzXWE;
import com.aspose.words.zzXc;
import com.aspose.words.zzXkQ;
import com.aspose.words.zzXnu;
import com.aspose.words.zzXvv;
import com.aspose.words.zzY1Y;
import com.aspose.words.zzY3j;
import com.aspose.words.zzYCx;
import com.aspose.words.zzYHp;
import com.aspose.words.zzYMf;
import com.aspose.words.zzYNR;
import com.aspose.words.zzYRR;
import com.aspose.words.zzYYP;
import com.aspose.words.zzYZ5;
import com.aspose.words.zzYkS;
import com.aspose.words.zzYn6;
import com.aspose.words.zzYx7;
import com.aspose.words.zzYxj;
import com.aspose.words.zzZFd;
import com.aspose.words.zzZIM;
import com.aspose.words.zzZUx;
import com.aspose.words.zzZWv;
import com.aspose.words.zzf2;
import com.aspose.words.zzs4;
import com.aspose.words.zzwg;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzW6s,
zzWxP,
zzXvv,
zzY1Y {
    private Document zzHa;
    private Node zzYDl;
    private Node zzYSu;
    private zzYkS zzWHn;
    private Font zztg;
    private zz0t<zzYkS> zzWkF;
    private zz0t<zzYRR> zzYR8;
    private zz0t<zzXDP> zzZSX;
    private zzZUx zzZvu = zzZUx.zzYSy();
    private zzX8A zzXvp = new zzX8A();
    private zzYRR zzYkP;
    private RowFormat zz9e;
    private CellFormat zzwI;
    private ParagraphFormat zz9D;
    private zz0t<zzYx7> zzWo2;
    private int zzWM1 = 0;
    private int zzAF = -1;
    private int zzXHN;
    private boolean zzXc8;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzZTs(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzZTs(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzZTs(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXDP(documentBuilder.getCurrentSection(), zzY3j.zzTY(headerFooterType), 0, 0);
    }

    private void zzZTs(int n, int n2, int n3, int n4) {
        this.zzHa.ensureMinimum();
        Section section = (Section)this.zzHa.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzXDP(section, 1, n3, n4);
    }

    private void zzXDP(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzY3j.zzZZe(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzHa, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzHa));
            }
        }
        this.zzXDP(story, n2, n3);
    }

    private void zzXDP(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXDP((CompositeNode)paragraph2, n3);
    }

    final void zzXDP(Paragraph paragraph, int n) {
        this.zzXDP((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzXU3().zzY3r() ? zzwg.zzDu(this.zzHa, fieldName) : zzwg.zzX8e(this.zzXU3(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzXDP(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzXDP(field, isAfter, false);
    }

    private boolean zzXDP(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzYxj zzYxj2 = field.getFormat().zzXhV();
        Inline inline = zzYxj2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzXDP(inline.zzXI4(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzWDy.zzXDP(this.zzHa, bookmarkName) : zzWDy.zzYMQ(this.zzHa, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzWVd() == 6) {
            this.zzXDP((Paragraph)node.zzYNV(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzWmx.zzXOm(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzXDP(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXDP(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToStructuredDocumentTag(int structuredDocumentTagIndex, int characterIndex) {
        StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.getCurrentStory().getChild(28, structuredDocumentTagIndex, true);
        if (structuredDocumentTag == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: structuredDocumentTagIndex");
        }
        this.moveToStructuredDocumentTag(structuredDocumentTag, characterIndex);
    }

    public void moveToStructuredDocumentTag(StructuredDocumentTag structuredDocumentTag, int characterIndex) {
        if (structuredDocumentTag == null) {
            throw new NullPointerException("structuredDocumentTag");
        }
        if (characterIndex >= 0) {
            this.zzYMQ(structuredDocumentTag, characterIndex);
            return;
        }
        if (++characterIndex == 0) {
            this.zzXDP(structuredDocumentTag);
            return;
        }
        this.zzYeh(structuredDocumentTag, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzX5e(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzXDP(cell, characterIndex);
    }

    private void zzXDP(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzWVd() == 6) {
            this.zzYNR(node);
        } else {
            Node node2 = node;
            if (zzWmx.zzY1u(node2.getNodeType())) {
                Paragraph paragraph = zzWmx.zzXOm(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzYNR(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzWVd() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzYNR(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzXHN = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzX6R();
            return;
        }
        if (!this.zzX6I()) {
            this.zzX6R();
        }
    }

    private boolean zzX6I() {
        Node node = this.zzXU3();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
            if (node == null && this.zzXU3().getParentNode().getNodeType() == 28) {
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzXDP(((StructuredDocumentTag)documentBuilder.zzXU3().getParentNode()).zzY0u(), true);
                return true;
            }
        }
        if (node == null) {
            for (node = this.zzXU3(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzXDP(inline.zzXI4(), true);
            return true;
        }
        return false;
    }

    private void zzX6R() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXDP(documentBuilder.getCurrentParagraph().zzWim(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzX5e(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzYTM() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzXU3().zzWdL(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzX5();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzXDP((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzTN(text, false);
    }

    public void writeln(String text) {
        this.zzTN(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph;
        this.zzYzU();
        Paragraph paragraph2 = this.getCurrentParagraph();
        zzYn6 zzYn62 = new zzYn6(this.getDocument());
        try {
            paragraph = new Paragraph(this.zzHa, this.zz2w(), this.zzl5());
            if (paragraph2 == null && this.isAtEndOfStructuredDocumentTag()) {
                this.getCurrentStructuredDocumentTag().appendChild(paragraph);
            } else {
                this.getCurrentParagraph().getParentNode().insertAfter(paragraph, this.getCurrentParagraph());
            }
            if (this.isAtEndOfParagraph() || paragraph2 == null) {
                this.moveTo(paragraph);
            } else {
                paragraph.zzYMQ(this.zzXU3(), null, paragraph.getLastChild());
            }
        }
        finally {
            zzYn62.dispose();
        }
        if (this.getDocument().zzXFq()) {
            zzWmx.zzYeh((zzYYP)(paragraph2 != null ? paragraph2 : paragraph), this.getDocument().zzYOr());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzYbd() {
        zzYkS zzYkS2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzYzU();
        Node node = this.zzXU3();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzWgq(false);
        } else {
            run2 = run = (Run)node.zzZOb(21);
        }
        if (run2 == null && zzZwy.zzcs(node, paragraph.zzXc8())) {
            run = paragraph.zzXc8();
        }
        if (run != null) {
            cloneable = run.zzXI4();
            zzYkS2 = (zzYkS)((zzYNR)cloneable).zzWst();
        } else {
            cloneable = paragraph.zzWim();
            zzYkS2 = (zzYkS)((zzYNR)cloneable).zzWst();
        }
        zzYkS zzYkS3 = zzYkS2;
        Paragraph paragraph2 = new Paragraph(this.zzHa, this.zz2w(), zzYkS3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzYn6 zzYn62 = new zzYn6(this.zzHa);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzYMQ(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzYn62.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzXkQ.zzDu(this);
    }

    public void insertBreak(int breakType) {
        this.zz71(breakType, true);
    }

    final void zz71(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzsw(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzXjK(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzVYk())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzsw(bl)) {
                        this.zzXjK(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzsw(bl)) {
                        this.zzXrG(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzsw(bl)) {
                        this.zzXrG(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzsw(bl)) {
                        this.zzXrG(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzsw(bl)) {
                        this.zzXrG(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzsw(bl)) {
                        this.zzXrG(4);
                    }
                    return;
                }
                case 8: {
                    this.zzXjK(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzii.zzWta(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzXgH.zzYMQ("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzYzU();
        return zzWmx.zzXDP(fieldType, updateField, this.zzl5(), this.zzZaP(), this.zzYvI(), this.zzYvI() == null);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzYzU();
        return zzWmx.zzXDP(fieldCode, this.zzl5(), this.zzZaP(), this.zzYvI(), this.zzYvI() == null);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzYzU();
        return zzWmx.zzXDP(fieldCode, fieldValue, this.zzl5(), this.zzZaP(), this.zzYvI(), this.zzYvI() == null);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzZwy.zzYMQ((Object)displayText, "displayText");
        zzZwy.zzYMQ((Object)urlOrBookmark, "hrefOrBookmark");
        zzX2l zzX2l2 = this.zzYMQ(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzX2l2.zzYMQ(documentBuilder.zzwN(88, true));
        return zzWmx.zzXDP(zzX2l2.getStart(), zzX2l2.getSeparator(), zzX2l2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzzR(70);
        if (zzii.zzWta(name)) {
            this.startBookmark(name);
        }
        this.zzZmH(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzYj(70);
        String string = zzii.zzWta(fieldValue) ? fieldValue : FormField.zzZCc;
        Run run = new Run(this.zzHa, string, this.zzl5());
        this.insertNode(run);
        Node node = this.zzwN(70, true);
        if (zzii.zzWta(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zz7Q(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzXDP((Paragraph)node.zzYNV(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzzR(71);
        if (zzii.zzWta(name)) {
            this.startBookmark(name);
        }
        this.zzZmH(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzwN(71, false);
        if (zzii.zzWta(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zz7Q(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzzR(83);
        if (zzii.zzWta(name)) {
            this.startBookmark(name);
        }
        this.zzZmH(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzwN(83, false);
        if (zzii.zzWta(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zz7Q(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzHa, footnoteType, !zzii.zzWta(referenceMark), referenceMark, this.zzl5());
        Style style = this.getDocument().getStyles().zzWGo(zzWmx.zzfz(footnoteType));
        footnote.zzXI4().set(50, style.zzZI());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzHa);
        Style style2 = this.getDocument().getStyles().zzWGo(zzWmx.zzWC2(footnoteType));
        paragraph.zzXL7().set(1000, style2.zzZI());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzHa, '\u0002', new zzYkS()) : new Run(this.zzHa, footnote.getReferenceMark(), new zzYkS());
        inline.zzXI4().set(50, style.zzZI());
        paragraph.appendChild(inline);
        if (zzii.zzWta(footnoteText)) {
            Node node = this.zzXU3();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzYNR(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzVVP(zzZQv zzZQv2) throws Exception {
        return this.zzXDP(zzZQv2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzVVP(zzZQv.zzYMQ(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzXDP(zzZQv zzZQv2, double d, double d2) throws Exception {
        return this.zzXDP(zzZQv2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzXDP(zzZQv.zzYMQ(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        zzuk zzuk2 = new zzuk();
        try {
            zzP2.zzXDP(image, zzuk2);
            Shape shape = this.zzXDP(zzuk2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            zzuk2.close();
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzZwy.zzYeh(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzRm.zzXrb(fileName);
        try {
            Shape shape = this.zzXDP((zzZQv)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzZQv)object).close();
            }
        }
    }

    private Shape zzXDP(zzZQv zzZQv2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzZQv2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzZwy.zzXl0(zzZQv2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXDP(zzZQv.zzYMQ(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXDP(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzXDP(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl2 = false;
        if (zzW0r.zzWEu(object)) {
            object4 = new zzP2((byte[])object);
            bl2 = true;
            ((zzXez)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzHa.getCompatibilityOptions().getMswVersion() > 12 || this.zzHa.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzHa, 0);
            object3 = new zzWq();
            ((zzWwo)object3).zzXDP(zzW76.zzXDG("rect"));
            ((zzWq)object3).zzXDP(new zzYCx());
            ((zzWq)object3).zzYdp().zzcb().zzYeh(this.zzHa);
            object2 = new zzXnu();
            ((zzZFd)object2).zzYMQ(new zzXM0(this.zzHa.zzWJU(), ""));
            ((zzZFd)object2).zzXDP(new zzZWv());
            ((zzWwM)object3).zzXDP((zzZFd)object2);
            shape.zzXxh(75);
            shape.zzXl0((zzWwM)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzHa, 75);
        }
        if (zzW0r.zzYRH(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzXDP((byte[])object, new zzs4(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzs4(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzW0r.zzW3U((byte[])object2));
                this.zzXDP((zzWq)shape.zzox(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzWq)shape.zzox()).zzYdp().zzcb().zzZTR((byte[])object);
            object3 = zzW0r.zzYnK(object);
            object4 = new zzs4(((zzW5f)object3).getWidthPoints(), ((zzW5f)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzXDP(this.zzl5());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzW0r.zzYF5(object)) {
            d5 = DocumentBuilder.zzXDP(shape, object);
        }
        shape.zzXDP(d3, d4, (zzs4)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzXDP(Shape shape, byte[] byArray) throws Exception {
        int n = zzW0r.zzcM(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzWmx.zzXLT(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzWmx.zzY47(n);
        return d;
    }

    private void zzXDP(zzWq zzWq2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzWq2.zzYdp().zzcb().getExtensions();
        zzuk zzuk2 = new zzuk(byArray);
        try {
            object = zzWmx.zzXDP(zzuk2, this.zzHa);
            ((zzX45)object).zzYWW(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzX45)object).zzYSV();
            byArray2 = ((zzX45)object).zzYf(true);
        }
        finally {
            zzuk2.close();
        }
        zzWq2.zzYdp().zzcb().setExtensions(new zzZep<zzYMf>());
        object = zzYMf.zzXDP(byArray2, this.zzHa);
        zzWq2.zzYdp().zzcb().getExtensions().zzWtP(((zzYMf)object).getUri(), (zzYMf)object);
    }

    private Shape zzXDP(zzZQv zzZQv2, String string, boolean bl, zzZQv zzZQv3) throws Exception {
        zzXO0 zzXO02 = zzXO0.zzWUH(string);
        Shape shape = this.zzXDP(zzZQv3, bl, zzXO02, null);
        zzWaX zzWaX2 = zzW07.zzXDP(zzZQv2, string, bl);
        return DocumentBuilder.zzXDP(null, false, shape, zzXO02.zzKQ, zzWaX2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXDP(zzZQv.zzYMQ(stream), progId, asIcon, zzZQv.zzYMQ(presentation));
    }

    private Shape zzXDP(String string, boolean bl, boolean bl2, zzZQv zzZQv2) throws Exception {
        zzXO0 zzXO02 = zzXO0.zzXZO(zzZpx.zzoY(string));
        return this.zzXDP(string, bl, bl2, zzZQv2, zzXO02);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXDP(fileName, isLinked, asIcon, zzZQv.zzYMQ(presentation));
    }

    private Shape zzXDP(String string, String string2, boolean bl, boolean bl2, zzZQv zzZQv2) throws Exception {
        zzXO0 zzXO02 = zzXO0.zzWUH(string2);
        return this.zzXDP(string, bl, bl2, zzZQv2, zzXO02);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXDP(fileName, progId, isLinked, asIcon, zzZQv.zzYMQ(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzXO0 zzXO02 = zzXO0.zzXZO(zzZpx.zzoY(fileName));
        return this.zzXDP(fileName, isLinked, iconFile, iconCaption, zzXO02);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzXO0 zzXO02 = zzXO0.zzWUH(progId);
        return this.zzXDP(fileName, isLinked, iconFile, iconCaption, zzXO02);
    }

    private Shape zzXDP(zzZQv zzZQv2, String string, String string2, String string3) throws Exception {
        zzXO0 zzXO02 = zzXO0.zzWUH(string);
        Shape shape = this.zzXDP(string2, string3, zzXO02);
        zzWaX zzWaX2 = zzW07.zzXDP(zzZQv2, string, true);
        return DocumentBuilder.zzXDP(null, false, shape, zzXO02.zzKQ, zzWaX2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzXDP(zzZQv.zzYMQ(stream), progId, iconFile, iconCaption);
    }

    final Shape zzXDP(zzYZ5 zzYZ52, zzZQv zzZQv2) throws Exception {
        Shape shape = this.zzYbU(zzZQv2);
        shape.zzXxh(201);
        shape.setShapeAttr(4112, zzYZ52);
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzYzU();
        if (this.zzXCi()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzVPe(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzXWE zzXWE2 = zzWmx.zzXDP(html, options, this);
        zzXWE2.zzWS();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzYzU();
        return zzWmx.zzXDP(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzYzU();
        return zzWmx.zzXDP(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzXc zzXc2 = new zzXc();
        return zzXc2.zzXDP(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZIM(this).zzXDP(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZIM(this).zzXDP(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzHa, 75);
        shape.zzXDP(this.zzl5());
        shape.zzYck(true);
        shape.getSignatureLine().zzXDP(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzWCr(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzXAh(this.zzHa);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzXCi() {
        boolean bl = false;
        if (this.zzXU3().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzXU3().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzVPe(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzYzU();
        if (this.zzYTM() == null) {
            this.startTable();
        }
        if (this.zzYTM().zzXKk() == 1) {
            this.zzYTM().zzWx3();
        }
        if (this.zzYTM().zzXKk() == 3) {
            this.zzYTM().zzYsV();
        }
        return this.zzYTM().zzZaQ();
    }

    public Table startTable() {
        this.zzWo2.push(new zzYx7(this));
        return this.zzYTM().startTable();
    }

    public Table endTable() {
        if (this.zzYTM() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzYTM().endTable();
        this.zzWo2.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzYTM() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzYTM().endRow();
        if (this.zztg != null && this.zztg.getHidden()) {
            row.zzYQA().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzHa, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzHa, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzZNA();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzHa, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzXaA();
        bookmarkStart.zzIn(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzZNA();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzXaA();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzHa, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zztI(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzHa);
        this.zzAF = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzAF == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzHa, this.zzAF);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzHa, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzZwy.zzYMQ((Object)importFormatOptions, "ImportFormatOptions");
        this.zzYzU();
        return zzW4S.zzXDP(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzHa;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzHa) {
            return;
        }
        this.zzHa = value;
        this.zzYNR(null);
        this.zzWHn = new zzYkS();
        this.zzWkF = null;
        this.zzYR8 = null;
        this.zztg = null;
        this.zzWo2 = new zz0t();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zztg == null) {
            DocumentBuilder documentBuilder = this;
            this.zztg = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zztg;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zz9D == null) {
            DocumentBuilder documentBuilder = this;
            this.zz9D = new ParagraphFormat(documentBuilder, documentBuilder.getDocument().getStyles());
        }
        return this.zz9D;
    }

    public ListFormat getListFormat() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().getListFormat();
        }
        return null;
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zz9e == null) {
            this.zz9e = new RowFormat(this);
        }
        return this.zz9e;
    }

    public CellFormat getCellFormat() {
        if (this.zzwI == null) {
            this.zzwI = new CellFormat(this);
        }
        return this.zzwI;
    }

    final void zzX4Y(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzYkS zzYkS2;
        if (this.getCurrentParagraph() != null) {
            zzYkS zzYkS3 = this.getCurrentParagraph().zzWim();
            zzYkS2 = (zzYkS)zzYkS3.zzWst();
        } else {
            zzYkS2 = this.zzl5();
        }
        zzYkS zzYkS4 = zzYkS2;
        this.zzZvG().push(new zzXDP(this.zzl5(), zzYkS4));
    }

    public void popFont() {
        zz0t<zzXDP> zz0t2 = this.zzZvG();
        if (zz0t2.size() > 0) {
            zzXDP zzXDP2 = (zzXDP)this.zzZvG().pop();
            this.zzXDP(zzXDP2.zzXI4(), false);
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzXxJ(zzXDP2.zzYEI());
            }
        }
    }

    final void zzZHg() {
        this.zzXSF().push(this.zzl5());
    }

    final void zzWoR() {
        zz0t<zzYkS> zz0t2 = this.zzXSF();
        if (zz0t2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzXDP((zzYkS)documentBuilder.zzXSF().pop(), false);
        }
    }

    final void zzY9m() {
        this.zzWI9().push(this.zz2w());
    }

    final void zzXOc() {
        zz0t<zzYRR> zz0t2 = this.zzWI9();
        if (zz0t2.size() > 0) {
            zzYRR zzYRR2 = (zzYRR)this.zzWI9().pop();
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzXDP(zzYRR2);
            }
        }
    }

    final zzX2l zzYMQ(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzzR(88);
        zzW6M zzW6M2 = new zzW6M();
        zzW6M2.setTarget(string2);
        zzW6M2.setScreenTip(string3);
        if (bl) {
            zzW6M2.setSubAddress(string);
        } else {
            zzW6M2.setAddress(zzZqd.zzYuV(string));
            zzW6M2.setSubAddress(zzZqd.zzYgN(string));
        }
        this.zzZmH(zzW6M2.zz2R());
        FieldSeparator fieldSeparator = this.zzYj(88);
        return new zzX2l(fieldStart, fieldSeparator, null);
    }

    final zzX2l zzZTs(String string, String string2, String string3) {
        boolean bl = zzZqd.zzvB(string);
        String string4 = bl ? zzZqd.zzYgN(string) : string;
        return this.zzYMQ(string4, bl, string2, string3);
    }

    final FieldEnd zzZD0() {
        return this.zzwN(88, true);
    }

    final zzYkS zzl5() {
        zzYkS zzYkS2 = this.zzWHn;
        return (zzYkS)zzYkS2.zzWst();
    }

    final zzYRR zz2w() {
        zzYRR zzYRR2 = this.zzXL7();
        return (zzYRR)zzYRR2.zzWst();
    }

    final zzZUx zzYDq() {
        zzZUx zzZUx2 = this.zzYQA();
        return (zzZUx)zzZUx2.zzWst();
    }

    final zzX8A zzWdi() {
        zzX8A zzX8A2 = this.zzYJP();
        return (zzX8A)zzX8A2.zzWst();
    }

    public boolean isAtStartOfParagraph() {
        if (this.getCurrentParagraph() == null) {
            return false;
        }
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzXU3(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzXU3().getNodeType() == 8;
    }

    public boolean isAtEndOfStructuredDocumentTag() {
        return this.zzXc8 && this.zzXU3().getNodeType() == 28;
    }

    private void zzTN(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            switch (((StructuredDocumentTag)this.zzXU3()).getLevel()) {
                case 2: {
                    this.insertParagraph();
                    bl = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot insert text at this cursor position.");
                }
            }
        }
        String string2 = zzY3j.zzZ4P(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzYWg(string2.substring(n4, n4 + n2));
                }
                switch (this.zzWM1) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzXjK(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzYWg(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzYzU();
        if (this.zzYTM() != null && this.zzYTM().zzXKk() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            this.getCurrentStructuredDocumentTag().appendChild(node);
            return;
        }
        this.zzXU3().getParentNode().insertBefore(node, this.zzXU3());
    }

    final void zzWZv(int n) {
        this.zzsw(true);
        this.zzXrG(n);
    }

    private void zzXrG(int n) {
        this.insertParagraph();
        zzYn6 zzYn62 = new zzYn6(this.getDocument());
        try {
            zzf2 zzf22 = this.getCurrentSection().zzWS7();
            zzf2 zzf23 = (zzf2)zzf22.zzWst();
            Section section = new Section(this.zzHa, zzf23);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzHa));
            this.zzHa.insertAfter(section, this.getCurrentSection());
            section.getBody().zzYMQ(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzYn62.dispose();
        }
    }

    final FieldStart zzzR(int n) {
        this.zzYzU();
        return zzWmx.zzXDP(n, this.zzl5(), this.zzZaP(), this.zzYvI(), this.zzYvI() == null);
    }

    final Run zzZmH(String string) {
        return zzWmx.zzYMQ(string, this.zzl5(), this.zzZaP(), this.zzYvI(), this.zzYvI() == null);
    }

    final FieldEnd zzwN(int n, boolean bl) {
        return zzWmx.zzYMQ(n, bl, this.zzl5(), this.zzZaP(), this.zzYvI(), this.zzYvI() == null);
    }

    final FieldSeparator zzYj(int n) {
        return zzWmx.zzYMQ(n, this.zzl5(), this.zzZaP(), this.zzYvI(), this.zzYvI() == null);
    }

    private FormField zz7Q(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzHa, new zzYHp(), this.zzl5());
        CompositeNode compositeNode = node == null ? this.zzZaP() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzsw(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzYTM() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzX5e(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzYWg(String string) {
        if (this.zzWzB(string)) {
            zzYlQ zzYlQ2 = new zzYlQ(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzZ97 zzZ972 : zzYlQ2.zzX3K(this.getParagraphFormat().getBidi())) {
                zz7Q zz7Q2 = zz7Q.zzZ7J(zzZ972.zzZIB());
                zzYkS zzYkS2 = this.zzl5();
                zzYkS2.zzZNm(265, zz7Q2);
                if (zzZ972.zzco()) {
                    zzYkS2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzHa, zzZ972.getText(), zzYkS2);
                this.insertNode(run);
            }
            return;
        }
        this.zzXjK(string);
    }

    private boolean zzWzB(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzY6r.zzVSI(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzXDP(zzYkS zzYkS2, boolean bl) {
        zzYkS zzYkS3;
        if (bl) {
            zzYkS zzYkS4 = zzYkS2;
            zzYkS3 = (zzYkS)zzYkS4.zzWst();
        } else {
            zzYkS3 = zzYkS2;
        }
        this.zzWHn = zzYkS3;
    }

    final void zzap() {
        this.zzWHn.clear();
    }

    final void zz3S() {
        if (this.zzZNA() != null) {
            zzX8A zzX8A2;
            zzX8A zzX8A3 = zzX8A2 = this.zzZNA().zzYJP();
            this.zzXvp = (zzX8A)zzX8A3.zzWst();
            zzX8A2.zzYMQ(this.zzXvp);
        }
    }

    private Shape zzXDP(String string, boolean bl, boolean bl2, zzZQv zzZQv2, zzXO0 zzXO02) throws Exception {
        if (zzXO02 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzXDP(zzZQv2, bl2, zzXO02, string);
        zzWaX zzWaX2 = zzW07.zzXDP(string, bl, bl2, zzXO02);
        return DocumentBuilder.zzXDP(string, bl, shape, zzXO02.zzKQ, zzWaX2);
    }

    private Shape zzXDP(String string, boolean bl, String string2, String string3, zzXO0 zzXO02) throws Exception {
        if (zzXO02 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzZpx.zzSF(string);
        }
        Shape shape = string2 != null ? this.zzYnK(string2, string3) : this.zzXDP(null, string3, zzXO02);
        zzWaX zzWaX2 = zzW07.zzXDP(string, bl, true, zzXO02);
        return DocumentBuilder.zzXDP(string, bl, shape, zzXO02.zzKQ, zzWaX2);
    }

    private static Shape zzXDP(String string, boolean bl, Shape shape, String string2, zzWaX zzWaX2) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzXxh(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzYMQ(zzWaX2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzXDP(zzZQv zzZQv2, boolean bl, zzXO0 zzXO02, String string) throws Exception {
        if (zzXO02 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzZQv2 != null) {
            return this.zzYbU(zzZQv2);
        }
        if (!bl) {
            return this.zzZj(zzW07.zzWNd().get("normal"));
        }
        String string2 = string != null ? zzZpx.zzSF(string) : zzW07.zzYuS(zzXO02.zzWJh);
        return this.zzXDP(zzXO02, string2);
    }

    private Shape zzXDP(String string, String string2, zzXO0 zzXO02) throws Exception {
        if (zzXO02 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzW07.zzYuS(zzXO02.zzWJh);
        }
        if (string != null) {
            return this.zzYnK(string, string2);
        }
        return this.zzXDP(zzXO02, string2);
    }

    private Shape zzXDP(zzXO0 zzXO02, String string) throws Exception {
        if (zzXO02 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzW07.zzY1u(zzXO02.zzWJh);
        zzYLi zzYLi2 = new zzYLi(byArray, null, string, this.getDocument().zzYQD());
        return this.zzZj(zzYLi2.zzY3N());
    }

    private Shape zzYnK(String string, String string2) throws Exception {
        zzYLi zzYLi2 = new zzYLi(string, string2, this.getDocument().zzYQD());
        return this.zzZj(zzYLi2.zzY3N());
    }

    private Shape zzYbU(zzZQv zzZQv2) throws Exception {
        byte[] byArray = zzZwy.zzXl0(zzZQv2);
        return this.zzZj(byArray);
    }

    private Shape zzZj(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzHa, 1);
        shape.zzXxh(75);
        shape.zzXDP(this.zzl5());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzWCr(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzXDP(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzYMQ(compositeNode, n);
            return;
        }
        this.zzYeh(compositeNode, n);
    }

    private void zzYMQ(CompositeNode compositeNode, int n) {
        zzWGX zzWGX2 = zzWGX.zzWnz(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            int n2;
            int n3;
            zzWGX2.zzXDP(null, true, true, true, false, true);
            node = zzWGX2.getNode();
            if (zzWGX2.zzWQc() && (!node.isComposite() || node.zzWVd() != 6 || n != 0)) continue;
            int n4 = n3 = node.isComposite() ? ((CompositeNode)node).zzWy7().length() : node.getTextLength();
            if (!zzWGX2.zzWQc() && n3 == 0 && node.isComposite() && node != compositeNode || (n2 = n) != 0 && (n -= n3) >= 0) continue;
            if (!zzWGX2.zzWQc() && node == compositeNode && compositeNode.getNodeType() == 28) {
                this.zzXDP((StructuredDocumentTag)compositeNode);
                return;
            }
            this.zzXDP(null, node);
            this.zzXHN = n2;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzXDP(StructuredDocumentTag structuredDocumentTag) {
        this.zzYNR(structuredDocumentTag);
        this.zzXc8 = true;
        this.zzXHN = 0;
        zzYkS zzYkS2 = structuredDocumentTag.zzY0u();
        switch (structuredDocumentTag.zzWVd()) {
            case 6: {
                Node node;
                for (node = structuredDocumentTag.zz8v(); node != null && !(node instanceof Inline); node = node.getPreviousSibling()) {
                }
                if (node == null) break;
                zzYkS2 = ((Inline)node).zzXI4();
                break;
            }
            case 3: {
                Paragraph paragraph = (Paragraph)structuredDocumentTag.getChild(8, -1, true);
                if (paragraph == null) break;
                zzYkS2 = paragraph.zzWim();
                break;
            }
            default: {
                return;
            }
        }
        this.zzXDP(zzYkS2, true);
    }

    private void zzYeh(CompositeNode compositeNode, int n) {
        zzWGX zzWGX2 = zzWGX.zzZVK(compositeNode);
        while (zzWGX2.getNode() != compositeNode || !zzWGX2.zzWQc()) {
            int n2;
            Node node = zzWGX2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzWy7().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzXDP(null, node);
                this.zzXHN = n;
                return;
            }
            while (zzWGX2.zzXDP(null, false, true, true, false, true) && zzWGX2.zzWQc() && zzWGX2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzYzU() {
        int n = this.zzXHN;
        if (n == 0) {
            return;
        }
        this.zzXHN = 0;
        Run run = zzZwy.zzXDP((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzZCQ(n);
        }
    }

    private Run zzXjK(String string) {
        Run run = new Run(this.zzHa, string, this.zzl5());
        this.insertNode(run);
        return run;
    }

    final boolean zzVVr() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzWW9() {
        return this.zzWM1;
    }

    final void zzZU5(int n) {
        this.zzWM1 = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzXU3();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzXU3();
        }
        return (Paragraph)this.zzXU3().getAncestor(8);
    }

    public StructuredDocumentTag getCurrentStructuredDocumentTag() {
        if (this.isAtEndOfStructuredDocumentTag()) {
            return (StructuredDocumentTag)this.zzXU3();
        }
        return (StructuredDocumentTag)this.zzXU3().getAncestor(28);
    }

    public Story getCurrentStory() {
        return (Story)this.zzXU3().getAncestor(Story.class);
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzYx7 zzYTM() {
        zz0t<zzYx7> zz0t2 = this.zzWo2;
        if (zz0t2.size() > 0) {
            return (zzYx7)this.zzWo2.peek();
        }
        return null;
    }

    private Cell zzZNA() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzVTW();
    }

    private CompositeNode zzZaP() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return (CompositeNode)this.zzXU3();
        }
        return this.zzXU3().getParentNode();
    }

    private Node zzYvI() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzXU3();
    }

    private zz0t<zzYkS> zzXSF() {
        if (this.zzWkF == null) {
            this.zzWkF = new zz0t();
        }
        return this.zzWkF;
    }

    private zz0t<zzYRR> zzWI9() {
        if (this.zzYR8 == null) {
            this.zzYR8 = new zz0t();
        }
        return this.zzYR8;
    }

    private zz0t<zzXDP> zzZvG() {
        if (this.zzZSX == null) {
            this.zzZSX = new zz0t();
        }
        return this.zzZSX;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzWHn.zzWyq(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key, int revisionsView) {
        return this.zzWHn.zzYn8(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzWlf(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzWlf(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzWHn.zzZNm(fontAttr, value);
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWKC()) {
            this.getCurrentParagraph().zzWim().zzZNm(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzWHn.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzWHn.clear();
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWKC()) {
            this.getCurrentParagraph().zzWim().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzXL7().zzWyq(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzXL7().zzYn8(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzYrT(key, 0);
        }
        return this.getDocument().getStyles().zzj6().zzBO(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        DocumentBuilder documentBuilder = this;
        Object object = documentBuilder.getDirectParaAttr(key);
        if (object != null) {
            return object;
        }
        return documentBuilder.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        if (this.getCurrentParagraph() != null) {
            this.getCurrentParagraph().setParaAttr(key, value);
            return;
        }
        this.zzXL7().zzZNm(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzXL7().remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzXL7().clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzYQA().zzWyq(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzYQA().zzBO(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzYQA().zzs(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzYQA().zzZNm(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzYQA().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzYQA().clear();
        zzZUx.zzYSy().zzYMQ(this.zzYQA());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzYJP().zzWyq(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzYJP().zzBO(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzYJP().zzs(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzZwy.zzXDP(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzZNA() != null ? this.zzZNA().getCellFormat() : this.getCellFormat();
            border.zzXDP(cellFormat);
        }
        this.zzYJP().zzZNm(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzYJP().clear();
    }

    private Node zzXU3() {
        Node node = this.zzYDl != null && this.zzYDl.getParentNode() == null ? this.zzYSu : this.zzYDl;
        if (node != null && node.zzWVd() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        this.zzXc8 = this.zzXc8 && node != null && node.getNodeType() == 28;
        return node;
    }

    private void zzYNR(Node node) {
        this.zzYDl = node;
        if (this.zzYDl != null) {
            this.zzYSu = this.zzYDl.getParentNode();
        }
        this.zzXc8 = false;
    }

    private zzYRR zzXL7() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzXL7();
        }
        if (this.zzYkP == null) {
            this.zzYkP = new zzYRR();
        }
        return this.zzYkP;
    }

    private zzZUx zzYQA() {
        if (this.zzYTM() != null && this.zzYTM().zzXKk() == 1) {
            return this.zzZvu;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzYQA();
        }
        return this.zzZvu;
    }

    private zzX8A zzYJP() {
        if (this.zzYTM() != null && this.zzYTM().zzXKk() != 3) {
            return this.zzXvp;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzVTW().zzYJP();
        }
        return this.zzXvp;
    }

    static final class zzXDP {
        private zzYkS zzWHn;
        private zzYkS zzWhT;

        public zzXDP(zzYkS zzYkS2, zzYkS zzYkS3) {
            this.zzWHn = zzYkS2;
            this.zzWhT = zzYkS3;
        }

        public final zzYkS zzXI4() {
            return this.zzWHn;
        }

        public final zzYkS zzYEI() {
            return this.zzWhT;
        }
    }
}

