/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzod;
import com.aspose.words.zzHS;
import com.aspose.words.zzT9;
import com.aspose.words.zzWJe;
import com.aspose.words.zzWeq;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzWJe,
Iterable<T> {
    private Node zzWoF;
    private CompositeNode zzj2;
    private DocumentBase zz67;
    private boolean zzBs;
    private int zz4T;
    private int zzXP2;
    private Node zzXlZ;
    private int zzYAy;
    private zzWeq zzYqx;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzHS.zzZlz(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzHS(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzWeq matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzj2 = container;
        this.zz67 = container.getDocument();
        this.zzYqx = matcher;
        this.zzBs = isDeep;
        this.zzZ7m();
    }

    public Node get(int index) {
        try {
            this.zzzk();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzXP2 == index) {
                return this.zzXlZ;
            }
            int n = index - this.zzXP2;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zz42(nodeCollection.zzXlZ, n);
            if (node != null) {
                this.zzXP2 = index;
                this.zzXlZ = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzBs) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzj2.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzBs) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzj2.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzXO5();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzT9(this);
    }

    final <TNode extends Node> zzT9<TNode> zzX4f() {
        return new zzT9(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzXO5() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzod.zzXDP(arrayList, node);
        }
        return arrayList;
    }

    private Node zz42(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzXYh(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzYNR(curNode, true);
    }

    private Node zzYNR(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzWoF = node;
        do {
            node2 = this.zzWoF;
            Node node3 = this.zzBs ? this.zzXDP(true, this.zzWoF) : (this.zzWoF = this.zzYqx.zzXR8() ? this.zzYeh(true, this.zzWoF) : this.zzYMQ(true, this.zzWoF));
        } while (this.zzWoF != null && !this.zzYqx.zz42(this.zzWoF));
        return node2;
    }

    private Node zzXYh(Node node, boolean bl) throws Exception {
        while ((this.zzBs ? this.zzXDP(bl, node) : (node = this.zzYqx.zzXR8() ? this.zzYeh(bl, node) : this.zzYMQ(bl, node))) != null && !this.zzYqx.zz42(node)) {
        }
        return node;
    }

    private Node zzXDP(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzj2);
        }
        return node.previousPreOrder(this.zzj2);
    }

    private Node zzYMQ(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzj2) {
                return this.zzj2.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzj2) {
            return this.zzj2.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzYeh(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzj2 ? this.zzj2.zzYzN() : node.zzYZK();
        } else {
            Node node3 = node2 = node == this.zzj2 ? this.zzj2.zzXz0() : node.zzWL3();
        }
        if (node2 == this.zzj2.getNextSibling() || node2 == this.zzj2.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzzk() {
        if (this.zz4T != this.zzXmz()) {
            this.zzZ7m();
        }
    }

    private void zzZ7m() {
        this.zz4T = this.zzXmz();
        this.zzXP2 = -1;
        this.zzXlZ = this.zzj2;
        this.zzYAy = -1;
    }

    private int zzXmz() {
        if (this.zz67 != null) {
            return this.zz67.zzYzX();
        }
        return 0;
    }

    public int getCount() {
        this.zzzk();
        if (this.zzYAy == -1) {
            this.zzYAy = zzT9.zzXDP(this);
        }
        return this.zzYAy;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzWoF;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzj2;
    }
}

