/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import java.util.HashSet;
import java.util.Set;

public final class WarningType {
    public static final int DATA_LOSS_CATEGORY = 255;
    public static final int DATA_LOSS = 1;
    public static final int MAJOR_FORMATTING_LOSS_CATEGORY = 65280;
    public static final int MAJOR_FORMATTING_LOSS = 256;
    public static final int MINOR_FORMATTING_LOSS_CATEGORY = 0xFF0000;
    public static final int MINOR_FORMATTING_LOSS = 65536;
    public static final int FONT_SUBSTITUTION = 131072;
    public static final int FONT_EMBEDDING = 262144;
    public static final int UNEXPECTED_CONTENT_CATEGORY = 0xF000000;
    public static final int UNEXPECTED_CONTENT = 0x1000000;
    public static final int HINT = 0x10000000;
    public static final int length = 11;

    private WarningType() {
    }

    public static String getName(int warningType) {
        switch (warningType) {
            case 255: {
                return "DATA_LOSS_CATEGORY";
            }
            case 1: {
                return "DATA_LOSS";
            }
            case 65280: {
                return "MAJOR_FORMATTING_LOSS_CATEGORY";
            }
            case 256: {
                return "MAJOR_FORMATTING_LOSS";
            }
            case 0xFF0000: {
                return "MINOR_FORMATTING_LOSS_CATEGORY";
            }
            case 65536: {
                return "MINOR_FORMATTING_LOSS";
            }
            case 131072: {
                return "FONT_SUBSTITUTION";
            }
            case 262144: {
                return "FONT_EMBEDDING";
            }
            case 0xF000000: {
                return "UNEXPECTED_CONTENT_CATEGORY";
            }
            case 0x1000000: {
                return "UNEXPECTED_CONTENT";
            }
            case 0x10000000: {
                return "HINT";
            }
        }
        return "Unknown WarningType value.";
    }

    public static Set<String> getNames(int warningType) {
        HashSet<String> hashSet = new HashSet<String>();
        if ((0xFF & warningType) == 255) {
            hashSet.add("DATA_LOSS_CATEGORY");
        }
        if ((1 & warningType) == 1) {
            hashSet.add("DATA_LOSS");
        }
        if ((0xFF00 & warningType) == 65280) {
            hashSet.add("MAJOR_FORMATTING_LOSS_CATEGORY");
        }
        if ((0x100 & warningType) == 256) {
            hashSet.add("MAJOR_FORMATTING_LOSS");
        }
        if ((0xFF0000 & warningType) == 0xFF0000) {
            hashSet.add("MINOR_FORMATTING_LOSS_CATEGORY");
        }
        if ((0x10000 & warningType) == 65536) {
            hashSet.add("MINOR_FORMATTING_LOSS");
        }
        if ((0x20000 & warningType) == 131072) {
            hashSet.add("FONT_SUBSTITUTION");
        }
        if ((0x40000 & warningType) == 262144) {
            hashSet.add("FONT_EMBEDDING");
        }
        if ((0xF000000 & warningType) == 0xF000000) {
            hashSet.add("UNEXPECTED_CONTENT_CATEGORY");
        }
        if ((0x1000000 & warningType) == 0x1000000) {
            hashSet.add("UNEXPECTED_CONTENT");
        }
        if ((0x10000000 & warningType) == 0x10000000) {
            hashSet.add("HINT");
        }
        return hashSet;
    }

    public static String toString(int warningType) {
        switch (warningType) {
            case 255: {
                return "DataLossCategory";
            }
            case 1: {
                return "DataLoss";
            }
            case 65280: {
                return "MajorFormattingLossCategory";
            }
            case 256: {
                return "MajorFormattingLoss";
            }
            case 0xFF0000: {
                return "MinorFormattingLossCategory";
            }
            case 65536: {
                return "MinorFormattingLoss";
            }
            case 131072: {
                return "FontSubstitution";
            }
            case 262144: {
                return "FontEmbedding";
            }
            case 0xF000000: {
                return "UnexpectedContentCategory";
            }
            case 0x1000000: {
                return "UnexpectedContent";
            }
            case 0x10000000: {
                return "Hint";
            }
        }
        return WarningType.toStringSet(warningType);
    }

    public static String toStringSet(int attr) {
        String string = "";
        String string2 = "";
        for (int n : WarningType.getValues()) {
            if (n == 0 || (n & attr) != n) continue;
            string = string + string2 + WarningType.toString(n);
            string2 = ", ";
        }
        return string;
    }

    public static int fromName(String warningTypeName) {
        if ("DATA_LOSS_CATEGORY".equals(warningTypeName)) {
            return 255;
        }
        if ("DATA_LOSS".equals(warningTypeName)) {
            return 1;
        }
        if ("MAJOR_FORMATTING_LOSS_CATEGORY".equals(warningTypeName)) {
            return 65280;
        }
        if ("MAJOR_FORMATTING_LOSS".equals(warningTypeName)) {
            return 256;
        }
        if ("MINOR_FORMATTING_LOSS_CATEGORY".equals(warningTypeName)) {
            return 0xFF0000;
        }
        if ("MINOR_FORMATTING_LOSS".equals(warningTypeName)) {
            return 65536;
        }
        if ("FONT_SUBSTITUTION".equals(warningTypeName)) {
            return 131072;
        }
        if ("FONT_EMBEDDING".equals(warningTypeName)) {
            return 262144;
        }
        if ("UNEXPECTED_CONTENT_CATEGORY".equals(warningTypeName)) {
            return 0xF000000;
        }
        if ("UNEXPECTED_CONTENT".equals(warningTypeName)) {
            return 0x1000000;
        }
        if ("HINT".equals(warningTypeName)) {
            return 0x10000000;
        }
        throw new IllegalArgumentException("Unknown WarningType name.");
    }

    public static int fromNames(Set<String> warningTypeNames) {
        int n = 0;
        for (String string : warningTypeNames) {
            n |= WarningType.fromName(string);
        }
        return n;
    }

    public static int[] getValues() {
        return new int[]{255, 1, 65280, 256, 0xFF0000, 65536, 131072, 262144, 0xF000000, 0x1000000, 0x10000000};
    }
}

