/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXgH;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzZjs = new ArrayList();
    private final Map<String, DataColumn> zzXlg = new HashMap<String, DataColumn>();
    private DataTable zzYAN;

    DataColumnCollection(DataTable table) {
        this.zzYAN = table;
    }

    public void add(DataColumn column) {
        if (zzXgH.zzZpu(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzWv(column.getColumnName());
        if (this.zzXlg.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzWOR(this.zzYAN);
        column.setOrdinal(this.zzZjs.size());
        this.zzZjs.add(column);
        this.zzXlg.put(string, column);
        this.zzYAN.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzYAN);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzYAN);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzXgH.zzZpu(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzWv(columnName);
        DataColumn dataColumn = this.zzXlg.get(string);
        if (dataColumn != null) {
            int n = this.zzZjs.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzZjs.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzZjs.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzZjs.remove(n);
            this.zzXlg.remove(DataColumnCollection.zzWv(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzYAN.getRows()) {
                dataRow.remove(n);
            }
            this.zzYAN.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzZjs.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzZjs.iterator();
    }

    public void clear() {
        this.zzXlg.clear();
        this.zzZjs.clear();
    }

    final DataColumn[] zzZg2() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzZjs);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzXDP(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzZjs.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzZjs.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzWv(string);
            String string3 = DataColumnCollection.zzWv(dataColumn.getColumnName());
            this.zzXlg.remove(string3);
            this.zzXlg.put(string2, dataColumn);
            return;
        }
    }

    private static String zzWv(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

