/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.config;

import com.huawei.security.validator.bean.BasicParamConfigBean;
import com.huawei.security.validator.bean.CommonConfigsBean;
import com.huawei.security.validator.bean.ParameterConfigBean;
import com.huawei.security.validator.bean.ParameterConfigSet;
import com.huawei.security.validator.bean.RootParamValidatorsBean;
import com.huawei.security.validator.bean.ValidateRuleBean;
import com.huawei.security.validator.bean.ValidatorBean;
import com.huawei.security.validator.config.FileCache;
import com.huawei.security.validator.config.FileUtil;
import com.huawei.security.validator.config.LoadCommonIncludeFile;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.requestmapping.RequestMappingInfo;
import com.huawei.security.validator.requestmapping.RequestSpecificMappingInfo;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.RegExpExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;

public abstract class AbstractRuleFileLoad {
    private static final String DEFAULT_PARAM_CONFIG_SET_NAME = "";
    private static final int COMMON_VALIDATORS_MAP_SIZE = 32;
    private static final int VALIDATOR_ATTRIBUTE_MAP_SIZE = 8;
    private static final int MAX_JSON_NESTING_LEVEL = 10;
    private static final int MIN_STATE_CODE = 100;
    private static final int MAX_STATE_CODE = 600;
    private static final int SYMBOLS_INDEX_NOT_EXIST = -1;
    private static final String FALSE_STR = "false";
    private static final String TRUE_STR = "true";
    private static final int LEVEL_UPPER_LIMIT = 10000;
    private static final Logger LOG = WSFValidatorLog.getLogger();
    String path;
    Map<RequestSpecificMappingInfo, ValidateRuleBean> validateParamMap;
    Map<String, Set<String>> validateRuleSizeMap;
    private final CommonConfigsBean commonConfigBean = FileCache.getInstance().getCommonConfigsBean();

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public abstract void loadConfigFile() throws ValidateException;

    public Map<RequestSpecificMappingInfo, ValidateRuleBean> getValidateMap() {
        return this.validateParamMap;
    }

    public Map<String, Set<String>> getValidateRuleSizeMap() {
        return this.validateRuleSizeMap;
    }

    boolean checkFilePrefixAndSuffix(String filePath) {
        String fileName = this.getFileName(filePath);
        return fileName.startsWith("validate-rule") && fileName.endsWith(".xml");
    }

    boolean checkTemplatePrefixAndSuffix(String filePath) {
        String fileName = this.getFileName(filePath);
        return fileName.startsWith("validate-template") && fileName.endsWith(".xml");
    }

    boolean checkValidatorsPrefixAndSuffix(String filePath) {
        String fileName = this.getFileName(filePath);
        return fileName.startsWith("validate-validator") && fileName.endsWith(".xml");
    }

    private String getFileName(String filePath) {
        String fileName = DEFAULT_PARAM_CONFIG_SET_NAME;
        if (filePath.lastIndexOf(47) != -1) {
            fileName = filePath.substring(filePath.lastIndexOf(47) + 1);
            return fileName;
        }
        if (filePath.lastIndexOf(92) != -1) {
            fileName = filePath.substring(filePath.lastIndexOf(92) + 1);
        }
        return fileName;
    }

    private ValidateRuleBean initValidateBean(Element validateNote) throws ValidateException {
        ValidateRuleBean validateBean = new ValidateRuleBean();
        String url = validateNote.attributeValue("url").trim();
        LOG.info("[WSF-ParamValidate] Begin load config from: {}.", (Object)LogUtils.cleanLog(url));
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        validateBean.setUrl(url);
        validateBean.setFailPath(validateNote.attributeValue("failpath"));
        validateBean.setAllParameterCheck(validateNote.attributeValue("allParameterCheck"));
        validateBean.setErrorHandler(validateNote.attributeValue("errorHandler"));
        String dataPattern = validateNote.attributeValue("dataPattern");
        if ("json".equalsIgnoreCase(dataPattern)) {
            dataPattern = "json";
        } else if ("xml".equalsIgnoreCase(dataPattern)) {
            dataPattern = "xml";
        } else if ("form".equalsIgnoreCase(dataPattern)) {
            dataPattern = "form";
        } else if ("xml_conversion_form".equalsIgnoreCase(dataPattern)) {
            dataPattern = "xml_conversion_form";
            validateBean.setConversionDataPattern("xml");
        } else if ("json_conversion_form".equalsIgnoreCase(dataPattern)) {
            dataPattern = "json_conversion_form";
            validateBean.setConversionDataPattern("json");
        } else {
            LOG.error("[WSF-ParamValidate] The param_validator node, url config:{}, dataPattern config is {}.", (Object)validateNote.attributeValue("url"), (Object)LogUtils.cleanLog(dataPattern));
            throw new ValidateException("The param_validator dataPattern config error.");
        }
        validateBean.setDataPattern(dataPattern);
        validateBean.setValidatorSetHandler(validateNote.attributeValue("validatorSetHandler"));
        this.addMaxObjSize(validateNote, validateBean);
        return validateBean;
    }

    private void addMaxObjSize(Element validateNote, ValidateRuleBean validateBean) throws ValidateException {
        String maxObjSize = validateNote.attributeValue("maxObjSize");
        try {
            if (!EmptyUtils.isEmpty(maxObjSize)) {
                int size = Integer.parseInt(maxObjSize);
                if (size >= 0) {
                    validateBean.setMaxObjSize(size);
                } else {
                    validateBean.setMaxObjSize(Integer.MIN_VALUE);
                }
            } else {
                validateBean.setMaxObjSize(Integer.MIN_VALUE);
            }
        }
        catch (NumberFormatException ex) {
            LOG.error("[WSF-ParamValidate] The param_validator node, url config:{}, maxObjSize config is {}.", (Object)validateNote.attributeValue("url"), (Object)LogUtils.cleanLog(maxObjSize));
            throw new ValidateException("The param_validator maxObjSize config error.", ex);
        }
    }

    void addParamValidators(Element rootParam) throws ValidateException {
        Iterator validateListNodes = rootParam.elementIterator("param_validator");
        while (validateListNodes.hasNext()) {
            Element validateNode = (Element)validateListNodes.next();
            String method = validateNode.attributeValue("method");
            if (EmptyUtils.isEmpty(method)) {
                throw new ValidateException("The configuration validate rule method is null.");
            }
            ValidateRuleBean validateBean = this.initValidateBean(validateNode);
            String dataPattern = validateBean.getDataPattern();
            String publicValidatorRef = validateNode.attributeValue("publicvalidator");
            List<ValidatorBean> publicValidatorList = this.getPublicValidators(publicValidatorRef);
            ParameterConfigSet paramConfigSet = new ParameterConfigSet(DEFAULT_PARAM_CONFIG_SET_NAME);
            this.parseParamValidatorSet(publicValidatorList, validateNode, validateBean, paramConfigSet, dataPattern);
            Iterator paramSetList = validateNode.elementIterator("parameter_validator_set");
            this.addParamValidator(validateBean, dataPattern, publicValidatorList, paramConfigSet, paramSetList);
            String[] urlPattern = new String[]{validateBean.getUrl()};
            RequestSpecificMappingInfo mappingInfo = new RequestSpecificMappingInfo(urlPattern, method.split("\\|"), dataPattern);
            this.checkUrlAndMethod(mappingInfo);
            this.validateParamMap.put(mappingInfo, validateBean);
            if (this.validateRuleSizeMap.containsKey(validateBean.getUrl())) {
                if (this.isSpecialDataPattern(dataPattern)) continue;
                this.validateRuleSizeMap.get(validateBean.getUrl()).add(dataPattern);
                continue;
            }
            HashSet<String> dataPatterns = new HashSet<String>();
            if (!this.isSpecialDataPattern(dataPattern)) {
                dataPatterns.add(dataPattern);
            }
            this.validateRuleSizeMap.put(validateBean.getUrl(), dataPatterns);
        }
    }

    private void addParamValidator(ValidateRuleBean validateBean, String dataPattern, List<ValidatorBean> publicValidatorList, ParameterConfigSet paramConfigSet, Iterator<Element> paramSetList) throws ValidateException {
        if (!paramSetList.hasNext()) {
            LOG.debug("[WSF-ParamValidate] No parameter_validator_set config.");
            validateBean.addParameterSet(null, paramConfigSet);
        } else {
            while (paramSetList.hasNext()) {
                Element paramSetNode = paramSetList.next();
                String paramSetNodeName = paramSetNode.attributeValue("name");
                ParameterConfigSet childParamConfigSet = new ParameterConfigSet(paramSetNodeName, paramConfigSet);
                this.parseParamValidatorSet(publicValidatorList, paramSetNode, validateBean, childParamConfigSet, dataPattern);
                if (validateBean.hasParameterSet(paramSetNodeName) && this.commonConfigBean.isCheckUserConfig()) {
                    throw new ValidateException("URL: " + LogUtils.cleanLog(validateBean.getUrl()) + " configured parameterSet with the same name: " + LogUtils.cleanLog(paramSetNodeName));
                }
                validateBean.addParameterSet(paramSetNodeName, childParamConfigSet);
            }
        }
    }

    private boolean isSpecialDataPattern(String dataPattern) {
        return "json_conversion_form".equalsIgnoreCase(dataPattern) || "xml_conversion_form".equalsIgnoreCase(dataPattern);
    }

    private void parseParamValidatorSet(List<ValidatorBean> publicValidatorList, Element paramSetNode, ValidateRuleBean validateBean, ParameterConfigSet paramConfigSet, String dataPattern) throws ValidateException {
        List<Element> paramList = this.getParamList(paramSetNode);
        this.parseParamNodes(paramList, publicValidatorList, paramConfigSet, validateBean);
        this.loadWildCardElement(paramSetNode, paramConfigSet, publicValidatorList, validateBean);
        this.checkQueryString(dataPattern, paramConfigSet.getQueryStringParamList());
    }

    private List<Element> getParamList(Element paramValidator) throws ValidateException {
        List parameterTemplate = paramValidator.elements("parameter_template");
        List parameterList = paramValidator.elements("parameter");
        if (EmptyUtils.isEmpty(parameterTemplate)) {
            return parameterList;
        }
        ArrayList<Element> resultList = new ArrayList<Element>(10);
        if (!EmptyUtils.isEmpty(parameterList)) {
            resultList.addAll(parameterList);
        }
        for (Element templateObj : parameterTemplate) {
            String templateName = templateObj.attributeValue("name");
            if (EmptyUtils.isEmpty(templateName)) {
                throw new ValidateException("The template name cannot be empty.");
            }
            List<Element> templateParamList = FileCache.getInstance().getParameterListByName(templateName);
            if (EmptyUtils.isEmpty(templateParamList)) {
                LOG.error("[WSF-ParamValidate] Have not found the template:{}", (Object)LogUtils.cleanLog(templateName));
                throw new ValidateException("Have not found the template");
            }
            String namePrefix = templateObj.attributeValue("parameterNamePrefix");
            this.resultList(resultList, templateParamList, namePrefix);
        }
        return resultList;
    }

    private void resultList(List<Element> resultList, List<Element> templateParamList, String namePrefix) throws ValidateException {
        if (EmptyUtils.hasText(namePrefix)) {
            for (Element paramEle : templateParamList) {
                String name = paramEle.attributeValue("name");
                Element eleTmp = null;
                if (!(paramEle.clone() instanceof Element)) {
                    throw new ValidateException("Can't add template parameter.");
                }
                eleTmp = (Element)paramEle.clone();
                eleTmp.addAttribute("name", namePrefix + name);
                resultList.add(eleTmp);
            }
        } else {
            resultList.addAll(templateParamList);
        }
    }

    private void parseParamNodes(List<Element> paramList, List<ValidatorBean> publicValidatorList, ParameterConfigSet paramConfigSet, ValidateRuleBean validateBean) throws ValidateException {
        List<BasicParamConfigBean> queryStringParamList = paramConfigSet.getQueryStringParamList();
        for (Element paramNode : paramList) {
            ParameterConfigBean parameterObject = this.getParameterFromNodes(paramNode, publicValidatorList);
            String dataSource = paramNode.attributeValue("source");
            if (dataSource != null && this.isEqualIgnoreCase(dataSource.trim(), "qs")) {
                this.checkSameParameterName(queryStringParamList, parameterObject);
                queryStringParamList.add(parameterObject);
                continue;
            }
            if (EmptyUtils.hasText(dataSource)) {
                LOG.error("[WSF-ParamValidate] DataSource config is error, the content is {}.", (Object)LogUtils.cleanLog(dataSource));
                throw new ValidateException("DataSource config is error");
            }
            List<BasicParamConfigBean> noteParamList = paramConfigSet.getNoteParamList();
            this.checkSameParameterName(noteParamList, parameterObject);
            this.handlerParameterName(paramConfigSet, validateBean, paramNode, parameterObject, noteParamList);
        }
    }

    private void handlerParameterName(ParameterConfigSet paramConfigSet, ValidateRuleBean validateBean, Element paramNode, ParameterConfigBean parameterObject, List<BasicParamConfigBean> noteParamList) throws ValidateException {
        String name = paramNode.attributeValue("name");
        if (name.startsWith("{") && name.endsWith("}")) {
            LOG.debug("[WSF-ParamValidate] Add url path parameter, name is {}.", (Object)LogUtils.cleanLog(name));
            String temName = name.substring(1, name.length() - 1);
            boolean validateResult = RegExpExecutor.validate("[%/\\\"\\.\\\\#\\?;:\\$\\+@&=\\|\\^\\[\\]~<>`'\\*,]", false, temName, true);
            if (validateResult) {
                LOG.error("[WSF-ParamValidate] Config url path parameter name contain reserved characters. Please modify parameter name.");
                throw new ValidateException("Config url path parameter name contain reserved characters.Please modify parameter name.");
            }
            List<BasicParamConfigBean> urlPathParamList = paramConfigSet.getUrlPathParamList();
            this.checkSameParameterName(urlPathParamList, parameterObject);
            urlPathParamList.add(parameterObject);
        } else if ("DOCTYPE-ENTITY-VALIDATE".equals(name)) {
            paramConfigSet.getXmlEntityParamList().add(parameterObject);
        } else {
            noteParamList.add(parameterObject);
            if (parameterObject.isRequired()) {
                validateBean.setNeedCheckBody(true);
            }
        }
    }

    private void loadWildCardElement(Element parentElement, ParameterConfigSet paramConfigSet, List<ValidatorBean> publicValidatorList, ValidateRuleBean validateBean) throws ValidateException {
        List wildcardElementList = parentElement.elements("wildcard");
        if (EmptyUtils.isEmpty(wildcardElementList)) {
            return;
        }
        if (wildcardElementList.size() > 1) {
            throw new ValidateException("Wildcard node can't config multiple.");
        }
        LOG.info("[WSF-ParamValidate] Config wildcard node.");
        List<Element> parameterList = this.getParamList((Element)wildcardElementList.get(0));
        List<BasicParamConfigBean> wildcardParameterList = paramConfigSet.getWildcardParamList();
        for (Element paramNode : parameterList) {
            ParameterConfigBean parameterObject = new ParameterConfigBean();
            this.parseCommonParam(paramNode, parameterObject);
            List<ValidatorBean> validatorList = this.loadValidators(paramNode);
            validatorList.addAll(publicValidatorList);
            parameterObject.setValidatorList(validatorList);
            this.checkSameParameterName(wildcardParameterList, parameterObject);
            wildcardParameterList.add(parameterObject);
            if (!parameterObject.isRequired()) continue;
            validateBean.setNeedCheckBody(true);
        }
    }

    private ParameterConfigBean getParameterFromNodes(Element paramNode, List<ValidatorBean> publicValidatorList) throws ValidateException {
        ParameterConfigBean parameterObject = new ParameterConfigBean();
        this.parseCommonParam(paramNode, parameterObject);
        String paramDataPattern = paramNode.attributeValue("dataPattern");
        if (EmptyUtils.hasText(paramDataPattern)) {
            String dataPattern = paramDataPattern.trim();
            parameterObject.setDataPattern(dataPattern);
            if ("json".equalsIgnoreCase(dataPattern) || "xml".equalsIgnoreCase(dataPattern)) {
                this.processDataPattern(paramNode, publicValidatorList, parameterObject);
            }
        } else {
            List<ValidatorBean> validatorList = this.loadValidators(paramNode);
            validatorList.addAll(publicValidatorList);
            parameterObject.setValidatorList(validatorList);
        }
        return parameterObject;
    }

    private void parseCommonParam(Element paramNode, ParameterConfigBean parameterObject) throws ValidateException {
        boolean isUrlParam;
        String name = paramNode.attributeValue("name");
        if (name == null) {
            LOG.error("[WSF-ParamValidate] Parameter name is not config.");
            throw new ValidateException("Parameter name is not config.");
        }
        parameterObject.setName(name.trim());
        String required = paramNode.attributeValue("required");
        if (required != null && this.isEqualIgnoreCase(FALSE_STR, required.trim())) {
            parameterObject.setRequired(false);
        } else {
            parameterObject.setRequired(true);
        }
        String decode = paramNode.attributeValue("decode");
        if (EmptyUtils.hasText(decode)) {
            parameterObject.setDecode(decode.trim());
        }
        this.addErrorHandlerConfig(paramNode, parameterObject, name);
        this.addMaxArraySize(paramNode, parameterObject);
        this.addJsonValidateSpecialConfig(paramNode, parameterObject);
        String parmaName = name.trim();
        boolean bl = isUrlParam = parmaName.startsWith("{") && parmaName.endsWith("}");
        if (isUrlParam) {
            this.addUrlParamSpecialConfig(paramNode, parameterObject);
        }
    }

    private void addErrorHandlerConfig(Element paramNode, ParameterConfigBean parameterObject, String name) {
        String errorKey = paramNode.attributeValue("errorKey");
        if (EmptyUtils.hasText(errorKey)) {
            parameterObject.setErrorKey(errorKey.trim());
        } else {
            parameterObject.setErrorKey(name.trim());
        }
        String errorMessage = paramNode.attributeValue("errorMessage");
        if (EmptyUtils.hasText(errorMessage)) {
            parameterObject.setErrorMessage(errorMessage.trim());
        }
    }

    private void addJsonValidateSpecialConfig(Element paramNode, ParameterConfigBean parameterObject) throws ValidateException {
        String listObjectCheck;
        String level = paramNode.attributeValue("level");
        if (EmptyUtils.hasText(level)) {
            if (!this.isLegalLevel(level.trim())) {
                LOG.error("[WSF-ParamValidate] Level config may be illegal,the value is {}.", (Object)LogUtils.cleanLog(level.trim()));
                throw new ValidateException("Level config may be illegal.");
            }
            parameterObject.setLevel(level.trim());
        }
        if ((listObjectCheck = paramNode.attributeValue("listObjectCheck")) != null && this.isEqualIgnoreCase(TRUE_STR, listObjectCheck.trim())) {
            parameterObject.setListObjectCheck(true);
        }
    }

    private void addUrlParamSpecialConfig(Element paramNode, ParameterConfigBean parameterObject) {
        String urlParamDecode = paramNode.attributeValue("urlParmaDecode");
        String charset = paramNode.attributeValue("charSet");
        boolean needDecodeUrlParam = urlParamDecode != null && this.isEqualIgnoreCase(TRUE_STR, urlParamDecode.trim());
        parameterObject.setUrlParamDecode(needDecodeUrlParam);
        if (EmptyUtils.hasText(charset)) {
            parameterObject.setCharSet(charset.trim());
        }
    }

    private boolean isLegalLevel(String levelStr) {
        int levelNum;
        try {
            levelNum = Integer.parseInt(levelStr);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return levelNum >= 0 && levelNum <= 10000;
    }

    private boolean isEqualIgnoreCase(String first, String another) {
        return first.equalsIgnoreCase(another);
    }

    private void processDataPattern(Element paramNode, List<ValidatorBean> publicValidatorList, ParameterConfigBean parameterObject) throws ValidateException {
        ArrayList<BasicParamConfigBean> childParamList = new ArrayList<BasicParamConfigBean>(10);
        ArrayList<BasicParamConfigBean> xmlEntityChildParamList = new ArrayList<BasicParamConfigBean>(10);
        List elementList = paramNode.elements("child_parameter");
        String errorMessage = paramNode.attributeValue("errorMessage");
        for (Element childParam : elementList) {
            BasicParamConfigBean childParamConfig = new BasicParamConfigBean();
            String childParamName = childParam.attributeValue("name");
            childParamConfig.setName(childParamName.trim());
            this.addErrorHandlerConfig(errorMessage, childParam, childParamConfig, childParamName);
            this.addMaxArraySize(childParam, childParamConfig);
            String childIsRequired = childParam.attributeValue("required");
            if (EmptyUtils.isEmpty(childIsRequired)) {
                childParamConfig.setRequired(parameterObject.isRequired());
            } else {
                childParamConfig.setRequired(!this.isEqualIgnoreCase(FALSE_STR, childIsRequired.trim()));
            }
            this.initChildLevelAndListCheckParam(parameterObject, childParam, childParamConfig);
            List<ValidatorBean> validatorList = this.loadValidators(childParam);
            validatorList.addAll(publicValidatorList);
            childParamConfig.setValidatorList(validatorList);
            this.checkSameParameterName(childParamList, childParamConfig);
            if ("DOCTYPE-ENTITY-VALIDATE".equals(childParamName)) {
                xmlEntityChildParamList.add(childParamConfig);
                continue;
            }
            childParamList.add(childParamConfig);
        }
        parameterObject.setChildParamList(childParamList);
        parameterObject.setXmlEntityParamList(xmlEntityChildParamList);
    }

    private void addErrorHandlerConfig(String errorMessage, Element childParam, BasicParamConfigBean childParamConfig, String childParamName) {
        String childParamErrorKey = childParam.attributeValue("errorKey");
        if (EmptyUtils.hasText(childParamErrorKey)) {
            childParamConfig.setErrorKey(childParamErrorKey.trim());
        } else {
            childParamConfig.setErrorKey(childParamName.trim());
        }
        String childParamErrorMessage = childParam.attributeValue("errorMessage");
        if (EmptyUtils.hasText(childParamErrorMessage)) {
            childParamConfig.setErrorMessage(childParamErrorMessage);
        } else {
            childParamConfig.setErrorMessage(errorMessage == null ? DEFAULT_PARAM_CONFIG_SET_NAME : errorMessage.trim());
        }
    }

    private void initChildLevelAndListCheckParam(ParameterConfigBean parameterObject, Element childParam, BasicParamConfigBean childParamConfig) throws ValidateException {
        String childListObjectCheck;
        String childLevel = childParam.attributeValue("level");
        if (EmptyUtils.hasText(childLevel)) {
            if (!this.isLegalLevel(childLevel.trim())) {
                LOG.error("[WSF-ParamValidate] Child level config may be illegal,the value is {}.", (Object)LogUtils.cleanLog(childLevel.trim()));
                throw new ValidateException("Child level config may be illegal.");
            }
            childParamConfig.setLevel(childLevel.trim());
        }
        if (EmptyUtils.isEmpty(childListObjectCheck = childParam.attributeValue("listObjectCheck"))) {
            childParamConfig.setListObjectCheck(parameterObject.isListObjectCheck());
        } else {
            childParamConfig.setListObjectCheck(this.isEqualIgnoreCase(TRUE_STR, childListObjectCheck.trim()));
        }
    }

    private void checkSameParameterName(List<BasicParamConfigBean> noteParamList, BasicParamConfigBean parameterObject) throws ValidateException {
        for (BasicParamConfigBean paramConfig : noteParamList) {
            if (!paramConfig.getName().equals(parameterObject.getName())) continue;
            String message = "Config parameter exist same name, please modify. Parameter name is " + paramConfig.getName();
            LOG.error("[WSF-ParamValidate] {}.", (Object)LogUtils.cleanLog(message));
            throw new ValidateException(LogUtils.cleanLog(message));
        }
    }

    void parseCommonConfigXml(Document document, String validatorRuleFilePath) {
        LOG.info("[WSF-ParamValidate] Begin parse validate-common-conf.xml file.");
        Element rootParam = document.getRootElement();
        RootParamValidatorsBean rootParamBean = FileCache.getInstance().getRootParamBean();
        this.addUrlCheckNote(rootParam, rootParamBean);
        Iterator validatorsList = rootParam.elementIterator("validators");
        HashMap<String, List<ValidatorBean>> commonValidatorsMap = new HashMap<String, List<ValidatorBean>>(32);
        while (validatorsList.hasNext()) {
            Element validators = (Element)validatorsList.next();
            String alias = validators.attributeValue("alias");
            List<ValidatorBean> validatorList = this.loadValidators(validators);
            commonValidatorsMap.put(alias, validatorList);
        }
        commonValidatorsMap.putAll(FileCache.getInstance().getValidatorTemplates());
        this.commonConfigBean.setCommonValidatorsMap(commonValidatorsMap);
        try {
            FileUtil.addExcludedParameterCheckNote(rootParam, this.commonConfigBean);
        }
        catch (ValidateException e) {
            LOG.error("[WSF-ParamValidate] Parse validate-common-conf.xml occur exception. {}", (Object)e.getMessage());
        }
        Element serverNameOnElement = rootParam.element("ignore-appname");
        if (serverNameOnElement != null) {
            String value = serverNameOnElement.attributeValue("disabled");
            this.commonConfigBean.setAddAppName(TRUE_STR.equalsIgnoreCase(value));
        }
        this.addIncludeFileConfig(rootParam, validatorRuleFilePath, rootParamBean);
        FileCache.getInstance().setRootParamBean(rootParamBean);
        this.addXmlEntitySetValue(rootParam);
        this.addJsonNestingLevelConfig(rootParam);
        this.addInputStreamMaxSizeConfig(rootParam);
        this.addInterceptOnFailedConfig(rootParam);
        this.addCheckUrlAndMethod(rootParam);
        this.addAllowEmptyValue(rootParam);
        this.addFormBodyCheck(rootParam);
        this.addDuplicateKeyCheck(rootParam);
        this.addParseEmptyMapArrayValue(rootParam);
        this.addLimitArraySizeConfig(rootParam);
        this.addI18nConfig(rootParam);
        this.addJsonParserType(rootParam);
        this.addJsonParserClassPath(rootParam);
        this.addJsonPreCheck(rootParam);
        FileCache.getInstance().setCommonConfigsBean(this.commonConfigBean);
        LOG.info("[WSF-ParamValidate] End parse validate-common-conf.xml file.");
    }

    private void addJsonPreCheck(Element rootParam) {
        String enableValue = this.getAttributeValue(rootParam, "json-pre-check", "enable");
        if (this.isEqualIgnoreCase(TRUE_STR, enableValue)) {
            this.commonConfigBean.setJsonPreCheck(true);
        }
        String sizeValue = this.getAttributeValue(rootParam, "json-pre-check", "maxObjSize");
        try {
            int size = Integer.parseInt(sizeValue);
            if (size >= 0) {
                this.commonConfigBean.setJsonObjMaxSize(size);
            } else {
                LOG.error("[WSF-ParamValidate] Config maxObjSize is not correct, The default is 30000.");
            }
        }
        catch (NumberFormatException ex) {
            if (EmptyUtils.hasText(sizeValue)) {
                LOG.error("[WSF-ParamValidate] Config maxObjSize is not correct, The default is 30000.");
            }
            LOG.info("[WSF-ParamValidate] The maxObjSize not config, The default is 30000.");
        }
        String jsonPreCheckPath = this.getAttributeValue(rootParam, "json-pre-check", "classpath");
        this.commonConfigBean.setJsonPreCheckPath(jsonPreCheckPath);
        this.addMinJsonCheckLength(rootParam);
    }

    private void addMinJsonCheckLength(Element rootParam) {
        String minJsonCheckLength = this.getAttributeValue(rootParam, "json-pre-check", "minJsonCheckLength");
        try {
            long length = Long.parseLong(minJsonCheckLength);
            if (length >= 0L) {
                this.commonConfigBean.setMinJsonCheckLength(length);
            } else {
                LOG.error("[WSF-ParamValidate] Config minJsonCheckLength is not correct, The default is 51200.");
            }
        }
        catch (NumberFormatException ex) {
            if (EmptyUtils.hasText(minJsonCheckLength)) {
                LOG.error("[WSF-ParamValidate] Config minJsonCheckLength is not correct, The default is 51200.");
            }
            LOG.info("[WSF-ParamValidate] The minJsonCheckLength not config, The default is 51200.");
        }
    }

    private void addJsonNestingLevelConfig(Element rootParam) {
        String value = this.getAttributeValue(rootParam, "nesting-level", "maxlevel");
        try {
            int valueInt = Integer.parseInt(value);
            if (valueInt <= 0) {
                LOG.error("[WSF-ParamValidate] Json nesting level config error. The default value is 5.");
            } else if (valueInt > 10) {
                LOG.error("[WSF-ParamValidate] Json nesting level can't larger than 10 levels. Set the value is 10.");
                this.commonConfigBean.setJsonKeyMaxNesting(10);
            } else {
                this.commonConfigBean.setJsonKeyMaxNesting(valueInt);
            }
        }
        catch (NumberFormatException ex) {
            if (EmptyUtils.hasText(value)) {
                LOG.error("[WSF-ParamValidate] Json nesting level config error. The default value is 5.");
            }
            LOG.info("[WSF-ParamValidate] Json nesting level not config. The default value is 5.");
        }
    }

    private void addInputStreamMaxSizeConfig(Element rootParam) {
        String value = this.getAttributeValue(rootParam, "inputstream", "maxsize");
        try {
            long longValue = Long.parseLong(value);
            if (longValue >= 0L) {
                this.commonConfigBean.setInputStreamMaxSize(longValue);
            } else {
                LOG.error("[WSF-ParamValidate] Config inputStream maxsize is not correct, The default is 102400 byte.");
            }
        }
        catch (NumberFormatException ex) {
            if (EmptyUtils.hasText(value)) {
                LOG.error("[WSF-ParamValidate] Config inputStream maxsize is not correct, The default is 102400 byte.");
            }
            LOG.info("[WSF-ParamValidate] The inputStream maxsize not config, The default is 102400 byte.");
        }
    }

    private void addInterceptOnFailedConfig(Element rootParam) {
        String value = this.getAttributeValue(rootParam, "intercept-on-failed", "enable");
        if (this.isEqualIgnoreCase(FALSE_STR, value)) {
            this.commonConfigBean.setInterceptOnFailed(false);
        }
    }

    private void addCheckUrlAndMethod(Element rootParam) {
        String value = this.getAttributeValue(rootParam, "check-config-file", "disabled");
        if (TRUE_STR.equalsIgnoreCase(value)) {
            this.commonConfigBean.setCheckUserConfig(false);
        }
    }

    private void addAllowEmptyValue(Element rootParam) {
        String value = this.getAttributeValue(rootParam, "allow-empty-value", "enable");
        if (this.isEqualIgnoreCase(FALSE_STR, value)) {
            this.commonConfigBean.setAllowEmptyValue(false);
        }
    }

    private void addFormBodyCheck(Element rootParam) {
        String value = this.getAttributeValue(rootParam, "form-body-check", "enable");
        if (this.isEqualIgnoreCase(TRUE_STR, value)) {
            this.commonConfigBean.setFormBodyCheck(true);
        }
    }

    private void addDuplicateKeyCheck(Element rootParam) {
        String value = this.getAttributeValue(rootParam, "allow-duplicate-key", "enable");
        if (this.isEqualIgnoreCase(FALSE_STR, value)) {
            this.commonConfigBean.setAllowDuplicateKey(false);
        }
    }

    private void addParseEmptyMapArrayValue(Element rootParam) {
        String value = this.getAttributeValue(rootParam, "parse-empty-map-array", "enable");
        if (this.isEqualIgnoreCase(FALSE_STR, value)) {
            this.commonConfigBean.setParseEmptyMapArray(false);
        }
    }

    private void addXmlEntitySetValue(Element rootParam) {
        this.commonConfigBean.setXmlEntity("reject");
        String value = this.getAttributeValue(rootParam, "xml-entity", "value");
        if ("permit".equals(value)) {
            this.commonConfigBean.setXmlEntity(value);
        }
    }

    private void addLimitArraySizeConfig(Element rootParam) {
        String enableValue = this.getAttributeValue(rootParam, "limit-array-size", "enable");
        if (this.isEqualIgnoreCase(FALSE_STR, enableValue)) {
            this.commonConfigBean.setLimitArraySize(false);
        }
        String sizeValue = this.getAttributeValue(rootParam, "limit-array-size", "maxArraySize");
        try {
            int size = Integer.parseInt(sizeValue);
            if (size >= 0) {
                this.commonConfigBean.setMaxArraySize(size);
            } else {
                LOG.error("[WSF-ParamValidate] Config maxArraySize is not correct, The default is 50.");
            }
        }
        catch (NumberFormatException ex) {
            if (EmptyUtils.hasText(sizeValue)) {
                LOG.error("[WSF-ParamValidate] Config maxArraySize is not correct, The default is 50.");
            }
            LOG.info("[WSF-ParamValidate] The maxArraySize not config, The default is 50.");
        }
    }

    private void addI18nConfig(Element rootParam) {
        String value = this.getAttributeValue(rootParam, "i18n", "baseName");
        if (!value.isEmpty()) {
            this.commonConfigBean.setI18nBaseName(value);
        }
    }

    private void addJsonParserType(Element rootParam) {
        String value = this.getAttributeValue(rootParam, "json-parser", "type");
        if (!value.isEmpty()) {
            this.commonConfigBean.setJsonParserType(value);
        }
    }

    private void addJsonParserClassPath(Element rootParam) {
        String value = this.getAttributeValue(rootParam, "json-parser", "classpath");
        if (!value.isEmpty()) {
            this.commonConfigBean.setClassPath(value);
        }
    }

    private String getAttributeValue(Element rootElement, String elementName, String attributeName) {
        return Optional.ofNullable(rootElement).map(parent -> parent.element(elementName)).map(element -> element.attribute(attributeName)).map(attribute -> attribute.getValue()).map(attributeValue -> attributeValue.trim()).orElse(DEFAULT_PARAM_CONFIG_SET_NAME);
    }

    private void addMaxArraySize(Element paramNode, BasicParamConfigBean parameterObject) throws ValidateException {
        String maxArraySize = paramNode.attributeValue("maxArraySize");
        if (EmptyUtils.hasText(maxArraySize)) {
            try {
                int maxArraySizeInt = Integer.parseInt(maxArraySize);
                if (maxArraySizeInt < 0) {
                    LOG.error("[WSF-ParamValidate] MaxArraySize config error, the value is {}.", (Object)LogUtils.cleanLog(maxArraySize));
                    throw new ValidateException("Parsing maxArraySize occur exception.");
                }
                parameterObject.setMaxArraySize(maxArraySizeInt);
            }
            catch (NumberFormatException ex) {
                LOG.error("[WSF-ParamValidate] MaxArraySize config error, the value is {}.", (Object)LogUtils.cleanLog(maxArraySize));
                throw new ValidateException("Parsing maxArraySize occur exception.");
            }
        } else {
            parameterObject.setMaxArraySize(this.commonConfigBean.getMaxArraySize());
        }
    }

    private void addIncludeFileConfig(Element rootParam, String validatorRuleFilePath, RootParamValidatorsBean rootParamBean) {
        CommonConfigsBean configBean;
        LoadCommonIncludeFile includeFile = this.getIncludeFile(rootParam, validatorRuleFilePath);
        if (includeFile == null) {
            return;
        }
        if (includeFile.getRootParamValidatorBean() != null) {
            List<String> includeUrlList = includeFile.getRootParamValidatorBean().getExcludeUrlPattern();
            rootParamBean.getExcludeUrlPattern().addAll(includeUrlList);
        }
        if ((configBean = includeFile.getCommonConfigBean()) == null) {
            return;
        }
        this.commonConfigBean.getExcludeParam().addAll(configBean.getExcludeParam());
        this.commonConfigBean.getExcludeUrlPathParam().addAll(configBean.getExcludeUrlPathParam());
        Set<String> includePublicXmlParamSet = configBean.getPublicXmlParam();
        this.commonConfigBean.getPublicXmlParam().addAll(includePublicXmlParamSet);
        for (Set<String> set : this.commonConfigBean.getExcludeXmlParamMap().values()) {
            set.addAll(includePublicXmlParamSet);
        }
        this.commonConfigBean.getExcludeXmlParamMap().putAll(configBean.getExcludeXmlParamMap());
        Set<String> publicJsonParamSet = configBean.getPublicJsonParam();
        this.commonConfigBean.getPublicJsonParam().addAll(publicJsonParamSet);
        for (Set<String> set : this.commonConfigBean.getExcludeJsonParamMap().values()) {
            set.addAll(publicJsonParamSet);
        }
        this.commonConfigBean.getExcludeJsonParamMap().putAll(configBean.getExcludeJsonParamMap());
        Set<String> set = configBean.getPublicQueryStringParam();
        this.commonConfigBean.getPublicQueryStringParam().addAll(set);
        for (Set<String> queryStringParams : this.commonConfigBean.getExcludeQueryStingParamMap().values()) {
            queryStringParams.addAll(set);
        }
        this.commonConfigBean.getExcludeQueryStingParamMap().putAll(configBean.getExcludeQueryStingParamMap());
    }

    private void addUrlCheckNote(Element commonRootParam, RootParamValidatorsBean rootParamBean) {
        Element root = commonRootParam.element("root");
        if (root == null) {
            root = commonRootParam.element("exclude-url");
            if (root == null) {
                LOG.error("[WSF-ParamValidate] Config file is not config exclude-url node.");
                return;
            }
            FileUtil.addUrlCheckNote(commonRootParam, rootParamBean);
        } else {
            FileUtil.addUrlCheckNote(root, rootParamBean);
        }
        String allUrlCheck = root.attributeValue("allUrlCheck");
        if (this.isEqualIgnoreCase(FALSE_STR, allUrlCheck)) {
            rootParamBean.setAllUrlCheck(false);
            LOG.warn("[WSF-ParamValidate] AllUrlCheck config value is false, probably some request is not verified.");
        } else {
            rootParamBean.setAllUrlCheck(true);
        }
        rootParamBean.setFailPath(root.attributeValue("failpath"));
        this.setStateCode(rootParamBean, root);
        rootParamBean.setErrorHandlerClassName(root.attributeValue("errorHandler"));
    }

    private void setStateCode(RootParamValidatorsBean rootParamBean, Element root) {
        String stateCode = root.attributeValue("stateCode");
        try {
            int stateCodeInt = Integer.parseInt(stateCode);
            if (stateCodeInt < 100 || stateCodeInt > 600) {
                LOG.error("[WSF-ParamValidate] State code config error, use the default value {}.", (Object)400);
                rootParamBean.setStateCode(400);
            } else {
                rootParamBean.setStateCode(stateCodeInt);
            }
        }
        catch (NumberFormatException ex) {
            if (EmptyUtils.hasText(stateCode)) {
                LOG.error("[WSF-ParamValidate] State code config error, use the default value {}.", (Object)400);
            } else {
                LOG.info("[WSF-ParamValidate] State code not config, use the default value {}.", (Object)400);
            }
            rootParamBean.setStateCode(400);
        }
    }

    private LoadCommonIncludeFile getIncludeFile(Element commonRootParam, String validatorRuleFilePath) {
        Element includeNode = commonRootParam.element("include");
        LoadCommonIncludeFile commonIncludeFile = null;
        if (includeNode == null) {
            LOG.info("[WSF-ParamValidate] The validate-common-config.xml is not config include node.");
            return commonIncludeFile;
        }
        String fileName = includeNode.attribute("file").getValue();
        if (EmptyUtils.isEmpty(fileName)) {
            return commonIncludeFile;
        }
        try {
            commonIncludeFile = !validatorRuleFilePath.startsWith("classpath:") ? new LoadCommonIncludeFile(validatorRuleFilePath + fileName) : new LoadCommonIncludeFile(validatorRuleFilePath + "/" + fileName);
            return commonIncludeFile;
        }
        catch (ValidateException e) {
            LOG.error("[WSF-ParamValidate] Load include file occur exception. {}", (Object)e.getMessage());
            return commonIncludeFile;
        }
    }

    private List<ValidatorBean> loadValidators(Element paramNode) {
        Iterator validatorNodes = paramNode.elementIterator("validator");
        ArrayList<ValidatorBean> validatorList = new ArrayList<ValidatorBean>(10);
        while (validatorNodes.hasNext()) {
            Element validator = (Element)validatorNodes.next();
            HashMap<String, String> validatorAttributeValueMap = new HashMap<String, String>(8);
            FileUtil.trimMapData(validator, validatorAttributeValueMap);
            ValidatorBean validatorObject = new ValidatorBean();
            validatorObject.setValidatorAttributeValue(validatorAttributeValueMap);
            validatorList.add(validatorObject);
        }
        return validatorList;
    }

    private List<ValidatorBean> getPublicValidators(String publicValidator) throws ValidateException {
        ArrayList<ValidatorBean> validatorList = new ArrayList<ValidatorBean>(10);
        if (EmptyUtils.hasText(publicValidator)) {
            String[] validatorRefArray;
            Map<String, List<ValidatorBean>> validatorMap = this.commonConfigBean.getCommonValidatorsMap();
            if (validatorMap == null) {
                LOG.error("[WSF-ParamValidate] Need public validators, but not reference common file config.");
                throw new ValidateException("Need public validators, but not reference common file config.");
            }
            for (String validatorRefName : validatorRefArray = publicValidator.split(",")) {
                List<ValidatorBean> validatorCatchList = validatorMap.get(validatorRefName);
                if (validatorCatchList == null) {
                    throw new ValidateException("Config public validators alias name is error.");
                }
                validatorList.addAll(validatorCatchList);
            }
        } else {
            LOG.debug("[WSF-ParamValidate] Public validator is not config.");
        }
        return validatorList;
    }

    private void checkUrlAndMethod(RequestSpecificMappingInfo mappingInfo) throws ValidateException {
        if (!this.commonConfigBean.isCheckUserConfig()) {
            return;
        }
        for (RequestMappingInfo requestMappingInfo : this.validateParamMap.keySet()) {
            if (!requestMappingInfo.getPatterns()[0].equals(mappingInfo.getPatterns()[0]) || !Objects.equals(mappingInfo.getDataPattern(), requestMappingInfo.getDataPattern())) continue;
            for (String cacheMethod : requestMappingInfo.getMethods()) {
                for (String method : mappingInfo.getMethods()) {
                    this.errorMessage(requestMappingInfo, cacheMethod, method);
                }
            }
        }
    }

    private void errorMessage(RequestMappingInfo cacheMappingInfo, String cacheMethod, String method) throws ValidateException {
        if (cacheMethod.equalsIgnoreCase(method)) {
            String errorMessage = "The same URI address, the request method is the inclusion of the relationship. URL is " + cacheMappingInfo.getPatterns()[0] + ", Method1 is " + cacheMethod + ", method2 is " + method;
            LOG.error("[WSF-ParamValidate] {}.", (Object)LogUtils.cleanLog(errorMessage));
            throw new ValidateException(LogUtils.cleanLog(errorMessage));
        }
    }

    private void checkQueryString(String dataPattern, List<BasicParamConfigBean> queryStringList) throws ValidateException {
        if ("form".equalsIgnoreCase(dataPattern) && !EmptyUtils.isEmpty(queryStringList)) {
            LOG.error("[WSF-ParamValidate] When dataPattern is form, it shouldn't config querystring.");
            throw new ValidateException("When dataPattern is form, it shouldn't config querystring.");
        }
    }

    void parseParamTemplate(Element rootEle) throws ValidateException {
        List templateEleList = rootEle.elements("parameter_template");
        for (Element template : templateEleList) {
            String name = template.attributeValue("name");
            if (EmptyUtils.isEmpty(name)) {
                throw new ValidateException("The template name cannot be empty.");
            }
            List paramList = template.elements("parameter");
            if (EmptyUtils.isEmpty(paramList)) {
                throw new ValidateException("The parameter cannot be empty.");
            }
            FileCache.getInstance().addTemplates(name, paramList);
        }
    }

    void parseValidatorsTemplates(Element rootEle) {
        Iterator validatorsList = rootEle.elementIterator("validators");
        HashMap<String, List<ValidatorBean>> validatorsMap = new HashMap<String, List<ValidatorBean>>(32);
        while (validatorsList.hasNext()) {
            Element validators = (Element)validatorsList.next();
            String alias = validators.attributeValue("alias");
            List<ValidatorBean> validatorList = this.loadValidators(validators);
            validatorsMap.put(alias, validatorList);
        }
        FileCache.getInstance().setValidatorTemplates(validatorsMap);
    }
}

