/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.config;

import com.huawei.security.validator.bean.CommonConfigsBean;
import com.huawei.security.validator.bean.RootParamValidatorsBean;
import com.huawei.security.validator.bean.ValidateFileConfig;
import com.huawei.security.validator.bean.ValidateRuleBean;
import com.huawei.security.validator.bean.ValidatorBean;
import com.huawei.security.validator.config.AbstractRuleFileLoad;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.requestmapping.RequestSpecificMappingInfo;
import com.huawei.security.validator.util.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

public final class FileCache {
    private static final FileCache INSTANCE = new FileCache();
    private Map<RequestSpecificMappingInfo, ValidateRuleBean> validateParamMap;
    private Map<String, Set<String>> validateRuleSizeMap;
    private RootParamValidatorsBean rootParamBean = new RootParamValidatorsBean();
    private CommonConfigsBean commonConfigsBean = new CommonConfigsBean();
    private Map<String, List<Element>> templates = new HashMap<String, List<Element>>(16);
    private Map<String, List<ValidatorBean>> validatorTemplates = new HashMap<String, List<ValidatorBean>>(16);
    private AbstractRuleFileLoad ruleFile = null;
    private ValidateFileConfig fileConfig;

    private FileCache() {
    }

    public static FileCache getInstance() {
        return INSTANCE;
    }

    public RootParamValidatorsBean getRootParamBean() {
        return this.rootParamBean;
    }

    public void setRootParamBean(RootParamValidatorsBean rootParamBean) {
        this.rootParamBean = rootParamBean;
    }

    public CommonConfigsBean getCommonConfigsBean() {
        return this.commonConfigsBean;
    }

    public void setCommonConfigsBean(CommonConfigsBean commonConfigsBean) {
        this.commonConfigsBean = commonConfigsBean;
    }

    public Map<RequestSpecificMappingInfo, ValidateRuleBean> getValidateParam() {
        if (this.validateParamMap == null) {
            this.validateParamMap = this.ruleFile.getValidateMap();
        }
        return this.validateParamMap;
    }

    public Map<String, Set<String>> getValidateRuleSize() {
        if (this.validateRuleSizeMap == null) {
            this.validateRuleSizeMap = this.ruleFile.getValidateRuleSizeMap();
        }
        return this.validateRuleSizeMap;
    }

    public void setRuleFile(AbstractRuleFileLoad ruleFile) {
        this.ruleFile = ruleFile;
    }

    public ValidateFileConfig getFileConfig() {
        return this.fileConfig;
    }

    public void setFileConfig(ValidateFileConfig fileConfig) {
        this.fileConfig = fileConfig;
    }

    public List<Element> getParameterListByName(String templateName) {
        return this.templates.get(templateName);
    }

    public void clearTemplates() {
        this.templates.clear();
    }

    public void addTemplates(String name, List<Element> parameterList) throws ValidateException {
        if (this.templates.containsKey(name)) {
            throw new ValidateException("The template name " + LogUtils.cleanLog(name) + " have exist.");
        }
        this.templates.put(name, parameterList);
    }

    public Map<String, List<ValidatorBean>> getValidatorTemplates() {
        return this.validatorTemplates;
    }

    public void setValidatorTemplates(Map<String, List<ValidatorBean>> validatorTemplates) {
        this.validatorTemplates = validatorTemplates;
    }
}

