/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.config;

import com.huawei.security.validator.bean.CommonConfigsBean;
import com.huawei.security.validator.bean.RootParamValidatorsBean;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.LogUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.slf4j.Logger;

public final class FileUtil {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    private FileUtil() {
    }

    public static void addUrlCheckNote(Element commonRootParam, RootParamValidatorsBean rootParamBean) {
        Element excludedUrlElement = commonRootParam.element("exclude-url");
        if (excludedUrlElement == null) {
            LOG.error("[WSF-ParamValidate] Common config file is not config exclude-url node.");
            return;
        }
        Iterator urlPatternElements = excludedUrlElement.elementIterator("url-pattern");
        ArrayList<String> excludeUrlPattern = new ArrayList<String>(10);
        while (urlPatternElements.hasNext()) {
            Element urlPatternElement = (Element)urlPatternElements.next();
            excludeUrlPattern.add(urlPatternElement.getStringValue());
        }
        rootParamBean.setExcludeUrlPattern(excludeUrlPattern);
    }

    public static void setUrlPathExcludeParam(CommonConfigsBean commonConfigBean, Element excludedParam) throws ValidateException {
        LOG.info("[WSF-ParamValidate] Load url path white list xpath.");
        Element excludedUrlPathParam = excludedParam.element("urlpath-exclude-parameter");
        if (excludedUrlPathParam == null) {
            return;
        }
        String allParamCheck = excludedUrlPathParam.attributeValue("allParameterCheck");
        commonConfigBean.setUrlPathAllParamCheck(!"false".equalsIgnoreCase(allParamCheck));
        HashSet<String> paramNameUrlPathSet = new HashSet<String>(16);
        if (commonConfigBean.isUrlPathAllParamCheck()) {
            Iterator paramNameElementIterator = excludedUrlPathParam.elementIterator("parameter-name");
            while (paramNameElementIterator.hasNext()) {
                Element paramNameElement = (Element)paramNameElementIterator.next();
                String paramName = paramNameElement.getStringValue();
                FileUtil.checkParamWhiteListName(paramNameUrlPathSet, paramName);
                paramNameUrlPathSet.add(paramName);
            }
        }
        commonConfigBean.setExcludeUrlPathParam(paramNameUrlPathSet);
    }

    public static void addExcludedParameterCheckNote(Element commonRootParam, CommonConfigsBean commonConfigBean) throws ValidateException {
        Element excludedParam = commonRootParam.element("exclude-parameter");
        if (excludedParam == null) {
            LOG.info("[WSF-ParamValidate] Have not exclude-parameter node.");
            return;
        }
        FileUtil.setFormExcludedParam(commonConfigBean, excludedParam);
        FileUtil.setXmlExcludeParam(commonConfigBean, excludedParam);
        FileUtil.setJsonExcludedParam(commonConfigBean, excludedParam);
        FileUtil.setUrlPathExcludeParam(commonConfigBean, excludedParam);
        FileUtil.setQueryStringExcludeParam(commonConfigBean, excludedParam);
    }

    private static void setFormExcludedParam(CommonConfigsBean commonConfigBean, Element excludedParam) throws ValidateException {
        LOG.info("[WSF-ParamValidate] Load form white list xpath.");
        String allParamCheck = excludedParam.attributeValue("allParameterCheck");
        Element excludedFormParam = excludedParam.element("form-exclude-parameter");
        Iterator paramNameElementIterator = null;
        String formCheck = "";
        if (excludedFormParam != null) {
            formCheck = excludedFormParam.attributeValue("allParameterCheck");
            paramNameElementIterator = excludedFormParam.elementIterator("parameter-name");
        } else {
            formCheck = allParamCheck;
            paramNameElementIterator = excludedParam.elementIterator("parameter-name");
        }
        commonConfigBean.setFormAllParamCheck(!"false".equalsIgnoreCase(formCheck));
        HashSet<String> paramNameFormSet = new HashSet<String>(16);
        if (commonConfigBean.isFormAllParamCheck()) {
            while (paramNameElementIterator.hasNext()) {
                Element paramNameElement = (Element)paramNameElementIterator.next();
                String paramName = paramNameElement.getStringValue();
                FileUtil.checkParamWhiteListName(paramNameFormSet, paramName);
                paramNameFormSet.add(paramName);
            }
        }
        commonConfigBean.setExcludeParam(paramNameFormSet);
    }

    private static void setJsonExcludedParam(CommonConfigsBean commonConfigBean, Element excludedParam) throws ValidateException {
        LOG.info("[WSF-ParamValidate] Load json white list xpath.");
        HashMap<String, Set<String>> excludedJsonParamMap = new HashMap<String, Set<String>>(16);
        Element excludedJsonParam = excludedParam.element("json-exclude-parameter");
        if (excludedJsonParam != null) {
            String allCheck = excludedJsonParam.attributeValue("allParameterCheck");
            commonConfigBean.setJsonAllParamCheck(!"false".equalsIgnoreCase(allCheck));
            if (commonConfigBean.isJsonAllParamCheck()) {
                Iterator requestUrlElement = excludedJsonParam.elementIterator("request-url");
                Iterator publicElement = excludedJsonParam.elementIterator("parameter-name");
                HashSet<String> paramPublicJsonSet = new HashSet<String>(16);
                while (publicElement.hasNext()) {
                    String paramName = ((Element)publicElement.next()).getStringValue();
                    FileUtil.checkParamWhiteListName(paramPublicJsonSet, paramName);
                    paramPublicJsonSet.add(paramName);
                }
                commonConfigBean.setPublicJsonParam(paramPublicJsonSet);
                while (requestUrlElement.hasNext()) {
                    Element element = (Element)requestUrlElement.next();
                    String urlValue = element.attributeValue("value");
                    Set<String> paramJsonKeySet = FileUtil.getParamJsonKeySet(paramPublicJsonSet, element);
                    excludedJsonParamMap.put(urlValue, paramJsonKeySet);
                }
            }
        }
        commonConfigBean.setExcludeJsonParamMap(excludedJsonParamMap);
    }

    private static Set<String> getParamJsonKeySet(Set<String> paramPublicJsonSet, Element element) throws ValidateException {
        Iterator xpathElementIterator = element.elementIterator("parameter-name");
        HashSet<String> paramJsonKeySet = new HashSet<String>(16);
        if (!paramPublicJsonSet.isEmpty()) {
            paramJsonKeySet.addAll(paramPublicJsonSet);
        }
        while (xpathElementIterator.hasNext()) {
            String paramName = ((Element)xpathElementIterator.next()).getStringValue();
            FileUtil.checkParamWhiteListName(paramJsonKeySet, paramName);
            paramJsonKeySet.add(paramName);
        }
        return paramJsonKeySet;
    }

    public static File getFile(String fileName) {
        FileUtil.checkFileName(fileName);
        return new File(fileName);
    }

    public static File getFile(String firstFileName, String secondFileName) {
        FileUtil.checkFileName(firstFileName);
        FileUtil.checkFileName(secondFileName);
        return new File(new File(firstFileName), secondFileName);
    }

    private static void checkFileName(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            throw new NullPointerException("fileName is null or empty, please check your input.");
        }
    }

    private static void setQueryStringExcludeParam(CommonConfigsBean commonConfigBean, Element excludedElement) throws ValidateException {
        LOG.info("[WSF-ParamValidate] Load querystring white list xpath.");
        HashMap<String, Set<String>> excludedQueryStringParamMap = new HashMap<String, Set<String>>(16);
        Element excludedQueryStringParam = excludedElement.element("querystring-exclude-parameter");
        if (excludedQueryStringParam != null) {
            String allCheck = excludedQueryStringParam.attributeValue("allParameterCheck");
            commonConfigBean.setQueryStringAllParamCheck(!"false".equalsIgnoreCase(allCheck));
            if (commonConfigBean.isQueryStringAllParamCheck()) {
                Iterator requestUrlElement = excludedQueryStringParam.elementIterator("request-url");
                Iterator publicElement = excludedQueryStringParam.elementIterator("parameter-name");
                HashSet<String> paramPublicQueryStringSet = new HashSet<String>(16);
                while (publicElement.hasNext()) {
                    String paramName = ((Element)publicElement.next()).getStringValue();
                    FileUtil.checkParamWhiteListName(paramPublicQueryStringSet, paramName);
                    paramPublicQueryStringSet.add(paramName);
                }
                commonConfigBean.setPublicQueryStringParam(paramPublicQueryStringSet);
                while (requestUrlElement.hasNext()) {
                    Element element = (Element)requestUrlElement.next();
                    String urlValue = element.attributeValue("value");
                    Set<String> paramQueryStringNameSet = FileUtil.getParamQueryStringNameSet(paramPublicQueryStringSet, element);
                    excludedQueryStringParamMap.put(urlValue, paramQueryStringNameSet);
                }
            }
        }
        commonConfigBean.setExcludeQueryStingParamMap(excludedQueryStringParamMap);
    }

    private static Set<String> getParamQueryStringNameSet(Set<String> paramPublicQueryStringSet, Element element) throws ValidateException {
        Iterator nameElementIterator = element.elementIterator("parameter-name");
        HashSet<String> paramQueryStringNameSet = new HashSet<String>(16);
        if (!paramPublicQueryStringSet.isEmpty()) {
            paramQueryStringNameSet.addAll(paramPublicQueryStringSet);
        }
        while (nameElementIterator.hasNext()) {
            String paramName = ((Element)nameElementIterator.next()).getStringValue();
            FileUtil.checkParamWhiteListName(paramQueryStringNameSet, paramName);
            paramQueryStringNameSet.add(paramName);
        }
        return paramQueryStringNameSet;
    }

    private static void setXmlExcludeParam(CommonConfigsBean commonConfigBean, Element excludedParam) throws ValidateException {
        LOG.info("[WSF-ParamValidate] Load xml white list xpath.");
        HashMap<String, Set<String>> excludedXmlParamMap = null;
        Element excludedXMLParam = excludedParam.element("xml-exclude-parameter");
        if (excludedXMLParam != null) {
            String allCheck = excludedXMLParam.attributeValue("allParameterCheck");
            commonConfigBean.setXmlAllParamCheck(!"false".equalsIgnoreCase(allCheck));
            if (commonConfigBean.isXmlAllParamCheck()) {
                List xmlElementList = excludedXMLParam.elements("request-url");
                excludedXmlParamMap = new HashMap<String, Set<String>>(xmlElementList.size());
                Iterator publicElement = excludedXMLParam.elementIterator("parameter-name");
                HashSet<String> paramPublicXmlPathSet = new HashSet<String>(16);
                while (publicElement.hasNext()) {
                    String paramName = ((Element)publicElement.next()).getStringValue();
                    FileUtil.checkParamWhiteListName(paramPublicXmlPathSet, paramName);
                    paramPublicXmlPathSet.add(paramName);
                }
                commonConfigBean.setPublicXmlParam(paramPublicXmlPathSet);
                for (Element urlElement : xmlElementList) {
                    String urlValue = urlElement.attributeValue("value");
                    Set<String> paramXmlPathSet = FileUtil.getParamXmlPathSet(paramPublicXmlPathSet, urlElement);
                    excludedXmlParamMap.put(urlValue, paramXmlPathSet);
                }
            }
        }
        commonConfigBean.setExcludeXmlParamMap(excludedXmlParamMap);
    }

    private static Set<String> getParamXmlPathSet(Set<String> paramPublicXmlPathSet, Element urlElement) throws ValidateException {
        Iterator xpathElementIterator = urlElement.elementIterator("parameter-name");
        HashSet<String> paramXmlPathSet = new HashSet<String>(16);
        if (!paramPublicXmlPathSet.isEmpty()) {
            paramXmlPathSet.addAll(paramPublicXmlPathSet);
        }
        while (xpathElementIterator.hasNext()) {
            String paramName = ((Element)xpathElementIterator.next()).getStringValue();
            FileUtil.checkParamWhiteListName(paramXmlPathSet, paramName);
            paramXmlPathSet.add(paramName);
        }
        return paramXmlPathSet;
    }

    private static void checkParamWhiteListName(Set<String> paramSet, String parameterName) throws ValidateException {
        if (paramSet.contains(parameterName)) {
            LOG.error("[WSF-ParamValidate] Config parameter exist same name, please modify. Parameter name is {}.", (Object)LogUtils.cleanLog(parameterName));
            throw new ValidateException("Config parameter exist same name, please modify. Parameter name is " + LogUtils.cleanLog(parameterName));
        }
    }

    public static void trimMapData(Element validator, Map<String, String> validatorAttributeValueMap) {
        Iterator attributesIterator = validator.attributeIterator();
        while (attributesIterator.hasNext()) {
            String attributeValue;
            Attribute attribute = (Attribute)attributesIterator.next();
            String attributeName = attribute.getName();
            if (attributeName != null) {
                attributeName = attributeName.trim();
            }
            if ((attributeValue = attribute.getValue()) != null) {
                attributeValue = attributeValue.trim();
            }
            validatorAttributeValueMap.put(attributeName, attributeValue);
        }
    }
}

