/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.config;

import com.huawei.security.validator.bean.CommonConfigsBean;
import com.huawei.security.validator.bean.RootParamValidatorsBean;
import com.huawei.security.validator.config.FileUtil;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.WSFSaxRead;
import java.io.File;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.slf4j.Logger;

public class LoadCommonIncludeFile {
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private Document includeDocument;
    private CommonConfigsBean commonConfigBean;
    private RootParamValidatorsBean rootParamValidatorBean;

    public LoadCommonIncludeFile(String includeFilePath) throws ValidateException {
        this.loadFile(includeFilePath);
        this.parseExcludeUrl();
        this.parseExcludeParameter();
    }

    public CommonConfigsBean getCommonConfigBean() {
        return this.commonConfigBean;
    }

    public RootParamValidatorsBean getRootParamValidatorBean() {
        return this.rootParamValidatorBean;
    }

    private void loadFile(String filePath) throws ValidateException {
        try {
            if (!filePath.startsWith("classpath:")) {
                File file = FileUtil.getFile(filePath);
                WSFSaxRead reader = new WSFSaxRead();
                this.includeDocument = reader.read(file);
            }
        }
        catch (DocumentException e) {
            LOG.error("[WSF-ParamValidate] Load file fail.");
            throw new ValidateException(LogUtils.cleanLog(e.getMessage()), e);
        }
    }

    private void parseExcludeUrl() {
        if (this.includeDocument != null) {
            this.rootParamValidatorBean = new RootParamValidatorsBean();
            FileUtil.addUrlCheckNote(this.includeDocument.getRootElement(), this.rootParamValidatorBean);
        } else {
            LOG.error("[WSF-ParamValidate] Include file load exclude_url fail.");
        }
    }

    private void parseExcludeParameter() throws ValidateException {
        if (this.includeDocument != null) {
            this.commonConfigBean = new CommonConfigsBean();
            FileUtil.addExcludedParameterCheckNote(this.includeDocument.getRootElement(), this.commonConfigBean);
        } else {
            LOG.error("[WSF-ParamValidate] Include file load exclude_parameter fail.");
        }
    }
}

