/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.config;

import com.huawei.security.validator.config.AbstractRuleFileLoad;
import com.huawei.security.validator.config.FileUtil;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.WSFSaxRead;
import java.io.File;
import java.util.HashMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.slf4j.Logger;

public final class LoadConfigFile
extends AbstractRuleFileLoad {
    private static final int VALIDATE_PARAM_MAP_SIZE = 128;
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private static String customDirectory = System.getProperty("com.huawei.security.validator");

    @Override
    public void loadConfigFile() throws ValidateException {
        File file = FileUtil.getFile(this.path);
        if (!file.canRead() && customDirectory != null) {
            this.path = customDirectory + File.separator + "validate" + File.separator;
            file = FileUtil.getFile(this.path);
        }
        if (!file.canRead()) {
            LOG.error("[WSF-ParamValidate] The specified configuration file path may not exist.");
            throw new ValidateException("The specified validator configuration file path may not exist.");
        }
        this.validateParamMap = new HashMap(128);
        this.validateRuleSizeMap = new HashMap(128);
        this.parseCombinedValidators(file);
        this.parseCommonConfig();
        this.parseTemplate(file);
        this.parseValidateRule(file);
    }

    private void parseCommonConfig() {
        try {
            LOG.debug("[WSF-ParamValidate] Begin parse validate-common-config.xml.");
            File file = FileUtil.getFile(this.path + "validate-common-config.xml");
            WSFSaxRead reader = new WSFSaxRead();
            Document document = reader.read(file);
            this.parseCommonConfigXml(document, this.path);
            LOG.debug("[WSF-ParamValidate] End parse validate-common-config.xml.");
        }
        catch (DocumentException ex) {
            LOG.error("[WSF-ParamValidate] Parse validate-common-config.xml occur exception: DocumentException.");
        }
    }

    private void parseTemplate(File file) throws ValidateException {
        String[] fileNames = file.list((dir, name) -> name.startsWith("validate-template") && name.endsWith(".xml"));
        if (EmptyUtils.isEmpty(fileNames)) {
            LOG.info("[WSF-ParamValidate] Have not found validate-template file.");
            return;
        }
        LOG.info("[WSF-ParamValidate] The validate-template files length is {}.", (Object)fileNames.length);
        try {
            WSFSaxRead reader = new WSFSaxRead();
            for (String fileName : fileNames) {
                LOG.debug("[WSF-ParamValidate] Begin parse validate-template: {}.", (Object)fileName);
                Document document = reader.read(FileUtil.getFile(this.path + fileName));
                this.parseParamTemplate(document.getRootElement());
                LOG.debug("[WSF-ParamValidate] End parse validate-template: {}.", (Object)fileName);
            }
        }
        catch (DocumentException ex) {
            LOG.error("[WSF-ParamValidate] Parse validate-template file occur exception: DocumentException.");
            throw new ValidateException("Parse validate-template file occur exception.", ex);
        }
    }

    private void parseCombinedValidators(File file) throws ValidateException {
        String[] fileNames = file.list((dir, name) -> name.startsWith("validate-validator") && name.endsWith(".xml"));
        if (EmptyUtils.isEmpty(fileNames)) {
            LOG.info("[WSF-ParamValidate] Have not found validate-validator file.");
            return;
        }
        LOG.info("[WSF-ParamValidate] The validate-validator files length is {}.", (Object)fileNames.length);
        try {
            WSFSaxRead reader = new WSFSaxRead();
            for (String fileName : fileNames) {
                LOG.debug("[WSF-ParamValidate] Begin parse validate-validator: {}.", (Object)fileName);
                Document document = reader.read(FileUtil.getFile(this.path + fileName));
                this.parseValidatorsTemplates(document.getRootElement());
                LOG.debug("[WSF-ParamValidate] End parse validate-template: {}.", (Object)fileName);
            }
        }
        catch (DocumentException ex) {
            LOG.error("[WSF-ParamValidate] Parse validate-validator file occur exception: DocumentException.");
            throw new ValidateException("Parse validate-validator file occur exception.", ex);
        }
    }

    private void parseValidateRule(File file) throws ValidateException {
        String[] fileNames = file.list((dir, name) -> name.startsWith("validate-rule") && name.endsWith(".xml"));
        if (EmptyUtils.isEmpty(fileNames)) {
            LOG.error("[WSF-ParamValidate] Can't find xml file with prefix validate-rule.");
            throw new ValidateException("Can't find xml file with prefix validate-rule.");
        }
        LOG.info("[WSF-ParamValidate] The validate-rule files length is {}.", (Object)fileNames.length);
        try {
            WSFSaxRead reader = new WSFSaxRead();
            for (String fileName : fileNames) {
                LOG.debug("[WSF-ParamValidate] Begin parse validate-rule: {}.", (Object)fileName);
                Document document = reader.read(FileUtil.getFile(this.path + fileName));
                this.addParamValidators(document.getRootElement());
                LOG.debug("[WSF-ParamValidate] End parse validate-rule: {}.", (Object)fileName);
            }
        }
        catch (DocumentException ex) {
            LOG.error("[WSF-ParamValidate] Parse validate-rule file occur exception: DocumentException.");
            throw new ValidateException("Parse validate-rule file occur exception.", ex);
        }
    }
}

