/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.config;

import com.huawei.security.validator.bean.HeaderParam;
import com.huawei.security.validator.bean.ValidatorBean;
import com.huawei.security.validator.config.FileUtil;
import com.huawei.security.validator.exception.ParseValidateConfigException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.RequestHeaderValidateFailedHandler;
import com.huawei.security.validator.outerinterface.defaultimp.RequestHeaderValidateFailedHandlerImpl;
import com.huawei.security.validator.util.EmptyUtils;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.xml.sax.SAXException;

public class RequestHeaderValidteConfig {
    private static final int SUB_STARING_INDEX = 3;
    private static final String ELEMENT_ACCESS_DENY_HANDLER = "access_denied_handler";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_ERROR_PAGE = "errorpage";
    private static final String ELEMENT_VALIDATOR_HEADERS = "validate_headers";
    private static final String ELEMENT_VALIDATOR_HEADER = "header";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_URL_PATTERN = "url_pattern";
    private static final String ATTRIBUTE_FORBIDDEN = "forbidden";
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private RequestHeaderValidateFailedHandler validateFailedHandler;
    private List<HeaderParam> validateRuleList = new ArrayList<HeaderParam>(10);

    public void initConfig(InputStream xmlFileStream) throws ParseValidateConfigException {
        this.loadXmlFile(xmlFileStream);
    }

    public RequestHeaderValidateFailedHandler getValidateFailedHandler() {
        return this.validateFailedHandler;
    }

    public List<HeaderParam> getValidateRuleList() {
        return this.validateRuleList;
    }

    public void setValidateRuleList(List<HeaderParam> validateRuleList) {
        this.validateRuleList = validateRuleList;
    }

    private void loadXmlFile(InputStream xmlFileStream) throws ParseValidateConfigException {
        SAXReader reader = new SAXReader();
        try {
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document dom = reader.read(xmlFileStream);
            Element rootEl = dom.getRootElement();
            Element denyHandlerElement = rootEl.element(ELEMENT_ACCESS_DENY_HANDLER);
            this.parseAccessDenyHandler(denyHandlerElement);
            Element validateHeaderElement = rootEl.element(ELEMENT_VALIDATOR_HEADERS);
            this.parseValidateHeaderConf(validateHeaderElement);
        }
        catch (DocumentException | SAXException ex) {
            LOG.warn("[WSF-HeaderValidate] Parse config failed: DocumentException or SAXException.");
            throw new ParseValidateConfigException("Parse config failed.", ex);
        }
    }

    private void parseAccessDenyHandler(Element handlerElement) {
        List attrs = handlerElement.attributes();
        String handlerClass = "";
        HashMap<String, String> attrMap = new HashMap<String, String>(attrs.size());
        for (Attribute attr : attrs) {
            if (attr.getName().equalsIgnoreCase(ATTRIBUTE_CLASS)) {
                handlerClass = attr.getValue();
                continue;
            }
            attrMap.put(attr.getName().toLowerCase(Locale.ENGLISH), attr.getValue());
        }
        try {
            Class<?> cla = Class.forName(handlerClass);
            this.execMethods(attrMap, cla);
        }
        catch (IllegalArgumentException | ReflectiveOperationException ex) {
            RequestHeaderValidateFailedHandlerImpl errorHandler = new RequestHeaderValidateFailedHandlerImpl();
            if (attrMap.containsKey(ATTRIBUTE_ERROR_PAGE)) {
                errorHandler.setErrorPage((String)attrMap.get(ATTRIBUTE_ERROR_PAGE));
            }
            this.validateFailedHandler = errorHandler;
            LOG.error("[WSF-HeaderValidate] Parse accessDenyHandler failed, use default accessDenyHandler, errorInfo: {}", (Object)ex.getMessage());
        }
    }

    private void execMethods(Map<String, String> attrMap, Class<?> cla) throws ReflectiveOperationException {
        Method[] methods;
        Object obj = cla.newInstance();
        for (Method md : methods = cla.getMethods()) {
            String value;
            String methodName = md.getName();
            if (!methodName.startsWith("set") || (value = attrMap.get(methodName.substring(3).toLowerCase(Locale.ENGLISH))) == null) continue;
            md.invoke(obj, value);
        }
        if (!(obj instanceof RequestHeaderValidateFailedHandler)) {
            throw new ReflectiveOperationException("Can't support the accessDenyHandler type.");
        }
        this.validateFailedHandler = (RequestHeaderValidateFailedHandler)obj;
    }

    private void parseValidateHeaderConf(Element headersEl) {
        List headerEls = headersEl.elements(ELEMENT_VALIDATOR_HEADER);
        for (Element headerEl : headerEls) {
            String name = null;
            String urlpattern = "/**";
            String forbidden = "false";
            List attrs = headerEl.attributes();
            for (Attribute attr : attrs) {
                if (attr.getName().equals(ATTRIBUTE_NAME)) {
                    name = attr.getValue().trim();
                    continue;
                }
                if (attr.getName().equals(ATTRIBUTE_URL_PATTERN)) {
                    urlpattern = attr.getValue().trim();
                    continue;
                }
                if (attr.getName().equals(ATTRIBUTE_FORBIDDEN)) {
                    forbidden = attr.getValue().trim();
                    continue;
                }
                LOG.info("[WSF-HeaderValidate] Can't resolve the attribute name.");
            }
            if (!EmptyUtils.hasLength(name)) continue;
            HeaderParam headerParam = new HeaderParam();
            headerParam.setName(name);
            headerParam.setUrlPattern(urlpattern);
            headerParam.setForbidden("true".equalsIgnoreCase(forbidden));
            headerParam.setValidatorList(this.parseValidator(headerEl));
            this.validateRuleList.add(headerParam);
        }
    }

    private List<ValidatorBean> parseValidator(Element headerElement) {
        ArrayList<ValidatorBean> validators = new ArrayList<ValidatorBean>(10);
        List validatorEls = headerElement.elements();
        for (Element validator : validatorEls) {
            ValidatorBean validatorObject = new ValidatorBean();
            HashMap<String, String> validatorAttributeValueMap = new HashMap<String, String>(16);
            FileUtil.trimMapData(validator, validatorAttributeValueMap);
            validatorObject.setValidatorAttributeValue(validatorAttributeValueMap);
            validators.add(validatorObject);
        }
        return validators;
    }
}

