/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.filter;

import com.huawei.security.validator.config.FileCache;
import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.util.StreamUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class FilterHttpServletRequest
extends HttpServletRequestWrapper {
    public static final String DEFAULT_CHARSET = "utf-8";
    private byte[] body;
    private ServletInputStream servletInputStream = null;
    private ByteArrayInputStream inputStream = null;
    private BufferedReader reader = null;

    public FilterHttpServletRequest(HttpServletRequest request) throws IOException, ParseRequestDataException {
        super(request);
        long inputStreamMaxSize = FileCache.getInstance().getCommonConfigsBean().getInputStreamMaxSize();
        this.body = StreamUtil.readBytes((InputStream)request.getInputStream(), inputStreamMaxSize);
        this.inputStream = new ByteArrayInputStream(this.body);
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.inputStream, this.getCharacterEncoding()));
        }
        return this.reader;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.servletInputStream == null) {
            this.servletInputStream = new ServletInputStream(){

                public int read() throws IOException {
                    return FilterHttpServletRequest.this.inputStream.read();
                }

                public boolean isFinished() {
                    return FilterHttpServletRequest.this.inputStream.available() == 0;
                }

                public boolean isReady() {
                    return true;
                }

                public void setReadListener(ReadListener paramReadListener) {
                }
            };
        }
        return this.servletInputStream;
    }

    public String getCharacterEncoding() {
        return super.getCharacterEncoding() == null ? DEFAULT_CHARSET : super.getCharacterEncoding();
    }

    public String getBody() throws IOException {
        String charset = this.getCharacterEncoding();
        return new String(this.body, charset);
    }
}

