/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.manager;

import com.huawei.security.validator.bean.BasicParamConfigBean;
import com.huawei.security.validator.bean.ErrorMessage;
import com.huawei.security.validator.bean.Parameter;
import com.huawei.security.validator.bean.ParameterConfigBean;
import com.huawei.security.validator.bean.ValidateRuleBean;
import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.exception.ParamValueValidateFailException;
import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.exception.ValidateException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.manager.AbstractProcessValidate;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.JsonUtil;
import com.huawei.security.validator.util.PublicData;
import com.huawei.security.validator.web.JsonParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class JsonProcessValidate
extends AbstractProcessValidate {
    private static final int RESULT_MAP_SIZE = 4;
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private ValidateRuleBean validateObject;
    private PublicData publicData;

    public JsonProcessValidate(ValidateRuleBean validateRuleBean, PublicData publicData) {
        this.validateObject = validateRuleBean;
        this.publicData = publicData;
    }

    @Override
    public void validatorParam(Parameter paramObject) throws ParamValueValidateFailException, ParseRequestDataException, ValidateException {
        if (this.validateObject == null) {
            LOG.info("[WSF-ParamValidate] Don't need validate json parameter.");
            return;
        }
        HashMap<String, ValidatorResult> resultMap = new HashMap<String, ValidatorResult>(4);
        List<BasicParamConfigBean> jsonNoteList = null;
        try {
            jsonNoteList = this.validateObject.getParamList(this.publicData.getRequestParamSetName());
        }
        catch (ValidateException ex) {
            this.validateExceptionProcess(resultMap, ex);
        }
        ArrayList<String> needCheckParamList = new ArrayList<String>();
        ArrayList<String> noNeedCheckParamList = new ArrayList<String>();
        if (jsonNoteList != null) {
            JsonUtil.handleCheckParamList(jsonNoteList, needCheckParamList, noNeedCheckParamList);
        }
        Map<String, List<String>> jsonAllInfoMap = null;
        if (!(paramObject instanceof JsonParameter)) {
            throw new ValidateException("The parameter type is not as expected.");
        }
        jsonAllInfoMap = ((JsonParameter)paramObject).getAllParamInfo(needCheckParamList, noNeedCheckParamList);
        this.processJsonNodeList(jsonNoteList, resultMap, jsonAllInfoMap, this.publicData);
        List<BasicParamConfigBean> noteList = this.validateObject.getWildCardParamList(this.publicData.getRequestParamSetName());
        if (!EmptyUtils.isEmpty(noteList)) {
            LOG.info("[WSF-ParamValidate] Need to validate wildcard parameter.");
            this.validateWildcardParameter(jsonAllInfoMap, resultMap, noteList);
        }
        this.checkJsonParamNum(jsonAllInfoMap, this.validateObject);
    }

    private void validateWildcardParameter(Map<String, List<String>> requestParamValueMap, Map<String, ValidatorResult> resultMap, List<BasicParamConfigBean> noteList) throws ValidateException, ParamValueValidateFailException {
        for (BasicParamConfigBean wildcardParam : noteList) {
            ErrorMessage error;
            ParameterConfigBean parameterObject = null;
            parameterObject = this.getParameterObject(wildcardParam);
            if (parameterObject == null) continue;
            String wildcardParamName = parameterObject.getName();
            boolean isRequire = parameterObject.isRequired();
            if (!this.isNeedCheck(isRequire, wildcardParamName, requestParamValueMap, error = new ErrorMessage(parameterObject.getErrorKey(), parameterObject.getErrorMessage()), resultMap)) continue;
            boolean isMatches = false;
            Pattern paramNamePattern = Pattern.compile(wildcardParamName);
            Iterator<Map.Entry<String, List<String>>> iterator = requestParamValueMap.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean isOptionalEmptyValue;
                Map.Entry<String, List<String>> requestParamEntry = iterator.next();
                String requestParamName = requestParamEntry.getKey();
                List<String> requestParams = requestParamEntry.getValue();
                if (!paramNamePattern.matcher(requestParamName).matches()) continue;
                isMatches = true;
                boolean isRequiredEmptyValue = EmptyUtils.isEmpty(requestParams) && isRequire;
                boolean bl = isOptionalEmptyValue = EmptyUtils.isEmpty(requestParams) && !isRequire;
                if (isRequiredEmptyValue) {
                    this.emptyRequiredHandler(requestParamName, error, resultMap);
                }
                if (isOptionalEmptyValue) {
                    this.emptyNotRequiredHandler(resultMap, wildcardParamName);
                    iterator.remove();
                    continue;
                }
                this.validateParam(requestParamName, parameterObject, requestParams, this.publicData, resultMap);
                iterator.remove();
            }
            this.paramNotMatchedHandler(resultMap, wildcardParamName, isRequire, error, isMatches);
        }
    }

    private void paramNotMatchedHandler(Map<String, ValidatorResult> resultMap, String wildcardParamName, boolean isRequire, ErrorMessage error, boolean isMatches) throws ParamValueValidateFailException {
        if (!isMatches) {
            if (isRequire) {
                this.emptyRequiredHandler(wildcardParamName, error, resultMap);
            } else {
                this.emptyNotRequiredHandler(resultMap, wildcardParamName);
            }
        }
    }

    private ParameterConfigBean getParameterObject(BasicParamConfigBean wildcardParam) {
        return this.getOptionalParameterConfig(wildcardParam).orElse(null);
    }

    private Optional<ParameterConfigBean> getOptionalParameterConfig(BasicParamConfigBean wildcardParam) {
        if (!(wildcardParam instanceof ParameterConfigBean)) {
            LOG.error("[WSF-ParamValidate] WildCardParamList contains object which is not ParameterConfigBean.");
            return Optional.empty();
        }
        ParameterConfigBean parameterObject = (ParameterConfigBean)wildcardParam;
        return Optional.ofNullable(parameterObject);
    }
}

