/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.outerinterface;

import com.huawei.security.validator.bean.ValidatorResult;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.outerinterface.Validator;
import com.huawei.security.validator.util.PublicData;
import com.huawei.security.validator.util.ValidatorUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public abstract class AbstractJsonValidator
implements Validator {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    public abstract ValidatorResult validate(String var1, Object var2, HashMap<String, String> var3, String var4, String var5);

    @Override
    public ValidatorResult inputValidate(Object inputValidate, HashMap<String, String> validateRuleMap, String errorKey, String errorMessage) {
        if (inputValidate == null) {
            ValidatorResult result = new ValidatorResult();
            LOG.error("[WSF-ParamValidate] AbstractJsonValidator: Input validate parameter value is null, so the result is false.");
            ValidatorUtil.setErrorResult(result, errorKey, errorMessage, "PARAM_VALUE_CANNOT_NULL", new Object[0]);
            return result;
        }
        if (inputValidate instanceof PublicData) {
            PublicData publicData = (PublicData)inputValidate;
            Map<String, String[]> paramMap = publicData.getRequestData();
            return this.validate(publicData.getJsonData(), paramMap, validateRuleMap, errorKey, errorMessage);
        }
        ValidatorResult result = new ValidatorResult();
        LOG.error("[WSF-ParamValidate] AbstractJsonValidator: Input validate parameter failed in downcasting.");
        ValidatorUtil.setErrorResult(result, errorKey, errorMessage, "PARAM_PATTERN_TYPE_ERROR", new Object[0]);
        return result;
    }
}

