/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.requestmapping;

import java.util.Arrays;
import java.util.Objects;
import org.springframework.util.StringUtils;

public class RequestMappingInfo {
    private static final int PATTERNS_NUM = 23;
    private static final int METHODS_NUM = 29;
    protected final String[] patterns;
    protected final String[] methods;
    protected final String dataPattern;

    RequestMappingInfo(String[] patterns, String[] methods, String dataPattern) {
        this.patterns = patterns != null ? patterns : new String[]{};
        this.methods = methods != null ? methods : new String[]{};
        this.dataPattern = !StringUtils.isEmpty((Object)dataPattern) ? dataPattern : "";
    }

    private static boolean checkRequestMethod(String[] methodsArray, String requestMethod) {
        for (String method : methodsArray) {
            if (!method.equalsIgnoreCase(requestMethod)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPatterns() {
        return this.patterns.length > 0;
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public String[] getMethods() {
        return this.methods;
    }

    public int getMethodCount() {
        return this.methods.length;
    }

    public String getDataPattern() {
        return this.dataPattern;
    }

    public boolean matchesRequestMethod(String requestMethod) {
        return RequestMappingInfo.checkRequestMethod(this.methods, requestMethod);
    }

    public boolean equals(Object object) {
        if (object instanceof RequestMappingInfo && this.getClass().isInstance(object)) {
            RequestMappingInfo other = (RequestMappingInfo)object;
            return Arrays.equals(this.patterns, other.patterns) && Arrays.equals(this.methods, other.methods) && Objects.equals(this.dataPattern, other.dataPattern);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.patterns) * 23 + Arrays.hashCode(this.methods) * 29 + Objects.hash(this.dataPattern);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(16);
        buf.append(Arrays.toString(this.patterns));
        if (this.methods.length > 0) {
            buf.append(',');
            buf.append(Arrays.toString(this.methods));
        }
        return buf.toString();
    }
}

