/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.JsonParseInterface;
import com.huawei.security.validator.util.JsonUtil;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

public class DefaultUserDefinedProcess
implements JsonParseInterface {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public Object getJsonObject(String jsonStr) throws ParseRequestDataException {
        if (EmptyUtils.isEmpty(jsonStr)) {
            LOG.error("[WSF-ParamValidate] The JSONObject String for converting to OrgJson is Empty.");
            throw new ParseRequestDataException("Failed to parse JSONObject String.");
        }
        try {
            String orgJsonObjectStr = jsonStr.trim();
            if (orgJsonObjectStr.startsWith("[")) {
                return new JSONArray(jsonStr);
            }
            if (orgJsonObjectStr.startsWith("{")) {
                return new JSONObject(jsonStr);
            }
            LOG.error("[WSF-ParamValidate] The JSONObject String has not correct Json struct: Json check.");
            throw new ParseRequestDataException("Json parse json occur exception.");
        }
        catch (JSONException e) {
            LOG.error("[WSF-ParamValidate] The JSONObject String has not correct Json struct: Json check.");
            throw new ParseRequestDataException("Json parse json occur exception.", e);
        }
        catch (Exception e) {
            LOG.error("[WSF-ParamValidate] Traverse json data occur exception.");
            throw new ParseRequestDataException("OrgJson failed to parse JSONObject Sting.", e);
        }
    }

    @Override
    public boolean isEmptyJson(Object json) throws ParseRequestDataException {
        if (json == null) {
            throw new ParseRequestDataException("Json content is null.");
        }
        if (json instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)json;
            return jsonObj.isEmpty();
        }
        if (json instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)json;
            return jsonArray.isEmpty();
        }
        LOG.error("[WSF-ParamValidate] The input object is not belong to Json.");
        return false;
    }

    @Override
    public void traverseJsonData(Object orgJsonData, Map<String, List<String>> dataMap, String completeKey) throws ParseRequestDataException {
        try {
            if (orgJsonData instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)orgJsonData;
                this.handleJsonObjectByOrgJson(dataMap, completeKey, jsonObject);
            } else if (orgJsonData instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)orgJsonData;
                this.handleJsonArrayByOrgJson(dataMap, completeKey, jsonArray);
            } else {
                JsonUtil.processJsonValue(orgJsonData, dataMap, completeKey);
            }
        }
        catch (ClassCastException ex) {
            LOG.error("[WSF-ParamValidate] Traverse json data occur exception.");
            throw new ParseRequestDataException("Traverse json data occur exception.", ex);
        }
    }

    private void handleJsonObjectByOrgJson(Map<String, List<String>> dataMap, String completeKey, JSONObject jsonObject) throws ParseRequestDataException {
        String completeKeyStr = completeKey;
        if (COMMON_CONFIG_BEAN.isParseEmptyMapArray() && jsonObject.isEmpty()) {
            JsonUtil.handleEmpty(completeKeyStr, dataMap);
        }
        for (String key : jsonObject.keySet()) {
            Object object = jsonObject.get(key);
            completeKeyStr = completeKeyStr + "@#9#%*@" + key;
            this.traverseJsonData(object, dataMap, completeKeyStr);
            completeKeyStr = completeKeyStr.substring(0, completeKeyStr.lastIndexOf("@#9#%*@"));
        }
    }

    private void handleJsonArrayByOrgJson(Map<String, List<String>> dataMap, String completeKey, JSONArray jsonArray) throws ParseRequestDataException {
        if (COMMON_CONFIG_BEAN.isParseEmptyMapArray() && jsonArray.isEmpty()) {
            JsonUtil.handleEmpty(completeKey, dataMap);
        }
        for (Object jsonObject : jsonArray) {
            this.traverseJsonData(jsonObject, dataMap, completeKey);
        }
    }
}

