/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.JsonParseInterface;
import com.huawei.security.validator.util.jsonflattener.JsonBaseCore;
import com.huawei.security.validator.util.jsonflattener.JsonProcessUtils;
import com.huawei.security.validator.util.jsonflattener.fastjson.JsonArray;
import com.huawei.security.validator.util.jsonflattener.fastjson.JsonObject;
import com.huawei.security.validator.util.jsonflattener.fastjson.JsonValue;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public final class FastJsonPerformanceProcess
implements JsonParseInterface {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public Object getJsonObject(String jsonObjectStr) throws ParseRequestDataException {
        if (EmptyUtils.isEmpty(jsonObjectStr)) {
            LOG.error("[WSF-ParamValidate] The FastJSONObject String for converting to FastJson is Empty.");
            throw new ParseRequestDataException("FastJson Failed to parse FastJSONObject String.");
        }
        try {
            String notEmptyJsonObjectStr = jsonObjectStr.trim();
            if (notEmptyJsonObjectStr.startsWith("{")) {
                return new JsonValue(JSON.parseObject((String)notEmptyJsonObjectStr));
            }
            if (notEmptyJsonObjectStr.startsWith("[")) {
                return new JsonValue(JSON.parseArray((String)notEmptyJsonObjectStr));
            }
            LOG.error("[WSF-ParamValidate] The FastJSONObject String has not correct Json struct.");
            throw new ParseRequestDataException("FastJson parse json occur exception.");
        }
        catch (JSONException e) {
            LOG.error("[WSF-ParamValidate] The FastJSONObject String has not correct Json struct.");
            throw new ParseRequestDataException("FastJson parse json occur exception.", e);
        }
        catch (Exception e) {
            LOG.error("[WSF-ParamValidate] Traverse json data occur exception.");
            throw new ParseRequestDataException("FastJson failed to parse JSONObject Sting.", e);
        }
    }

    @Override
    public void traverseJsonData(Object json, Map<String, List<String>> dataMap, String completeKey) throws ParseRequestDataException {
        if (!(json instanceof JsonValue)) {
            throw new ParseRequestDataException("FastJson Object not instance JsonValue.");
        }
        JsonBaseCore source = (JsonBaseCore)json;
        JsonProcessUtils.jsonTraverse(dataMap, source);
    }

    @Override
    public boolean isEmptyJson(Object fastJson) throws ParseRequestDataException {
        if (fastJson == null) {
            throw new ParseRequestDataException("fastJson content is null.");
        }
        if (fastJson instanceof JsonValue) {
            JsonValue fastJsonValue = (JsonValue)fastJson;
            if (fastJsonValue.isArray()) {
                JsonArray fastJsonArray = fastJsonValue.asArray();
                return fastJsonArray.isEmpty();
            }
            if (fastJsonValue.isObject()) {
                JsonObject fastJsonObject = fastJsonValue.asObject();
                return fastJsonObject.isEmpty();
            }
        }
        LOG.error("[WSF-ParamValidate] The fastJson input object is not belong to Json.");
        return false;
    }
}

