/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.JsonParseInterface;
import com.huawei.security.validator.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class FastJsonProcess
implements JsonParseInterface {
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private int level = -1;

    @Override
    public Object getJsonObject(String fastJsonObjectStr) throws ParseRequestDataException {
        if (EmptyUtils.isEmpty(fastJsonObjectStr)) {
            LOG.error("[WSF-ParamValidate] The JSONObject String for converting to FastJson is Empty.");
            throw new ParseRequestDataException("Failed to parse JSONObject String.");
        }
        try {
            String notEmptyJsonObjectStr = fastJsonObjectStr.trim();
            if (notEmptyJsonObjectStr.startsWith("{")) {
                return JSON.parseObject((String)notEmptyJsonObjectStr);
            }
            if (notEmptyJsonObjectStr.startsWith("[")) {
                return JSON.parseArray((String)notEmptyJsonObjectStr);
            }
            LOG.error("[WSF-ParamValidate] The JSONObject String has not correct Json struct.");
            throw new ParseRequestDataException("FastJson parse json occur exception.");
        }
        catch (JSONException e) {
            LOG.error("[WSF-ParamValidate] The JSONObject String has not correct Json struct.");
            throw new ParseRequestDataException("FastJson parse json occur exception.", e);
        }
        catch (Exception e) {
            LOG.error("[WSF-ParamValidate] Traverse json data occur exception.");
            throw new ParseRequestDataException("FastJson failed to parse JSONObject Sting.", e);
        }
    }

    @Override
    public boolean isEmptyJson(Object fastJson) throws ParseRequestDataException {
        if (fastJson == null) {
            throw new ParseRequestDataException("Json content is null.");
        }
        if (fastJson instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)fastJson;
            return jsonObj.isEmpty();
        }
        if (fastJson instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)fastJson;
            return jsonArray.isEmpty();
        }
        LOG.error("[WSF-ParamValidate] The input object is not belong to Json.");
        return false;
    }

    @Override
    public void traverseJsonData(Object fastJsonData, Map<String, List<String>> dataMap, String completeKey) throws ParseRequestDataException {
        try {
            if (fastJsonData instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)fastJsonData;
                this.handleJsonObjectByFastJson(dataMap, completeKey, jsonObject);
            } else if (fastJsonData instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)fastJsonData;
                this.handleJsonArrayByFastJson(dataMap, completeKey, jsonArray);
            } else {
                JsonUtil.processJsonValue(fastJsonData, dataMap, completeKey);
            }
        }
        catch (ClassCastException ex) {
            LOG.error("[WSF-ParamValidate] Traverse json data occur exception.");
            throw new ParseRequestDataException("Traverse json data occur exception.", ex);
        }
    }

    private void handleJsonObjectByFastJson(Map<String, List<String>> dataMap, String completeKey, JSONObject jsonObject) throws ParseRequestDataException {
        String completeKeyStr = completeKey;
        if (COMMON_CONFIG_BEAN.isParseEmptyMapArray() && jsonObject.isEmpty()) {
            JsonUtil.handleEmpty(completeKeyStr, dataMap);
        }
        this.initNeedCheckParamByFastJson(dataMap, completeKey);
        dataMap.put("deepIndex#@#", Collections.singletonList(String.valueOf(Integer.parseInt(dataMap.get("deepIndex#@#").get(0)) + 1)));
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            Object object = entry.getValue();
            completeKeyStr = completeKeyStr + "@#9#%*@" + key;
            this.traverseJsonData(object, dataMap, completeKeyStr);
            completeKeyStr = completeKeyStr.substring(0, completeKeyStr.lastIndexOf("@#9#%*@"));
        }
        dataMap.put("deepIndex#@#", Collections.singletonList(String.valueOf(Integer.parseInt(dataMap.get("deepIndex#@#").get(0)) - 1)));
        int fastCurrDeep = Integer.parseInt(dataMap.get("deepIndex#@#").get(0));
        if (fastCurrDeep == this.level && this.level != -1 && dataMap.get("needCheckParam#@#").size() > 0) {
            JsonUtil.handleDataMapOutOfJsonArray(dataMap, completeKey);
        }
    }

    private void initNeedCheckParamByFastJson(Map<String, List<String>> dataMap, String completeKey) {
        if (dataMap.get("needCheckParamFormValue#@#") == null && dataMap.get("needCheckParam#@#").size() > 0) {
            List<String> needCheckParamList = dataMap.get("needCheckParam#@#");
            List<String> convertedNeedCheckParamList = JsonUtil.convertParamListFromCurrentKey(needCheckParamList);
            this.level = JsonUtil.getJsonKeyLevel(completeKey, needCheckParamList);
            dataMap.put("needCheckParamFormObj#@#", new ArrayList<String>(convertedNeedCheckParamList));
        }
    }

    private void handleJsonArrayByFastJson(Map<String, List<String>> dataMap, String completeKey, JSONArray jsonArray) throws ParseRequestDataException {
        if (COMMON_CONFIG_BEAN.isParseEmptyMapArray() && jsonArray.isEmpty()) {
            JsonUtil.handleEmpty(completeKey, dataMap);
        }
        for (Object jsonObject : jsonArray) {
            this.traverseJsonData(jsonObject, dataMap, completeKey);
        }
    }
}

