/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.JsonParseInterface;
import com.huawei.security.validator.util.jsonflattener.JsonBaseCore;
import com.huawei.security.validator.util.jsonflattener.JsonProcessUtils;
import com.huawei.security.validator.util.jsonflattener.gson.JsonArray;
import com.huawei.security.validator.util.jsonflattener.gson.JsonObject;
import com.huawei.security.validator.util.jsonflattener.gson.JsonValue;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public final class GsonPerformanceProcess
implements JsonParseInterface {
    private static final Logger LOG = WSFValidatorLog.getLogger();

    @Override
    public Object getJsonObject(String jsonObjectStr) throws ParseRequestDataException {
        if (EmptyUtils.isEmpty(jsonObjectStr)) {
            LOG.error("[WSF-ParamValidate] The JSONObject String for converting to FastJson is Empty.");
            throw new ParseRequestDataException("Gson Failed to parse JSONObject String.");
        }
        try {
            String trimJsonObjectStr = jsonObjectStr.trim();
            Gson gson = new GsonBuilder().serializeNulls().create();
            JsonElement jsonValue = (JsonElement)gson.fromJson(trimJsonObjectStr, JsonElement.class);
            return new JsonValue(jsonValue);
        }
        catch (JsonParseException e) {
            LOG.error("[WSF-ParamValidate] The JSONObject String has not correct Json struct.");
            throw new ParseRequestDataException("Gson parse json occur exception.", e);
        }
        catch (Exception e) {
            LOG.error("[WSF-ParamValidate] Traverse json data occur exception.");
            throw new ParseRequestDataException("Gson failed to parse JSONObject Sting.", e);
        }
    }

    @Override
    public void traverseJsonData(Object json, Map<String, List<String>> dataMap, String completeKey) throws ParseRequestDataException {
        if (!(json instanceof JsonValue)) {
            throw new ParseRequestDataException("Gson Object not instance JsonValue.");
        }
        JsonBaseCore source = (JsonBaseCore)json;
        JsonProcessUtils.jsonTraverse(dataMap, source);
    }

    @Override
    public boolean isEmptyJson(Object gson) throws ParseRequestDataException {
        if (gson == null) {
            throw new ParseRequestDataException("gson content is null.");
        }
        if (gson instanceof JsonValue) {
            JsonValue gsonValue = (JsonValue)gson;
            if (gsonValue.isArray()) {
                JsonArray gsonArray = gsonValue.asArray();
                return gsonArray.isEmpty();
            }
            if (gsonValue.isObject()) {
                JsonObject gsonObject = gsonValue.asObject();
                return gsonObject.isEmpty();
            }
        }
        LOG.error("[WSF-ParamValidate] The gson input object is not belong to Json.");
        return false;
    }
}

