/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import java.nio.ByteBuffer;

public class IPUtil {
    private static final int NUM_ZERO = 0;
    private static final int NUM_ONE = 1;
    private static final int NUM_TWO = 2;
    private static final int NUM_THREE = 3;
    private static final int HEX_ONE_BYTE = 255;
    private static final int IPV4_PART_UP_LIMIT = 255;
    private static final int IPV4_PART_COUNT = 4;
    private static final int OFFSET_NUM_EIGHT = 8;
    private static final int IPV6_PART_COUNT = 8;
    private static final int BUFFER_SIZE = 16;
    private static final int SCALE_OCT = 10;
    private static final int SCALE_HEX = 16;
    private static final char DOT_DELIMITER = '.';
    private static final char COLON_DELIMITER = ':';
    private static final char PERCENT_DELIMITER = '%';
    private static final String PREFIX_ZERO = "0";

    public static boolean checkIP(String ipAddress) {
        char[] chs = ipAddress.toCharArray();
        boolean containsColon = false;
        boolean containsDot = false;
        int percentLocation = -1;
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i] == '.') {
                containsDot = true;
                continue;
            }
            if (chs[i] == ':') {
                if (containsDot) {
                    return false;
                }
                containsColon = true;
                continue;
            }
            if (chs[i] == '%') {
                percentLocation = i;
                break;
            }
            if (Character.digit(chs[i], 16) != -1) continue;
            return false;
        }
        return IPUtil.ipCheck(containsDot, containsColon, percentLocation, ipAddress);
    }

    private static boolean ipCheck(boolean containsDot, boolean containsColon, int percentLocation, String ipAddress) {
        if (containsColon) {
            String formatIpAddress = ipAddress;
            if (containsDot) {
                try {
                    formatIpAddress = IPUtil.convertV6SuffixToFormatString(formatIpAddress);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (percentLocation != -1) {
                formatIpAddress = formatIpAddress.substring(0, percentLocation);
            }
            return IPUtil.ipStringFormatV6Bytes(formatIpAddress).length != 0;
        }
        if (containsDot) {
            if (percentLocation != -1) {
                return false;
            }
            return IPUtil.ipStringFormatV4Bytes(ipAddress).length != 0;
        }
        return false;
    }

    private static String convertV6SuffixToFormatString(String ipAddress) {
        int endColonIndex = ipAddress.lastIndexOf(58);
        String v6Partial = ipAddress.substring(0, endColonIndex + 1);
        String v4Partial = ipAddress.substring(endColonIndex + 1);
        byte[] v4Byte = IPUtil.ipStringFormatV4Bytes(v4Partial);
        if (v4Byte.length == 0) {
            throw new NumberFormatException();
        }
        String lastButOne = Integer.toHexString((v4Byte[0] & 0xFF) << 8 | v4Byte[1] & 0xFF);
        String lastV6Part = Integer.toHexString((v4Byte[2] & 0xFF) << 8 | v4Byte[3] & 0xFF);
        return v6Partial + lastButOne + ':' + lastV6Part;
    }

    private static byte[] ipStringFormatV4Bytes(String ipAddress) {
        int colonCount = IPUtil.charCount(ipAddress, '.');
        if (colonCount != 3) {
            return new byte[0];
        }
        byte[] bytes = new byte[4];
        int beginIndex = 0;
        for (int i = 0; i < 4; ++i) {
            int endIndex = ipAddress.indexOf(46, beginIndex);
            if (endIndex == -1) {
                endIndex = ipAddress.length();
            }
            try {
                bytes[i] = IPUtil.convertV4ToByte(ipAddress.substring(beginIndex, endIndex));
            }
            catch (NumberFormatException ex) {
                return new byte[0];
            }
            beginIndex = endIndex + 1;
        }
        return bytes;
    }

    private static int charCount(String ipAddress, char ch) {
        int count = 0;
        for (char cc : ipAddress.toCharArray()) {
            if (cc != ch) continue;
            ++count;
        }
        return count;
    }

    private static byte convertV4ToByte(String ipSegment) {
        int len = ipSegment.length();
        if (len <= 0 || len > 3) {
            throw new NumberFormatException();
        }
        if (len > 1 && ipSegment.startsWith(PREFIX_ZERO)) {
            throw new NumberFormatException();
        }
        int val = IPUtil.calculateV4Val(ipSegment);
        if (val > 255) {
            throw new NumberFormatException();
        }
        return (byte)val;
    }

    private static int calculateV4Val(String ipSegment) {
        char[] chs;
        for (char ch : chs = ipSegment.toCharArray()) {
            if (Character.isDigit(ch)) continue;
            throw new NumberFormatException();
        }
        return Integer.parseInt(ipSegment);
    }

    private static byte[] ipStringFormatV6Bytes(String ipAddress) {
        int colonCount = IPUtil.charCount(ipAddress, ':');
        if (colonCount < 2 || colonCount > 8) {
            return new byte[0];
        }
        int partsSkipped = 8 - (colonCount + 1);
        boolean containsSkip = false;
        for (int i = 0; i < ipAddress.length() - 1; ++i) {
            boolean isPrefixOrSuffixColon;
            boolean abbrFormat;
            boolean bl = abbrFormat = ipAddress.charAt(i) == ':' && ipAddress.charAt(i + 1) == ':';
            if (!abbrFormat) continue;
            if (containsSkip) {
                return new byte[0];
            }
            containsSkip = true;
            ++partsSkipped;
            boolean bl2 = isPrefixOrSuffixColon = i == 0 || i == ipAddress.length() - 2;
            if (!isPrefixOrSuffixColon) continue;
            ++partsSkipped;
        }
        if (IPUtil.ipv6FormatCheck(ipAddress, colonCount, partsSkipped, containsSkip)) {
            return new byte[0];
        }
        ByteBuffer v6Bytes = ByteBuffer.allocate(16);
        try {
            IPUtil.ipv6ConvertToByte(ipAddress, partsSkipped, v6Bytes);
        }
        catch (NumberFormatException ex) {
            return new byte[0];
        }
        return v6Bytes.array();
    }

    private static void ipv6ConvertToByte(String ipAddress, int partsSkipped, ByteBuffer v6Bytes) {
        int beginIndex = 0;
        if (ipAddress.charAt(0) == ':') {
            beginIndex = 1;
        }
        while (beginIndex < ipAddress.length()) {
            int endIndex = ipAddress.indexOf(58, beginIndex);
            if (endIndex == -1) {
                endIndex = ipAddress.length();
            }
            if (ipAddress.charAt(beginIndex) == ':') {
                for (int i = 0; i < partsSkipped; ++i) {
                    v6Bytes.putShort((short)0);
                }
            } else {
                v6Bytes.putShort(IPUtil.convertHexToOct(ipAddress.substring(beginIndex, endIndex)));
            }
            beginIndex = endIndex + 1;
        }
    }

    private static boolean ipv6FormatCheck(String ipAddress, int colonCount, int partsSkipped, boolean containsSkip) {
        boolean prefixOrSuffixWithOneColon;
        boolean bl = prefixOrSuffixWithOneColon = ipAddress.charAt(0) == ':' && ipAddress.charAt(1) != ':' || ipAddress.charAt(ipAddress.length() - 1) == ':' && ipAddress.charAt(ipAddress.length() - 2) != ':';
        if (prefixOrSuffixWithOneColon) {
            return true;
        }
        if (containsSkip && partsSkipped <= 0) {
            return true;
        }
        return !containsSkip && colonCount + 1 != 8;
    }

    private static short convertHexToOct(String ipv6Segment) {
        char[] chs;
        int len = ipv6Segment.length();
        if (len <= 0 || len > 4) {
            throw new NumberFormatException();
        }
        int octVal = 0;
        for (char ch : chs = ipv6Segment.toCharArray()) {
            octVal *= 16;
            octVal += Character.digit(ch, 16);
        }
        return (short)octVal;
    }
}

