/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.huawei.security.validator.config.FileUtil;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.Resources;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;

public final class InternalMessage {
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private static final Object LOCK = new Object();
    private static final String PROPERTY_KEY = ".properties";
    private static volatile ResourceBundle resourceBundle;
    private static Locale localeValue;

    private InternalMessage() {
    }

    public static void setLocaleValue(Locale localeValue) {
        InternalMessage.localeValue = localeValue;
    }

    public static void init() {
        if (localeValue == null) {
            LOG.debug("[WSF-ParamValidate] Can't find i18n files.");
            return;
        }
        try {
            resourceBundle = ResourceBundle.getBundle("validator.locale.resource.message", localeValue);
        }
        catch (MissingResourceException e) {
            LOG.debug("[WSF-ParamValidate] Can't find i18n files occur MissingResourceException.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(ClassLoader clazz, String contextPath) {
        Locale locale = localeValue;
        if (locale == null) {
            LOG.debug("[WSF-ParamValidate] The request language is empty, localeValue is null.");
            locale = new Locale("zh_CN");
        }
        try {
            resourceBundle = ResourceBundle.getBundle("validator.locale.resource.message", locale);
        }
        catch (MissingResourceException e) {
            ClassLoader[] loaders;
            for (ClassLoader loader : loaders = new ClassLoader[]{clazz, Thread.currentThread().getContextClassLoader(), InternalMessage.class.getClassLoader(), ClassLoader.getSystemClassLoader()}) {
                if (loader == null) continue;
                try {
                    resourceBundle = ResourceBundle.getBundle("validator.locale.resource.message", locale, loader);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
            }
        }
        if (resourceBundle == null) {
            Object object = LOCK;
            synchronized (object) {
                InternalMessage.setResourceBundle(clazz, contextPath, locale);
            }
        }
    }

    private static void setResourceBundle(ClassLoader clazz, String contextPath, Locale locale) {
        if (resourceBundle == null) {
            String i18nFileName = contextPath + "WEB-INF" + File.separator + "classes" + File.separator + "validator" + File.separator + "locale" + File.separator + "resource" + File.separator + "message_" + locale.toString() + PROPERTY_KEY;
            File i18nFile = FileUtil.getFile(i18nFileName);
            if (i18nFile.exists()) {
                try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(i18nFile));){
                    resourceBundle = new PropertyResourceBundle(inputStream);
                }
                catch (IOException ex) {
                    LOG.debug("[WSF-ParamValidate] Could not find resource message_{}.properties.", (Object)locale.toString());
                }
            } else {
                try (InputStream inputStream = Resources.getResourceAsStream(clazz, "validator/locale/resource/message_" + locale.toString() + PROPERTY_KEY);){
                    resourceBundle = new PropertyResourceBundle(inputStream);
                }
                catch (IOException e) {
                    LOG.debug("[WSF-ParamValidate] Could not find resource message_{}.properties.", (Object)locale.toString());
                }
            }
        }
    }

    public static void init(String baseName) {
        File i18nFile;
        String localeString = "en_US";
        if (localeValue != null) {
            localeString = localeValue.toString();
        }
        if (!(i18nFile = FileUtil.getFile(baseName + "_" + localeString + PROPERTY_KEY)).exists()) {
            i18nFile = FileUtil.getFile(baseName + PROPERTY_KEY);
        }
        if (i18nFile.exists()) {
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(i18nFile));){
                resourceBundle = new PropertyResourceBundle(inputStream);
            }
            catch (IOException ex) {
                LOG.debug("[WSF-ParamValidate] Load i18n files failed: {}", (Object)ex.getMessage());
            }
        } else {
            LOG.debug("[WSF-ParamValidate] Can't find i18n files.");
        }
    }

    public static <T> String getMessage(String key, T ... params) {
        String str = "";
        if (EmptyUtils.hasText(key)) {
            str = key;
            if (resourceBundle == null) {
                return str;
            }
            if (resourceBundle.containsKey(key)) {
                String resource = resourceBundle.getString(key);
                MessageFormat format = new MessageFormat(resource, localeValue);
                str = format.format(params);
            }
        } else {
            LOG.warn("[WSF-ParamValidate] ErrorMessage attribute is not config.");
        }
        return str;
    }

    public static String getMessage(String key) {
        if (EmptyUtils.hasText(key)) {
            if (resourceBundle != null && resourceBundle.containsKey(key)) {
                return resourceBundle.getString(key);
            }
            return key;
        }
        LOG.warn("[WSF-ParamValidate] ErrorMessage attribute is not config.");
        return "";
    }
}

