/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.JsonParseInterface;
import com.huawei.security.validator.util.JsonUtil;
import com.huawei.security.validator.util.jackson.JSONArray;
import com.huawei.security.validator.util.jackson.JSONException;
import com.huawei.security.validator.util.jackson.JSONObject;
import com.huawei.security.validator.util.jackson.JsonJacksonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class JacksonJsonProcess
implements JsonParseInterface {
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private int level = -1;

    @Override
    public Object getJsonObject(String jsonObjectStr) throws ParseRequestDataException {
        if (EmptyUtils.isEmpty(jsonObjectStr)) {
            LOG.error("[WSF-ParamValidate] The JSONObject Sting for translating is empty.");
            throw new ParseRequestDataException("Failed to parse JSONObject String.");
        }
        try {
            String notEmptyJsonObjectStr = jsonObjectStr.trim();
            if (notEmptyJsonObjectStr.startsWith("{")) {
                ObjectMapper objectMapper = JsonJacksonUtil.initMapper();
                return JSONObject.fromObject(notEmptyJsonObjectStr, objectMapper);
            }
            if (notEmptyJsonObjectStr.startsWith("[")) {
                ObjectMapper objectMapper = JsonJacksonUtil.initMapper();
                return JSONArray.fromObject(notEmptyJsonObjectStr, objectMapper);
            }
            LOG.error("[WSF-ParamValidate] The JSONObject Sting has not correct Json struct.");
            throw new ParseRequestDataException("Failed to parse JSONObject String.");
        }
        catch (JSONException e) {
            LOG.error("[WSF-ParamValidate] The JSONObject Sting has not correct Json struct.");
            throw new ParseRequestDataException("Failed to parse JSONObject String.", e);
        }
        catch (Exception e) {
            LOG.error("[WSF-ParamValidate] Traverse json data occur exception.");
            throw new ParseRequestDataException("Failed to parse JSONObject String.", e);
        }
    }

    @Override
    public boolean isEmptyJson(Object jacksonJson) throws ParseRequestDataException {
        if (jacksonJson == null) {
            throw new ParseRequestDataException("Json content is null.");
        }
        if (jacksonJson instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)jacksonJson;
            return jsonObj.isEmpty();
        }
        if (jacksonJson instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)jacksonJson;
            return jsonArray.isEmpty();
        }
        return false;
    }

    @Override
    public void traverseJsonData(Object jacksonJsonData, Map<String, List<String>> dataMap, String completeKey) throws ParseRequestDataException {
        try {
            if (jacksonJsonData instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)jacksonJsonData;
                this.handleJsonObjectByJackson(dataMap, completeKey, jsonObject);
            } else if (jacksonJsonData instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)jacksonJsonData;
                this.handleJsonArrayByJackson(dataMap, completeKey, jsonArray);
            } else {
                JsonUtil.processJsonValue(jacksonJsonData, dataMap, completeKey);
            }
        }
        catch (ClassCastException e) {
            LOG.error("[WSF-ParamValidate] Traverse json data occur exception.");
            throw new ParseRequestDataException("Traverse json data occur exception.", e);
        }
    }

    private void handleJsonObjectByJackson(Map<String, List<String>> dataMap, String completeKey, JSONObject jsonObject) throws ParseRequestDataException {
        String completeKeyTmp = completeKey;
        if (COMMON_CONFIG_BEAN.isParseEmptyMapArray() && jsonObject.isEmpty()) {
            JsonUtil.handleEmpty(completeKeyTmp, dataMap);
        }
        this.initNeedCheckParamByJackson(dataMap, completeKey);
        dataMap.put("deepIndex#@#", Collections.singletonList(String.valueOf(Integer.parseInt(dataMap.get("deepIndex#@#").get(0)) + 1)));
        for (Map.Entry<String, Object> entry : jsonObject.entrySet()) {
            String key = entry.getKey();
            Object object = entry.getValue();
            completeKeyTmp = completeKeyTmp + "@#9#%*@" + key;
            this.traverseJsonData(object, dataMap, completeKeyTmp);
            completeKeyTmp = completeKeyTmp.substring(0, completeKeyTmp.lastIndexOf("@#9#%*@"));
        }
        dataMap.put("deepIndex#@#", Collections.singletonList(String.valueOf(Integer.parseInt(dataMap.get("deepIndex#@#").get(0)) - 1)));
        int jacksonCurrDeep = Integer.parseInt(dataMap.get("deepIndex#@#").get(0));
        if (jacksonCurrDeep == this.level && this.level != -1 && dataMap.get("needCheckParam#@#").size() > 0) {
            JsonUtil.handleDataMapOutOfJsonArray(dataMap, completeKey);
        }
    }

    private void initNeedCheckParamByJackson(Map<String, List<String>> dataMap, String completeKey) {
        if (dataMap.get("needCheckParamFormValue#@#") == null && dataMap.get("needCheckParam#@#").size() > 0) {
            List<String> xmlNeedCheckParamList = dataMap.get("needCheckParam#@#");
            List<String> needCheckParamList = JsonUtil.convertParamListFromCurrentKey(xmlNeedCheckParamList);
            this.level = JsonUtil.getJsonKeyLevel(completeKey, xmlNeedCheckParamList);
            dataMap.put("needCheckParamFormObj#@#", new ArrayList<String>(needCheckParamList));
        }
    }

    private void handleJsonArrayByJackson(Map<String, List<String>> dataMap, String completeKey, JSONArray jsonArray) throws ParseRequestDataException {
        if (COMMON_CONFIG_BEAN.isParseEmptyMapArray() && jsonArray.isEmpty()) {
            JsonUtil.handleEmpty(completeKey, dataMap);
        }
        for (Object jsonObject : jsonArray) {
            this.traverseJsonData(jsonObject, dataMap, completeKey);
        }
    }
}

