/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.huawei.security.validator.config.FileCache;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.EmptyUtils;
import com.huawei.security.validator.util.JsonParseInterface;
import com.huawei.security.validator.util.LogUtils;
import org.slf4j.Logger;

public final class JsonParseFactory {
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private static JsonParseInterface jsonParser = null;

    private JsonParseFactory() {
    }

    public static JsonParseInterface getJsonParser() {
        return jsonParser;
    }

    static {
        Class<?> clazz = null;
        try {
            String parseType = FileCache.getInstance().getCommonConfigsBean().getJsonParserType();
            String classPath = FileCache.getInstance().getCommonConfigsBean().getClassPath();
            if (parseType != null) {
                parseType = parseType.trim();
            }
            if ("Jackson".equalsIgnoreCase(parseType)) {
                LOG.info("[WSF-ParamValidate] The parse type is {}, it will use JacksonJsonProcess.", (Object)LogUtils.cleanLog(parseType));
                clazz = Class.forName("com.huawei.security.validator.util.JacksonJsonProcess");
            } else if ("Gson".equalsIgnoreCase(parseType)) {
                LOG.info("[WSF-ParamValidate] The parse type is {}, it will use GsonJsonProcess.", (Object)LogUtils.cleanLog(parseType));
                clazz = Class.forName("com.huawei.security.validator.util.GsonJsonProcess");
            } else if ("JacksonPerformance".equalsIgnoreCase(parseType)) {
                LOG.info("[WSF-ParamValidate] The parse type is {}, it will use userDefined.", (Object)LogUtils.cleanLog(parseType));
                clazz = Class.forName("com.huawei.security.validator.util.JacksonPerformanceProcess");
            } else if ("GsonPerformance".equalsIgnoreCase(parseType)) {
                LOG.info("[WSF-ParamValidate] The parse type is {}, it will use userDefined.", (Object)LogUtils.cleanLog(parseType));
                clazz = Class.forName("com.huawei.security.validator.util.GsonPerformanceProcess");
            } else if ("FastJsonPerformance".equalsIgnoreCase(parseType)) {
                LOG.info("[WSF-ParamValidate] The parse type is {}, it will use userDefined.", (Object)LogUtils.cleanLog(parseType));
                clazz = Class.forName("com.huawei.security.validator.util.FastJsonPerformanceProcess");
            } else if ("OrgJsonPerformance".equalsIgnoreCase(parseType)) {
                LOG.info("[WSF-ParamValidate] The parse type is {}, it will use userDefined.", (Object)LogUtils.cleanLog(parseType));
                clazz = Class.forName("com.huawei.security.validator.util.OrgJsonPerformanceProcess");
            } else if ("userDefined".equalsIgnoreCase(parseType)) {
                LOG.info("[WSF-ParamValidate] The parse type is {}, it will use userDefined.", (Object)LogUtils.cleanLog(parseType));
                if (EmptyUtils.isEmpty(classPath)) {
                    classPath = "com.huawei.security.validator.util.DefaultUserDefinedProcess";
                }
                clazz = Class.forName(classPath);
            } else {
                LOG.info("[WSF-ParamValidate] The parse type is {}, it will use FastJsonProcess.", (Object)LogUtils.cleanLog(parseType));
                clazz = Class.forName("com.huawei.security.validator.util.FastJsonProcess");
            }
            Object jsonParserInstance = clazz.newInstance();
            if (jsonParserInstance instanceof JsonParseInterface) {
                jsonParser = (JsonParseInterface)jsonParserInstance;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            LOG.error(ex.getMessage());
        }
        if (jsonParser == null) {
            LOG.info("[WSF-ParamValidate] The parse have failed, it will use FastJsonProcess default handle.");
            try {
                clazz = Class.forName("com.huawei.security.validator.util.FastJsonProcess");
                Object jasonParseInstance = clazz.newInstance();
                if (jasonParseInstance instanceof JsonParseInterface) {
                    jsonParser = (JsonParseInterface)jasonParseInstance;
                } else {
                    LOG.error("[WSF-ParamValidate] Can't creat a new json parser instance.");
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                LOG.error(ex.getMessage());
            }
        }
    }
}

