/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public final class RegExpExecutor {
    private static final Map<String, Pattern> CACHE_COMPILE_RESULT = new ConcurrentHashMap<String, Pattern>(64);

    private RegExpExecutor() {
    }

    public static <T> boolean validate(String expression, boolean caseSensitive, T value, boolean isFind) {
        String key;
        Pattern pattern;
        boolean isEndWithQuotes;
        boolean result = true;
        String inputExpression = expression;
        if (!(value instanceof String)) {
            return result;
        }
        boolean isStartWithQuotes = inputExpression.startsWith("'") || inputExpression.startsWith("\"");
        boolean bl = isEndWithQuotes = inputExpression.endsWith("'") || inputExpression.endsWith("\"");
        if (isStartWithQuotes) {
            inputExpression = inputExpression.substring(1);
        }
        if (isEndWithQuotes) {
            inputExpression = inputExpression.substring(0, inputExpression.length() - 1);
        }
        if ((pattern = CACHE_COMPILE_RESULT.get(key = inputExpression + caseSensitive)) == null) {
            pattern = caseSensitive ? Pattern.compile(inputExpression) : Pattern.compile(inputExpression, 2);
            CACHE_COMPILE_RESULT.put(key, pattern);
        }
        String compare = String.valueOf(value);
        Matcher matcher = pattern.matcher(compare);
        result = isFind ? matcher.find() : matcher.matches();
        return result;
    }

    public static <T> boolean validateWithPreExpressions(String expression, String[] preExpressions, boolean caseSensitive, T value, boolean isFind) {
        if (StringUtils.isEmpty((Object)expression)) {
            return false;
        }
        if (Objects.isNull(preExpressions)) {
            return RegExpExecutor.validate(expression, caseSensitive, value, isFind);
        }
        for (String preExpression : preExpressions) {
            if (RegExpExecutor.validate(preExpression, caseSensitive, value, isFind)) continue;
            return false;
        }
        return RegExpExecutor.validate(expression, caseSensitive, value, isFind);
    }
}

