/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.security.validator.util;

import com.huawei.security.validator.bean.XMLParamNumberCheckBean;
import com.huawei.security.validator.exception.ParseRequestDataException;
import com.huawei.security.validator.log.WSFValidatorLog;
import com.huawei.security.validator.util.LogUtils;
import com.huawei.security.validator.util.PathUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLProcessUtil {
    private static final Logger LOG = WSFValidatorLog.getLogger();
    private static final XPath XPATH;

    private XMLProcessUtil() {
    }

    /*
     * Exception decompiling
     */
    public static Document getXMLDocument(String xmlData) throws ParseRequestDataException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> getXMLParamValue(org.w3c.dom.Document w3cDoc, Map<String, String> map, String paramName) throws ParseRequestDataException {
        NodeList nodes = XMLProcessUtil.xPathEvaluate(w3cDoc, map, paramName).orElse(null);
        ArrayList<String> valueList = new ArrayList<String>(10);
        if (nodes == null || nodes.getLength() == 0) {
            LOG.info("[WSF-ParamValidate] Can't find xml node data, node is {}.", (Object)LogUtils.cleanLog(paramName));
            return valueList;
        }
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            String paraValue;
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                paraValue = PathUtil.getFirstTextContent(node);
                valueList.add(paraValue);
                continue;
            }
            if (node.getNodeType() == 2) {
                paraValue = node.getNodeValue();
                valueList.add(paraValue);
                continue;
            }
            LOG.error("[WSF-ParamValidate] Node type is error.");
        }
        return valueList;
    }

    private static Optional<NodeList> xPathEvaluate(org.w3c.dom.Document parse, final Map<String, String> map, String paramName) throws ParseRequestDataException {
        Object evaluate;
        try {
            XPATH.setNamespaceContext(new NamespaceContext(){

                public Iterator getPrefixes(String arg0) {
                    return null;
                }

                @Override
                public String getPrefix(String arg0) {
                    return null;
                }

                @Override
                public String getNamespaceURI(String arg0) {
                    return (String)map.get(arg0);
                }
            });
            XPathExpression expr = XPATH.compile(paramName);
            evaluate = expr.evaluate(parse, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new ParseRequestDataException("Exception occurred evaluate XPath: " + paramName);
        }
        if (evaluate instanceof NodeList) {
            return Optional.of((NodeList)evaluate);
        }
        return Optional.empty();
    }

    public static Map<String, List<String>> getXMLParamInfo(org.w3c.dom.Document doc, Map<String, String> nameSpaces, String paramName, Map<Node, String> xpathObjectMap) throws ParseRequestDataException {
        LOG.info("[WSF-ParamValidate] Config pattern xpath is {}.", (Object)LogUtils.cleanLog(paramName));
        NodeList nodes = XMLProcessUtil.xPathEvaluate(doc, nameSpaces, paramName).orElse(null);
        HashMap<String, List<String>> nodeInfoMap = new HashMap<String, List<String>>();
        if (nodes == null || nodes.getLength() == 0) {
            LOG.info("[WSF-ParamValidate] Can't find xml node data, node is {}.", (Object)LogUtils.cleanLog(paramName));
            return nodeInfoMap;
        }
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                NodeList childNodes = element.getChildNodes();
                if (PathUtil.elements(childNodes)) continue;
                XMLProcessUtil.getValueFromNode(nodeInfoMap, PathUtil.getFullXPath(element), element.getTextContent());
                xpathObjectMap.put(element, "");
                continue;
            }
            if (node.getNodeType() == 2) {
                Attr attribute = (Attr)node;
                XMLProcessUtil.getValueFromNode(nodeInfoMap, PathUtil.getFullXPath(attribute), attribute.getTextContent());
                xpathObjectMap.put(attribute, "");
                continue;
            }
            LOG.error("[WSF-ParamValidate] Node type is error.");
        }
        return nodeInfoMap;
    }

    private static void getValueFromNode(Map<String, List<String>> nodeInfoMap, String fullXPath, String textContent) {
        if (nodeInfoMap.containsKey(fullXPath)) {
            nodeInfoMap.get(fullXPath).add(textContent);
        } else {
            ArrayList<String> xpathList = new ArrayList<String>(10);
            xpathList.add(textContent);
            nodeInfoMap.put(fullXPath, xpathList);
        }
    }

    public static Map<String, XMLParamNumberCheckBean> getAllXPath(Document dom) {
        HashMap<String, XMLParamNumberCheckBean> xpathMap = new HashMap<String, XMLParamNumberCheckBean>(16);
        org.dom4j.Element rootElement = dom.getRootElement();
        XMLProcessUtil.traverseXMLData(rootElement, xpathMap);
        return xpathMap;
    }

    private static void traverseXMLData(org.dom4j.Element element, Map<String, XMLParamNumberCheckBean> xpathMap) {
        ArrayList<String> valueObjectList;
        XMLParamNumberCheckBean bean;
        Iterator attributeIterator = element.attributeIterator();
        while (attributeIterator.hasNext()) {
            Attribute attribute = (Attribute)attributeIterator.next();
            String attrValue = attribute.getStringValue();
            String attributeXpath = attribute.getPath();
            if (xpathMap.containsKey(attributeXpath)) {
                bean = xpathMap.get(attributeXpath);
                bean.getValueList().add(attrValue);
                bean.setRequestValueNumbers(bean.getRequestValueNumbers() + 1);
                continue;
            }
            bean = new XMLParamNumberCheckBean();
            valueObjectList = new ArrayList<String>(10);
            valueObjectList.add(attrValue);
            bean.setValueList(valueObjectList);
            bean.setRequestValueNumbers(bean.getRequestValueNumbers() + 1);
            xpathMap.put(attributeXpath, bean);
        }
        List elements = element.elements();
        if (elements.isEmpty()) {
            String nodeValue = element.getStringValue();
            String elementXpath = element.getPath();
            if (xpathMap.containsKey(elementXpath)) {
                bean = xpathMap.get(elementXpath);
                bean.getValueList().add(nodeValue);
                bean.setRequestValueNumbers(bean.getRequestValueNumbers() + 1);
            } else {
                bean = new XMLParamNumberCheckBean();
                valueObjectList = new ArrayList(10);
                valueObjectList.add(nodeValue);
                bean.setValueList(valueObjectList);
                bean.setRequestValueNumbers(bean.getRequestValueNumbers() + 1);
                xpathMap.put(elementXpath, bean);
            }
        } else {
            for (org.dom4j.Element elem : elements) {
                XMLProcessUtil.traverseXMLData(elem, xpathMap);
            }
        }
    }

    private static /* synthetic */ InputSource lambda$getXMLDocument$0(String publicId, String systemId) throws SAXException, IOException {
        return new InputSource();
    }

    static {
        XPathFactory factory = XPathFactory.newInstance();
        XPATH = factory.newXPath();
    }
}

